/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.updater;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.api.event.EventManager;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.utils.XPathUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.social.addons.storage.RDBMSActivityStorageImpl;
import org.exoplatform.social.addons.storage.RDBMSIdentityStorageImpl;
import org.exoplatform.social.addons.storage.dao.ActivityDAO;
import org.exoplatform.social.addons.updater.AbstractMigrationService;
import org.exoplatform.social.addons.updater.ActivityUpdaterEntity;
import org.exoplatform.social.addons.updater.MigrationContext;
import org.exoplatform.social.addons.updater.utils.MigrationCounter;
import org.exoplatform.social.addons.updater.utils.StringUtil;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.chromattic.entity.ActivityEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityListEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityParameters;
import org.exoplatform.social.core.chromattic.entity.HidableEntity;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.utils.ActivityIterator;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.exception.NodeNotFoundException;
import org.exoplatform.social.core.storage.impl.ActivityStorageImpl;
import org.exoplatform.social.core.storage.impl.IdentityStorageImpl;
import org.exoplatform.social.core.storage.query.JCRProperties;

@Managed
@ManagedDescription(value="Social migration activities from JCR to RDBMS.")
@NameTemplate(value={@Property(key="service", value="social"), @Property(key="view", value="migration-activities")})
public class ActivityMigrationService
extends AbstractMigrationService<ExoSocialActivity> {
    private static final int LIMIT_REMOVED_THRESHOLD = 10;
    private static final int LIMIT_ACTIVITY_SAVE_THRESHOLD = 10;
    private static final int LIMIT_ACTIVITY_REF_SAVE_THRESHOLD = 50;
    public static final String EVENT_LISTENER_KEY = "SOC_ACTIVITY_MIGRATION";
    private static final Pattern MENTION_PATTERN = Pattern.compile("@([^\\s]+)|@([^\\s]+)$");
    public static final Pattern USER_NAME_VALIDATOR_REGEX = Pattern.compile("^[\\p{L}][\\p{L}._\\-\\d]+$");
    public static final String COMMENT_PREFIX = "comment";
    private final ActivityStorage activityStorage;
    private final ActivityStorageImpl activityJCRStorage;
    protected final RDBMSIdentityStorageImpl identityJPAStorage;
    private final ActivityDAO activityDAO;
    private String previousActivityId = null;
    private ActivityEntity lastActivity = null;
    private String lastUserProcess = null;
    private boolean forceStop = false;
    private Set<String> identitiesMigrateFailed = new HashSet<String>();
    private Set<String> identitiesCleanupFailed = new HashSet<String>();

    public ActivityMigrationService(InitParams initParams, ActivityDAO activityDAO, RDBMSActivityStorageImpl activityStorage, ActivityStorageImpl activityJCRStorage, IdentityStorageImpl identityStorage, RDBMSIdentityStorageImpl rdbmsIdentityStorage, EventManager<ExoSocialActivity, String> eventManager, EntityManagerService entityManagerService) {
        super(initParams, identityStorage, eventManager, entityManagerService);
        this.identityJPAStorage = rdbmsIdentityStorage;
        this.activityDAO = activityDAO;
        this.activityStorage = activityStorage;
        this.activityJCRStorage = activityJCRStorage;
        this.LIMIT_THRESHOLD = this.getInteger(initParams, "LIMIT_THRESHOLD", 100);
    }

    @Override
    @Managed
    @ManagedDescription(value="Manual to start run miguration data of activities from JCR to RDBMS.")
    public void doMigration() throws Exception {
        RequestLifeCycle.end();
        this.numberFailed += this.migrateUserActivities();
        this.numberFailed += this.migrateSpaceActivities();
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long migrateUserActivities() throws Exception {
        this.LOG.info((Object)"| \\ Start:: migrate activity of users -------------");
        long totalUsers = this.getNumberUserIdentities();
        MigrationCounter counter = MigrationCounter.builder().threshold(this.LIMIT_THRESHOLD).build();
        counter.newTotalAndWatch();
        long numberUserFailed = 0L;
        boolean cont = true;
        while (cont && !this.forkStop) {
            try {
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                NodeIterator it = this.getIdentityNodes(counter.getTotal(), this.LIMIT_THRESHOLD);
                if (it == null || it.getSize() <= 0L) {
                    cont = false;
                    continue;
                }
                Identity owner = null;
                Node node = null;
                while (it != null && it.hasNext() && !this.forkStop) {
                    node = (Node)it.next();
                    owner = this.identityStorage.findIdentityById(node.getUUID());
                    counter.newBatchAndWatch();
                    counter.getAndIncrementTotal();
                    this.LOG.info((Object)String.format("|  \\ START::user number: %s/%s (%s user)", counter.getTotal(), totalUsers, owner.getRemoteId()));
                    IdentityEntity identityEntity = (IdentityEntity)this._findById(IdentityEntity.class, owner.getId());
                    try {
                        this.migrationByIdentity(null, identityEntity);
                    }
                    catch (Exception ex) {
                        ++numberUserFailed;
                        this.identitiesMigrateFailed.add(node.getName());
                        this.LOG.error((Object)String.format("Failed migrate user %s", owner.getRemoteId()), (Throwable)ex);
                    }
                    this.LOG.info((Object)String.format("|  / END:: migrate activity of user %s consumed %s(ms) -------------", owner.getRemoteId(), counter.endBatchWatch()));
                    if (!counter.isPersistPoint()) continue;
                    RequestLifeCycle.end();
                    RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                    it = this.getIdentityNodes(counter.getTotal(), this.LIMIT_THRESHOLD);
                }
            }
            catch (Exception ex) {
                this.LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
        if (numberUserFailed > 0L) {
            this.LOG.error((Object)String.format("|   Failed in migrate activities of %s user(s)", numberUserFailed));
        }
        this.LOG.info((Object)String.format("| / END:: %s user(s) consumed %s(ms) -------------", counter.getTotal(), counter.endTotalWatch()));
        return numberUserFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long migrateSpaceActivities() throws Exception {
        this.LOG.info((Object)"Start to migration space activities from JCR to RDBMS");
        long t = System.currentTimeMillis();
        long totalSpaces = this.getNumberSpaceIdentities();
        boolean isSkip = this.lastUserProcess != null;
        boolean cont = true;
        long offset = 0L;
        long numberSpaceFailed = 0L;
        while (cont && !this.forkStop) {
            try {
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                NodeIterator it = this.getSpaceIdentityNodes(offset, this.LIMIT_THRESHOLD);
                if (it == null || it.getSize() <= 0L) {
                    cont = false;
                    continue;
                }
                Identity owner = null;
                Node node = null;
                while (it.hasNext() && !this.forceStop) {
                    node = (Node)it.next();
                    ++offset;
                    owner = this.identityStorage.findIdentityById(node.getUUID());
                    if (isSkip) {
                        if (!this.lastUserProcess.equals(owner.getRemoteId())) continue;
                        this.lastUserProcess = null;
                        isSkip = false;
                    }
                    long t1 = System.currentTimeMillis();
                    IdentityEntity spaceEntity = (IdentityEntity)this._findById(IdentityEntity.class, node.getUUID());
                    this.LOG.info((Object)String.format("|  \\ START::space number: %s/%s (%s space)", offset, totalSpaces, owner.getRemoteId()));
                    try {
                        this.migrationByIdentity(null, spaceEntity);
                    }
                    catch (Exception ex) {
                        ++numberSpaceFailed;
                        this.identitiesMigrateFailed.add(node.getName());
                        this.LOG.error((Object)String.format("Failed migrate space %s", owner.getRemoteId()), (Throwable)ex);
                    }
                    this.LOG.info((Object)String.format("|  / END:: migrate activity of space %s consumed %s(ms) -------------", owner.getRemoteId(), System.currentTimeMillis() - t1));
                }
            }
            catch (Exception ex) {
                this.LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
        if (numberSpaceFailed > 0L) {
            this.LOG.info((Object)(" Failed migration for " + numberSpaceFailed + " space(s)"));
        }
        this.LOG.info((Object)String.format("Done to migration %s space activities from JCR to RDBMS on %s(ms)", offset, System.currentTimeMillis() - t));
        return numberSpaceFailed;
    }

    @Override
    @Managed
    @ManagedDescription(value="Manual to stop run miguration data of activities from JCR to RDBMS.")
    public void stop() {
        super.stop();
    }

    @Override
    protected void beforeMigration() throws Exception {
        MigrationContext.setActivityDone(false);
        this.identitiesMigrateFailed = new HashSet<String>();
        this.LOG.info((Object)"Stating to migration activities from JCR to RDBMS........");
        NodeIterator iterator = this.nodes("SELECT * FROM soc:activityUpdater");
        if (iterator.hasNext()) {
            String currentUUID = iterator.nextNode().getUUID();
            this.lastActivity = (ActivityEntity)this._findById(ActivityEntity.class, currentUUID);
            if (this.lastActivity != null) {
                this.lastUserProcess = this.lastActivity.getPosterIdentity().getRemoteId();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrationByIdentity(String userName, IdentityEntity identityEntity) throws Exception {
        boolean begunTx = false;
        long numberActivitiesFailed = 0L;
        long t = System.currentTimeMillis();
        int count = 0;
        String providerId = "";
        String remoteId = "";
        if (identityEntity == null) {
            Identity poster = this.identityStorage.findIdentity("organization", userName);
            try {
                identityEntity = (IdentityEntity)this._findById(IdentityEntity.class, poster.getId());
            }
            catch (Exception e) {
                this.LOG.warn((Object)("The user " + userName + " has not identity. Do not migration for this user."));
                return;
            }
        }
        providerId = identityEntity.getProviderId();
        remoteId = identityEntity.getRemoteId();
        Identity jpaIdentity = this.identityJPAStorage.findIdentity(identityEntity.getProviderId(), identityEntity.getRemoteId());
        String type = "organization".equals(providerId) ? "user" : "space";
        this.LOG.info((Object)String.format("    Migration activities for %s: %s", type, identityEntity.getRemoteId()));
        ActivityListEntity activityListEntity = identityEntity.getActivityList();
        ActivityIterator activityIterator = new ActivityIterator(activityListEntity);
        if (this.lastActivity != null) {
            activityIterator.moveTo(this.lastActivity);
            this.lastActivity = null;
        }
        while (activityIterator.hasNext()) {
            String activityId = activityIterator.next().getId();
            try {
                begunTx = this.startTx();
                ExoSocialActivity activity = this.activityJCRStorage.getActivity(activityId);
                Map params = activity.getTemplateParams();
                if (params != null && !params.isEmpty()) {
                    for (Map.Entry entry : params.entrySet()) {
                        String value = (String)entry.getValue();
                        if (value.length() >= 1024) {
                            this.LOG.info((Object)("===================== activity id " + activity.getId() + " new value length = " + value.length()));
                            params.put(entry.getKey(), "");
                        }
                        params.put(entry.getKey(), StringUtil.removeLongUTF((String)entry.getValue()));
                    }
                    activity.setTemplateParams(params);
                }
                activity.setId(null);
                activity.setTitle(StringUtil.removeLongUTF(activity.getTitle()));
                activity.setBody(StringUtil.removeLongUTF(activity.getBody()));
                activity.setLikeIdentityIds(this.convertToNewIds(activity.getLikeIdentityIds()));
                activity.setCommentedIds(this.convertToNewIds(activity.getCommentedIds()));
                activity.setMentionedIds(this.convertToNewIds(activity.getMentionedIds()));
                activity.setUserId(this.getNewIdentityId(activity.getUserId()));
                activity.setPosterId(this.getNewIdentityId(activity.getPosterId()));
                activity = this.activityStorage.saveActivity(jpaIdentity, activity);
                this.doBroadcastListener(activity, activityId);
                ActivityEntity activityEntity = (ActivityEntity)this.getSession().findById(ActivityEntity.class, activityId);
                this._getMixin(activityEntity, ActivityUpdaterEntity.class, true);
                if (this.previousActivityId != null) {
                    try {
                        ActivityEntity previousActivity = (ActivityEntity)this.getSession().findById(ActivityEntity.class, this.previousActivityId);
                        if (previousActivity != null) {
                            this._removeMixin(previousActivity, ActivityUpdaterEntity.class);
                        }
                    }
                    catch (Exception e) {
                        this.LOG.error((Object)("Failed to remove mixin type," + e.getMessage()), (Throwable)e);
                    }
                }
                this.endTx(begunTx);
                begunTx = this.startTx();
                List commentEntities = activityEntity.getComments();
                if (commentEntities != null) {
                    for (ActivityEntity commentEntity : commentEntities) {
                        ExoSocialActivity comment = this.fillCommentFromEntity(commentEntity);
                        if (comment == null) continue;
                        String oldCommentId = comment.getId();
                        comment.setId(null);
                        Map commentParams = comment.getTemplateParams();
                        if (commentParams != null && !commentParams.isEmpty()) {
                            for (Map.Entry entry : commentParams.entrySet()) {
                                String value = (String)entry.getValue();
                                if (value.length() >= 1024) {
                                    this.LOG.info((Object)("===================== comment id " + oldCommentId + " new value length = " + value.length()));
                                    commentParams.put(entry.getKey(), "");
                                }
                                commentParams.put(entry.getKey(), StringUtil.removeLongUTF((String)entry.getValue()));
                            }
                            comment.setTemplateParams(commentParams);
                        }
                        activity.setTemplateParams(params);
                        comment.setLikeIdentityIds(this.convertToNewIds(comment.getLikeIdentityIds()));
                        comment.setCommentedIds(this.convertToNewIds(comment.getCommentedIds()));
                        comment.setMentionedIds(this.convertToNewIds(comment.getMentionedIds()));
                        comment.setUserId(this.getNewIdentityId(comment.getUserId()));
                        comment.setPosterId(this.getNewIdentityId(comment.getPosterId()));
                        if (comment.getTitle() == null) {
                            comment.setTitle("");
                        }
                        this.activityStorage.saveComment(activity, comment);
                        this.doBroadcastListener(comment, oldCommentId);
                        commentParams = null;
                        params = null;
                    }
                }
                this.previousActivityId = activityId;
                ++count;
            }
            catch (Exception e) {
                this.LOG.error((Object)("Failed to migrate activity id : " + activityId), (Throwable)e);
                ++numberActivitiesFailed;
            }
            finally {
                try {
                    this.endTx(begunTx);
                }
                catch (Exception ex) {
                    this.LOG.error((Object)("Failed to migrate activity id : " + activityId));
                    ++numberActivitiesFailed;
                }
            }
        }
        this.LOG.info((Object)String.format("    Done migration %s activitie(s) for %s consumed %s(ms) ", count, providerId + "/" + remoteId, System.currentTimeMillis() - t));
        if (numberActivitiesFailed > 0L) {
            this.LOG.error((Object)String.format("    Failed migration for %s activitie(s)", numberActivitiesFailed));
            throw new Exception("Migration is failed for " + numberActivitiesFailed + " activities of identity " + providerId + "/" + remoteId);
        }
    }

    private void doBroadcastListener(ExoSocialActivity activity, String oldId) {
        String newId = activity.getId();
        activity.setId(oldId);
        this.broadcastListener(activity, newId.replace(COMMENT_PREFIX, ""));
        activity.setId(newId);
    }

    @Override
    protected void afterMigration() throws Exception {
        MigrationContext.setIdentitiesMigrateActivityFailed(this.identitiesMigrateFailed);
        if (!this.forceStop && this.identitiesMigrateFailed.isEmpty()) {
            MigrationContext.setActivityDone(true);
        }
        this.LOG.info((Object)"Done to migration activities from JCR to RDBMS");
        if (this.previousActivityId != null) {
            try {
                ActivityEntity previousActivity = (ActivityEntity)this.getSession().findById(ActivityEntity.class, this.previousActivityId);
                if (previousActivity != null) {
                    this._removeMixin(previousActivity, ActivityUpdaterEntity.class);
                }
            }
            catch (Exception e) {
                this.LOG.error((Object)("Failed to remove mixin type," + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public void doRemove() throws Exception {
        this.LOG.info((Object)"Start remove activities from JCR to RDBMS");
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            this.removeActivity();
        }
        finally {
            RequestLifeCycle.end();
        }
        this.LOG.info((Object)"Done to removed activities from JCR");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeActivity() throws Exception {
        String name;
        NodeIterator it;
        this.identitiesCleanupFailed = new HashSet<String>();
        long t = System.currentTimeMillis();
        long offset = 0L;
        long totalUsers = this.getNumberUserIdentities();
        long totalSpaces = this.getNumberSpaceIdentities();
        Node node = null;
        boolean isDone = false;
        try {
            this.LOG.info((Object)"| \\ START::cleanup User Activity ---------------------------------");
            it = this.getIdentityNodes(offset, 10L);
            while (it != null && it.hasNext()) {
                node = (Node)it.next();
                name = node.getName();
                if (!MigrationContext.isForceCleanup() && MigrationContext.getIdentitiesMigrateActivityFailed().contains(name)) {
                    this.identitiesCleanupFailed.add(name);
                    continue;
                }
                this.LOG.info((Object)String.format("|  \\ START::cleanup user number: %s/%s (%s user)", ++offset, totalUsers, node.getName()));
                isDone = this.cleanupActivity(node);
                if (!isDone) {
                    this.identitiesCleanupFailed.add(name);
                }
                this.LOG.info((Object)String.format("|  / END::cleanup (%s user)", node.getName()));
                if (offset % 10L != 0L && isDone) continue;
                RequestLifeCycle.end();
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                it = this.getIdentityNodes(offset, 10L);
            }
        }
        catch (Exception e) {
            try {
                this.LOG.error((Object)"Failed to cleanup for Activity Reference.", (Throwable)e);
            }
            catch (Throwable throwable) {
                RequestLifeCycle.end();
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                this.LOG.info((Object)String.format("| / END::cleanup Activity for (%s) user consumed %s(ms) -------------", offset, System.currentTimeMillis() - t));
                throw throwable;
            }
            RequestLifeCycle.end();
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            this.LOG.info((Object)String.format("| / END::cleanup Activity for (%s) user consumed %s(ms) -------------", offset, System.currentTimeMillis() - t));
        }
        RequestLifeCycle.end();
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        this.LOG.info((Object)String.format("| / END::cleanup Activity for (%s) user consumed %s(ms) -------------", offset, System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        node = null;
        offset = 0L;
        try {
            this.LOG.info((Object)"| \\ START::cleanup Space Activity ---------------------------------");
            it = this.getSpaceIdentityNodes(offset, 10L);
            while (it != null && it.hasNext()) {
                node = (Node)it.next();
                name = node.getName();
                if (!MigrationContext.isForceCleanup() && MigrationContext.getIdentitiesMigrateActivityFailed().contains(name)) {
                    this.identitiesCleanupFailed.add(name);
                    continue;
                }
                this.LOG.info((Object)String.format("|  \\ START::cleanup space number: %s/%s (%s space)", offset, totalSpaces, node.getName()));
                isDone = this.cleanupActivity(node);
                if (!isDone) {
                    this.identitiesCleanupFailed.add(name);
                }
                this.LOG.info((Object)String.format("|  / END::cleanup (%s space)", node.getName()));
                if (++offset % 10L != 0L && isDone) continue;
                RequestLifeCycle.end();
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                it = this.getSpaceIdentityNodes(offset, 10L);
            }
        }
        catch (Exception e) {
            try {
                this.LOG.error((Object)"Failed to cleanup for user Activities.", (Throwable)e);
            }
            catch (Throwable throwable) {
                MigrationContext.setIdentitiesCleanupActivityFailed(this.identitiesCleanupFailed);
                RequestLifeCycle.end();
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                this.LOG.info((Object)String.format("| / END::cleanup Activity for (%s) space consumed %s(ms) -------------", offset, System.currentTimeMillis() - t));
                throw throwable;
            }
            MigrationContext.setIdentitiesCleanupActivityFailed(this.identitiesCleanupFailed);
            RequestLifeCycle.end();
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            this.LOG.info((Object)String.format("| / END::cleanup Activity for (%s) space consumed %s(ms) -------------", offset, System.currentTimeMillis() - t));
        }
        MigrationContext.setIdentitiesCleanupActivityFailed(this.identitiesCleanupFailed);
        RequestLifeCycle.end();
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        this.LOG.info((Object)String.format("| / END::cleanup Activity for (%s) space consumed %s(ms) -------------", offset, System.currentTimeMillis() - t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanupSubNode(Node activityNode, String userName) {
        long totalTime = System.currentTimeMillis();
        NodeImpl node = null;
        long offset = 0L;
        String nodeId = "";
        String nodePath = "";
        try {
            nodeId = activityNode.getUUID();
            nodePath = activityNode.getPath();
            PropertyIterator pIt = activityNode.getReferences();
            while (pIt.hasNext()) {
                node = (NodeImpl)pIt.nextProperty().getParent();
                if (node.getData() != null) {
                    node.remove();
                    ++offset;
                }
                if (offset % 50L != 0L) continue;
                this.getSession().save();
            }
            this.getSession().save();
        }
        catch (Exception e) {
            boolean bl;
            try {
                this.LOG.error((Object)("Failed to cleanup sub node for Activity Reference, activity id =" + nodeId + " path=" + nodePath), (Throwable)e);
                try {
                    this.getSession().getJCRSession().refresh(false);
                }
                catch (RepositoryException ex) {
                    this.LOG.error((Object)"RepositoryException", (Throwable)ex);
                }
                bl = false;
            }
            catch (Throwable throwable) {
                this.LOG.info((Object)String.format("|     - Done cleanup: %s ref(s) of (%s) consumed time %s(ms) ", offset, userName, System.currentTimeMillis() - totalTime));
                throw throwable;
            }
            this.LOG.info((Object)String.format("|     - Done cleanup: %s ref(s) of (%s) consumed time %s(ms) ", offset, userName, System.currentTimeMillis() - totalTime));
            return bl;
        }
        this.LOG.info((Object)String.format("|     - Done cleanup: %s ref(s) of (%s) consumed time %s(ms) ", offset, userName, System.currentTimeMillis() - totalTime));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanupActivity(Node identityNode) {
        long failed;
        block17: {
            String identityName = "";
            long totalTime = System.currentTimeMillis();
            failed = 0L;
            try {
                identityName = identityNode.getName();
                Node activitiesNode = identityNode.getNode("soc:activities");
                long size = activitiesNode.getProperty("soc:number").getLong();
                StringBuffer sb = new StringBuffer().append("SELECT * FROM soc:activity WHERE ");
                try {
                    String nodeStreamsPath = XPathUtils.escapeIllegalSQLName((String)identityNode.getNode("soc:activities").getPath());
                    sb.append(JCRProperties.path.getName()).append(" LIKE '").append(nodeStreamsPath + "/" + "%" + "'");
                    sb.append(" AND soc:isComment = 'false'");
                }
                catch (RepositoryException e) {
                    this.LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                if (size > 0L) {
                    block16: {
                        long t = System.currentTimeMillis();
                        long offset = 0L;
                        this.LOG.info((Object)String.format("|   \\ START::cleanup: %d (Activity) for %s identity", size, identityName));
                        try {
                            NodeIterator it = this.nodes(sb.toString(), failed, 10L);
                            while (it != null && it.hasNext()) {
                                ++offset;
                                Node n = it.nextNode();
                                try {
                                    if (this.cleanupSubNode(n, identityName)) {
                                        n.remove();
                                    } else {
                                        ++failed;
                                    }
                                }
                                catch (Exception ex) {
                                    this.LOG.error((Object)("Failed to cleanup activity ID: " + n.getUUID() + " path: " + n.getPath()), (Throwable)ex);
                                    ++failed;
                                }
                                if (offset % 10L != 0L) continue;
                                try {
                                    this.getSession().save();
                                    this.LOG.info((Object)String.format("|     - Persist deleted: %s activity consumed time %s(ms) ", 10, System.currentTimeMillis() - t));
                                }
                                catch (Exception ex) {
                                    this.LOG.error((Object)"Failed, can not persist deleted activities", (Throwable)ex);
                                    this.getSession().getJCRSession().refresh(false);
                                    failed += 10L;
                                }
                                t = System.currentTimeMillis();
                                it = this.nodes(sb.toString(), failed, 10L);
                            }
                            this.getSession().save();
                            if (offset % 10L == 0L) break block16;
                            this.LOG.info((Object)String.format("|     - Persist deleted: %s activity consumed time %s(ms) ", offset % 10L, System.currentTimeMillis() - t));
                        }
                        catch (Throwable throwable) {
                            this.LOG.info((Object)String.format("|   / END::cleanup: %d (Activity) for %s identity consumed time %s(ms) ", size, identityName, System.currentTimeMillis() - totalTime));
                            throw throwable;
                        }
                    }
                    this.LOG.info((Object)String.format("|   / END::cleanup: %d (Activity) for %s identity consumed time %s(ms) ", size, identityName, System.currentTimeMillis() - totalTime));
                    break block17;
                }
                this.LOG.info((Object)("There is not any activity for identity: " + identityName));
            }
            catch (Exception e) {
                this.LOG.error((Object)("Failed to cleanup activities for identity: " + identityName), (Throwable)e);
                try {
                    this.getSession().getJCRSession().refresh(false);
                }
                catch (RepositoryException ex) {
                    this.LOG.error((Object)"Repository exception", (Throwable)e);
                }
                return false;
            }
        }
        return failed == 0L;
    }

    private ExoSocialActivity fillCommentFromEntity(ActivityEntity activityEntity) {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        try {
            ActivityParameters params;
            comment.setId(activityEntity.getId());
            comment.setTitle(StringUtil.removeLongUTF(activityEntity.getTitle()));
            comment.setTitleId(activityEntity.getTitleId());
            comment.setBody(StringUtil.removeLongUTF(activityEntity.getBody()));
            comment.setBodyId(activityEntity.getBodyId());
            comment.setPostedTime(activityEntity.getPostedTime());
            comment.setUpdated(Long.valueOf(this.getLastUpdatedTime(activityEntity, comment.getPostedTime())));
            comment.isComment(activityEntity.isComment().booleanValue());
            comment.setType(activityEntity.getType());
            IdentityEntity poster = activityEntity.getPosterIdentity();
            if (poster == null) {
                this.LOG.warn((Object)"Failed to fill comment from entity: poster is null");
                return null;
            }
            String posterId = poster.getId();
            comment.setUserId(posterId);
            comment.setPosterId(posterId);
            ActivityEntity parent = activityEntity.getParentActivity();
            if (parent == null) {
                this.LOG.warn((Object)"Failed to fill comment from entity: parent activity is null");
            }
            comment.setParentId(parent.getId());
            String[] mentioners = activityEntity.getMentioners();
            if (mentioners != null) {
                comment.setMentionedIds(mentioners);
            }
            if ((params = activityEntity.getParams()) != null) {
                comment.setTemplateParams(new LinkedHashMap(params.getParams()));
            } else {
                comment.setTemplateParams(new LinkedHashMap());
            }
            comment.isLocked(false);
            HidableEntity hidable = (HidableEntity)this._getMixin(activityEntity, HidableEntity.class, false);
            if (hidable != null) {
                comment.isHidden(hidable.getHidden().booleanValue());
            }
        }
        catch (Exception e) {
            this.LOG.warn((Object)"Failed to fill comment from entity : entity null or missing property", (Throwable)e);
            return null;
        }
        return comment;
    }

    private long getLastUpdatedTime(ActivityEntity activityEntity, Long postTime) {
        try {
            return activityEntity.getLastUpdated();
        }
        catch (Exception e) {
            return postTime != null ? postTime : System.currentTimeMillis();
        }
    }

    @Override
    protected String getListenerKey() {
        return EVENT_LISTENER_KEY;
    }

    private String getNewIdentityId(String oldId) {
        if (oldId == null || oldId.isEmpty()) {
            return null;
        }
        try {
            Identity id;
            IdentityEntity entity = (IdentityEntity)this._findById(IdentityEntity.class, oldId);
            if (entity != null && (id = this.identityJPAStorage.findIdentity(entity.getProviderId(), entity.getRemoteId())) != null) {
                return id.getId();
            }
            return null;
        }
        catch (NodeNotFoundException ex) {
            return null;
        }
    }

    private String[] convertToNewIds(String[] oldIds) {
        if (oldIds == null || oldIds.length == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>(oldIds.length);
        for (String old : oldIds) {
            String id;
            int index = old.indexOf(64);
            if (index != -1) {
                old = old.substring(0, index);
            }
            if ((id = this.getNewIdentityId(old)) == null) continue;
            list.add(id);
        }
        return list.toArray(new String[list.size()]);
    }
}

