/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.storage;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.addons.search.ExtendProfileFilter;
import org.exoplatform.social.addons.search.ProfileSearchConnector;
import org.exoplatform.social.addons.storage.EntityConverterUtils;
import org.exoplatform.social.addons.storage.RDBMSIdentityStorageImpl$AjcClosure1;
import org.exoplatform.social.addons.storage.RDBMSIdentityStorageImpl$AjcClosure3;
import org.exoplatform.social.addons.storage.RDBMSIdentityStorageImpl$AjcClosure5;
import org.exoplatform.social.addons.storage.RDBMSIdentityStorageImpl$AjcClosure7;
import org.exoplatform.social.addons.storage.RDBMSIdentityStorageImpl$AjcClosure9;
import org.exoplatform.social.addons.storage.dao.ActivityDAO;
import org.exoplatform.social.addons.storage.dao.IdentityDAO;
import org.exoplatform.social.addons.storage.dao.SpaceDAO;
import org.exoplatform.social.addons.storage.entity.ActivityEntity;
import org.exoplatform.social.addons.storage.entity.ConnectionEntity;
import org.exoplatform.social.addons.storage.entity.IdentityEntity;
import org.exoplatform.social.addons.storage.entity.ProfileExperienceEntity;
import org.exoplatform.social.addons.storage.entity.SpaceEntity;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.ActiveIdentityFilter;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.IdentityWithRelationship;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.core.storage.impl.IdentityStorageImpl;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class RDBMSIdentityStorageImpl
extends IdentityStorageImpl {
    private static final Log LOG;
    private static final String socialNameSpace = "social";
    private final ActivityDAO activityDAO;
    private final IdentityDAO identityDAO;
    private final SpaceDAO spaceDAO;
    private final FileService fileService;
    private final OrganizationService orgService;
    private ProfileSearchConnector profileSearchConnector;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public RDBMSIdentityStorageImpl(IdentityDAO identityDAO, SpaceDAO spaceDAO, ActivityDAO activityDAO, FileService fileService, ProfileSearchConnector profileSearchConnector, OrganizationService orgService) {
        this.identityDAO = identityDAO;
        this.spaceDAO = spaceDAO;
        this.activityDAO = activityDAO;
        this.profileSearchConnector = profileSearchConnector;
        this.orgService = orgService;
        this.fileService = fileService;
    }

    private IdentityDAO getIdentityDAO() {
        return this.identityDAO;
    }

    public void setProfileSearchConnector(ProfileSearchConnector profileSearchConnector) {
        this.profileSearchConnector = profileSearchConnector;
    }

    private void mapToProfileEntity(Profile profile, IdentityEntity entity) {
        String providerId;
        Map<String, String> entityProperties = entity.getProperties();
        if (entityProperties == null) {
            entityProperties = new HashMap<String, String>();
        }
        if (!"organization".equals(providerId = profile.getIdentity().getProviderId()) && !"space".equals(providerId)) {
            entityProperties.put("Url", profile.getUrl());
            entityProperties.put("avatarUrl", profile.getAvatarUrl());
        }
        Map properties = profile.getProperties();
        for (Map.Entry e : properties.entrySet()) {
            Object val;
            if ("avatar".equalsIgnoreCase((String)e.getKey())) {
                AvatarAttachment attachment = (AvatarAttachment)e.getValue();
                byte[] bytes = attachment.getImageBytes();
                String fileName = attachment.getFileName();
                if (fileName == null) {
                    fileName = entity.getRemoteId() + "_avatar";
                }
                try {
                    FileItem fileItem;
                    Long avatarId = entity.getAvatarFileId();
                    if (avatarId != null) {
                        fileItem = new FileItem(avatarId, fileName, attachment.getMimeType(), socialNameSpace, (long)bytes.length, new Date(), entity.getRemoteId(), false, (InputStream)new ByteArrayInputStream(bytes));
                        this.fileService.updateFile(fileItem);
                        continue;
                    }
                    fileItem = new FileItem(null, fileName, attachment.getMimeType(), socialNameSpace, (long)bytes.length, new Date(), entity.getRemoteId(), false, (InputStream)new ByteArrayInputStream(bytes));
                    fileItem = this.fileService.writeFile(fileItem);
                    entity.setAvatarFileId(fileItem.getFileInfo().getId());
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Can not store avatar for " + entity.getProviderId() + " " + entity.getRemoteId()), (Throwable)ex);
                }
                continue;
            }
            if ("experiences".equalsIgnoreCase((String)e.getKey())) {
                List exps = (List)e.getValue();
                HashSet<ProfileExperienceEntity> experiences = new HashSet<ProfileExperienceEntity>();
                for (Map exp : exps) {
                    ProfileExperienceEntity ex = new ProfileExperienceEntity();
                    ex.setCompany((String)exp.get("company"));
                    ex.setPosition((String)exp.get("position"));
                    ex.setStartDate((String)exp.get("startDate"));
                    ex.setEndDate((String)exp.get("endDate"));
                    ex.setSkills((String)exp.get("skills"));
                    ex.setDescription((String)exp.get("description"));
                    experiences.add(ex);
                }
                entity.setExperiences(experiences);
                continue;
            }
            if ("ims".equals(e.getKey()) || "phones".equals(e.getKey()) || "urls".equals(e.getKey())) {
                List list = (List)e.getValue();
                JSONArray arr = new JSONArray();
                for (Map map : list) {
                    JSONObject json = new JSONObject(map);
                    arr.put((Object)json);
                }
                entityProperties.put((String)e.getKey(), arr.toString());
                continue;
            }
            if ("skills".equals(e.getKey()) || (val = e.getValue()) == null) continue;
            entityProperties.put((String)e.getKey(), String.valueOf(val));
        }
        entity.setProperties(entityProperties);
        Date created = profile.getCreatedTime() <= 0L ? new Date() : new Date(profile.getCreatedTime());
        entity.setCreatedDate(created);
    }

    public void saveIdentity(Identity identity) throws IdentityStorageException {
        long id = EntityConverterUtils.parseId(identity.getId());
        IdentityEntity entity = null;
        entity = id > 0L ? (IdentityEntity)this.getIdentityDAO().find(Long.valueOf(id)) : this.getIdentityDAO().findByProviderAndRemoteId(identity.getProviderId(), identity.getRemoteId());
        if (entity == null) {
            entity = new IdentityEntity();
        }
        EntityConverterUtils.mapToEntity(identity, entity);
        if (entity.getId() > 0L) {
            this.getIdentityDAO().update(entity);
        } else {
            if (identity.getProfile() != null) {
                this.mapToProfileEntity(identity.getProfile(), entity);
            }
            entity = (IdentityEntity)this.getIdentityDAO().create(entity);
        }
        Profile profile = EntityConverterUtils.convertToProfile(entity, identity);
        if (id <= 0L) {
            profile.setId(null);
        }
        identity.setProfile(profile);
        identity.setId(entity.getStringId());
    }

    public Identity updateIdentity(Identity identity) throws IdentityStorageException {
        long id = EntityConverterUtils.parseId(identity.getId());
        IdentityEntity entity = null;
        if (id > 0L) {
            entity = (IdentityEntity)this.getIdentityDAO().find(Long.valueOf(id));
        }
        if (entity == null) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_UPDATE_IDENTITY, "The identity does not exist on DB");
        }
        EntityConverterUtils.mapToEntity(identity, entity);
        entity = (IdentityEntity)this.getIdentityDAO().update(entity);
        return EntityConverterUtils.convertToIdentity(entity, true);
    }

    public void updateIdentityMembership(String remoteId) throws IdentityStorageException {
    }

    @ExoTransactional
    public Identity findIdentityById(String nodeId) throws IdentityStorageException {
        String string = nodeId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Identity)ExoTransactionalAspect.aspectOf().around(new RDBMSIdentityStorageImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void deleteIdentity(Identity identity) throws IdentityStorageException {
        this.hardDeleteIdentity(identity);
    }

    @ExoTransactional
    public void hardDeleteIdentity(Identity identity) throws IdentityStorageException {
        Identity identity2 = identity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)identity2);
        Object[] objectArray = new Object[]{this, identity2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new RDBMSIdentityStorageImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public Profile loadProfile(Profile profile) throws IdentityStorageException {
        Profile profile2 = profile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)profile2);
        Object[] objectArray = new Object[]{this, profile2, joinPoint};
        return (Profile)ExoTransactionalAspect.aspectOf().around(new RDBMSIdentityStorageImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public Identity findIdentity(String providerId, String remoteId) throws IdentityStorageException {
        String string = providerId;
        String string2 = remoteId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        return (Identity)ExoTransactionalAspect.aspectOf().around(new RDBMSIdentityStorageImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void saveProfile(Profile profile) throws IdentityStorageException {
        IdentityEntity entity;
        long id = EntityConverterUtils.parseId(profile.getIdentity().getId());
        IdentityEntity identityEntity = entity = id == 0L ? null : (IdentityEntity)this.identityDAO.find(Long.valueOf(id));
        if (entity == null) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_UPDATE_PROFILE, "Profile does not exist on RDBMS");
        }
        this.mapToProfileEntity(profile, entity);
        this.identityDAO.update(entity);
        profile.setId(entity.getStringId());
        profile.clearHasChanged();
    }

    public void updateProfile(Profile profile) throws IdentityStorageException {
        long id = EntityConverterUtils.parseId(profile.getIdentity().getId());
        IdentityEntity entity = (IdentityEntity)this.identityDAO.find(Long.valueOf(id));
        if (entity == null) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_UPDATE_PROFILE, "Profile does not exist on RDBMS");
        }
        this.mapToProfileEntity(profile, entity);
        this.identityDAO.update(entity);
    }

    public int getIdentitiesCount(String providerId) throws IdentityStorageException {
        return (int)this.getIdentityDAO().countIdentityByProvider(providerId);
    }

    public String getType(String nodetype, String property) {
        return "undefined";
    }

    public void addOrModifyProfileProperties(Profile profile) throws IdentityStorageException {
        this.updateProfile(profile);
    }

    public void updateProfileActivityId(Identity identity, String activityId, Profile.AttachedActivityType type) {
    }

    public String getProfileActivityId(Profile profile, Profile.AttachedActivityType type) {
        String t = "SPACE_ACTIVITY";
        if (type == Profile.AttachedActivityType.USER) {
            t = "USER_PROFILE_ACTIVITY";
        } else if (type == Profile.AttachedActivityType.RELATIONSHIP) {
            t = "USER_ACTIVITIES_FOR_RELATIONSHIP";
        }
        List<ActivityEntity> activities = this.activityDAO.getActivitiesByPoster(profile.getIdentity(), 0, 1, t);
        if (activities != null && activities.size() > 0) {
            return String.valueOf(activities.get(0).getId());
        }
        return null;
    }

    public Set<String> getActiveUsers(ActiveIdentityFilter filter) {
        HashSet<String> activeUsers = new HashSet();
        if (filter.getUserGroups() != null) {
            StringTokenizer stringToken = new StringTokenizer(filter.getUserGroups(), ",");
            try {
                while (stringToken.hasMoreTokens()) {
                    try {
                        User[] users;
                        ListAccess listAccess = this.orgService.getUserHandler().findUsersByGroupId(stringToken.nextToken().trim());
                        for (User u : users = (User[])listAccess.load(0, listAccess.getSize())) {
                            activeUsers.add(u.getUserName());
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
            }
        }
        if (filter.getDays() > 0) {
            activeUsers = StorageUtils.getLastLogin((int)filter.getDays());
        }
        if (CommonsUtils.getService(UserStateService.class) != null) {
            List onlines = ((UserStateService)CommonsUtils.getService(UserStateService.class)).online();
            for (UserStateModel user : onlines) {
                activeUsers.add(user.getUserId());
            }
        }
        return activeUsers;
    }

    public void processEnabledIdentity(Identity identity, boolean isEnable) {
        long id = EntityConverterUtils.parseId(identity.getId());
        IdentityEntity entity = (IdentityEntity)this.getIdentityDAO().find(Long.valueOf(id));
        if (entity == null) {
            throw new IllegalArgumentException("Identity does not exists");
        }
        entity.setEnabled(isEnable);
        this.getIdentityDAO().update(entity);
    }

    public List<Identity> getIdentitiesByFirstCharacterOfName(String providerId, ProfileFilter profileFilter, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        return this.getIdentitiesByProfileFilter(providerId, profileFilter, offset, limit, forceLoadOrReloadProfile);
    }

    public List<Identity> getIdentitiesForMentions(String providerId, ProfileFilter profileFilter, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        return this.getIdentitiesByProfileFilter(providerId, profileFilter, offset, limit, forceLoadOrReloadProfile);
    }

    public int getIdentitiesByProfileFilterCount(String providerId, ProfileFilter profileFilter) throws IdentityStorageException {
        ExtendProfileFilter xFilter = new ExtendProfileFilter(profileFilter);
        ListAccess<IdentityEntity> list = this.getIdentityDAO().findIdentities(xFilter);
        try {
            return list.getSize();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIdentitiesByFirstCharacterOfNameCount(String providerId, ProfileFilter profileFilter) throws IdentityStorageException {
        ExtendProfileFilter xFilter = new ExtendProfileFilter(profileFilter);
        xFilter.setProviderId(providerId);
        ListAccess<IdentityEntity> list = this.getIdentityDAO().findIdentities(xFilter);
        try {
            return list.getSize();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public List<Identity> getIdentitiesForUnifiedSearch(String providerId, ProfileFilter profileFilter, long offset, long limit) throws IdentityStorageException {
        return this.profileSearchConnector.search(null, profileFilter, null, offset, limit);
    }

    public List<Identity> getSpaceMemberIdentitiesByProfileFilter(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type, long offset, long limit) throws IdentityStorageException {
        ArrayList<Long> relations = new ArrayList<Long>();
        if (space != null) {
            try {
                SpaceEntity gotSpace = (SpaceEntity)this.spaceDAO.find(Long.valueOf(Long.parseLong(space.getId())));
                String[] members = null;
                switch (type) {
                    case MEMBER: {
                        members = gotSpace.getMembersId();
                        break;
                    }
                    case MANAGER: {
                        members = gotSpace.getManagerMembersId();
                        List wildcardUsers = SpaceUtils.findMembershipUsersByGroupAndTypes((String)space.getGroupId(), (String[])new String[]{"*"});
                        for (String remoteId : wildcardUsers) {
                            Identity id = this.findIdentity("organization", remoteId);
                            if (id == null) continue;
                            relations.add(EntityConverterUtils.parseId(id.getId()));
                        }
                        break;
                    }
                }
                for (int i = 0; i < members.length; ++i) {
                    Identity identity = this.findIdentity("organization", members[i]);
                    if (identity == null) continue;
                    relations.add(EntityConverterUtils.parseId(identity.getId()));
                }
            }
            catch (IdentityStorageException e) {
                throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_FIND_IDENTITY);
            }
            if (relations.isEmpty()) {
                relations.add(-1L);
            }
        }
        ExtendProfileFilter xFilter = new ExtendProfileFilter(profileFilter);
        xFilter.setIdentityIds(relations);
        ListAccess<IdentityEntity> list = this.getIdentityDAO().findIdentities(xFilter);
        return EntityConverterUtils.convertToIdentities(list, offset, limit);
    }

    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        ExtendProfileFilter xFilter = new ExtendProfileFilter(profileFilter);
        xFilter.setProviderId(providerId);
        xFilter.setForceLoadProfile(forceLoadOrReloadProfile);
        ListAccess<IdentityEntity> list = this.getIdentityDAO().findIdentities(xFilter);
        return EntityConverterUtils.convertToIdentities(list, offset, limit);
    }

    public List<IdentityWithRelationship> getIdentitiesWithRelationships(String identityId, int offset, int limit) throws IdentityStorageException {
        ListAccess<Map.Entry<IdentityEntity, ConnectionEntity>> list = this.getIdentityDAO().findAllIdentitiesWithConnections(Long.valueOf(identityId));
        return EntityConverterUtils.convertToIdentitiesWithRelationship(list, offset, limit);
    }

    public int countIdentitiesWithRelationships(String identityId) throws Exception {
        ListAccess<Map.Entry<IdentityEntity, ConnectionEntity>> list = this.getIdentityDAO().findAllIdentitiesWithConnections(Long.valueOf(identityId));
        return list.getSize();
    }

    public ListAccess<Identity> findByFilter(ExtendProfileFilter filter) {
        final ListAccess<IdentityEntity> list = this.getIdentityDAO().findIdentities(filter);
        return new ListAccess<Identity>(){

            public Identity[] load(int offset, int size) throws Exception, IllegalArgumentException {
                IdentityEntity[] entities = (IdentityEntity[])list.load(offset, size);
                if (entities == null || entities.length == 0) {
                    return new Identity[0];
                }
                Identity[] identities = new Identity[entities.length];
                for (int i = 0; i < entities.length; ++i) {
                    identities[i] = EntityConverterUtils.convertToIdentity(entities[i]);
                }
                return identities;
            }

            public int getSize() throws Exception {
                return list.getSize();
            }
        };
    }

    @ExoTransactional
    public void removeIdentity(Identity identity) {
        Identity identity2 = identity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)identity2);
        Object[] objectArray = new Object[]{this, identity2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new RDBMSIdentityStorageImpl$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    static {
        RDBMSIdentityStorageImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(RDBMSIdentityStorageImpl.class);
    }

    static /* synthetic */ Identity findIdentityById_aroundBody0(RDBMSIdentityStorageImpl ajc$this, String nodeId, JoinPoint joinPoint) {
        long id = EntityConverterUtils.parseId(nodeId);
        IdentityEntity entity = (IdentityEntity)ajc$this.getIdentityDAO().find(Long.valueOf(id));
        if (entity != null) {
            return EntityConverterUtils.convertToIdentity(entity);
        }
        return null;
    }

    static /* synthetic */ void hardDeleteIdentity_aroundBody2(RDBMSIdentityStorageImpl ajc$this, Identity identity, JoinPoint joinPoint) {
        long id = EntityConverterUtils.parseId(identity.getId());
        String username = identity.getRemoteId();
        String provider = identity.getProviderId();
        IdentityEntity entity = (IdentityEntity)ajc$this.getIdentityDAO().find(Long.valueOf(id));
        if (entity != null) {
            entity.setDeleted(true);
            ajc$this.getIdentityDAO().update(entity);
        }
        if (entity.getAvatarFileId() != null && entity.getAvatarFileId() > 0L) {
            ajc$this.fileService.deleteFile(entity.getAvatarFileId().longValue());
        }
        EntityManager em = ((EntityManagerService)CommonsUtils.getService(EntityManagerService.class)).getEntityManager();
        Query query = em.createNamedQuery("SocConnection.deleteConnectionByIdentity");
        query.setParameter("identityId", (Object)id);
        query.executeUpdate();
        if ("organization".equals(provider)) {
            query = em.createNamedQuery("SpaceMember.deleteByUsername");
            query.setParameter("username", (Object)username);
            query.executeUpdate();
        }
    }

    static /* synthetic */ Profile loadProfile_aroundBody4(RDBMSIdentityStorageImpl ajc$this, Profile profile, JoinPoint joinPoint) {
        long identityId = EntityConverterUtils.parseId(profile.getIdentity().getId());
        IdentityEntity entity = (IdentityEntity)ajc$this.identityDAO.find(Long.valueOf(identityId));
        if (entity == null) {
            return null;
        }
        profile.setId(String.valueOf(entity.getId()));
        EntityConverterUtils.mapToProfile(entity, profile);
        profile.clearHasChanged();
        return profile;
    }

    static /* synthetic */ Identity findIdentity_aroundBody6(RDBMSIdentityStorageImpl ajc$this, String providerId, String remoteId, JoinPoint joinPoint) {
        try {
            IdentityEntity entity = ajc$this.getIdentityDAO().findByProviderAndRemoteId(providerId, remoteId);
            if (entity == null) {
                return null;
            }
            return EntityConverterUtils.convertToIdentity(entity);
        }
        catch (Exception ex) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_FIND_IDENTITY, "Can not load identity", (Throwable)ex);
        }
    }

    static /* synthetic */ void removeIdentity_aroundBody8(RDBMSIdentityStorageImpl ajc$this, Identity identity, JoinPoint joinPoint) {
        long id = EntityConverterUtils.parseId(identity.getId());
        String username = identity.getRemoteId();
        String provider = identity.getProviderId();
        IdentityEntity entity = (IdentityEntity)ajc$this.getIdentityDAO().find(Long.valueOf(id));
        EntityManager em = ((EntityManagerService)CommonsUtils.getService(EntityManagerService.class)).getEntityManager();
        Query query = em.createNamedQuery("SocConnection.deleteConnectionByIdentity");
        query.setParameter("identityId", (Object)id);
        query.executeUpdate();
        if ("organization".equals(provider)) {
            query = em.createNamedQuery("SpaceMember.deleteByUsername");
            query.setParameter("username", (Object)username);
            query.executeUpdate();
        }
        if (entity != null) {
            ajc$this.getIdentityDAO().delete(entity);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RDBMSIdentityStorageImpl.java", RDBMSIdentityStorageImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findIdentityById", "org.exoplatform.social.addons.storage.RDBMSIdentityStorageImpl", "java.lang.String", "nodeId", "org.exoplatform.social.core.storage.IdentityStorageException", "org.exoplatform.social.core.identity.model.Identity"), 308);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hardDeleteIdentity", "org.exoplatform.social.addons.storage.RDBMSIdentityStorageImpl", "org.exoplatform.social.core.identity.model.Identity", "identity", "org.exoplatform.social.core.storage.IdentityStorageException", "void"), 336);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "loadProfile", "org.exoplatform.social.addons.storage.RDBMSIdentityStorageImpl", "org.exoplatform.social.core.identity.model.Profile", "profile", "org.exoplatform.social.core.storage.IdentityStorageException", "org.exoplatform.social.core.identity.model.Profile"), 374);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findIdentity", "org.exoplatform.social.addons.storage.RDBMSIdentityStorageImpl", "java.lang.String:java.lang.String", "providerId:remoteId", "org.exoplatform.social.core.storage.IdentityStorageException", "org.exoplatform.social.core.identity.model.Identity"), 399);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeIdentity", "org.exoplatform.social.addons.storage.RDBMSIdentityStorageImpl", "org.exoplatform.social.core.identity.model.Identity", "identity", "", "void"), 738);
    }
}

