/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.storage.dao.jpa.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import org.exoplatform.social.addons.search.ExtendProfileFilter;
import org.exoplatform.social.addons.storage.entity.IdentityEntity;
import org.exoplatform.social.addons.storage.entity.IdentityEntity_;
import org.exoplatform.social.addons.storage.entity.ProfileExperienceEntity_;
import org.exoplatform.social.core.identity.model.Identity;

public class ProfileQueryBuilder {
    ExtendProfileFilter filter;

    private ProfileQueryBuilder() {
    }

    public static ProfileQueryBuilder builder() {
        return new ProfileQueryBuilder();
    }

    public ProfileQueryBuilder withFilter(ExtendProfileFilter filter) {
        this.filter = filter;
        return this;
    }

    public TypedQuery[] build(EntityManager em) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(IdentityEntity.class);
        Root identity = query.from(IdentityEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (this.filter != null) {
            MapJoin properties;
            String val;
            String name;
            String all;
            if (this.filter.isForceLoadProfile()) {
                // empty if block
            }
            if (this.filter.isExcludeDeleted()) {
                predicates.add(cb.isFalse((Expression)identity.get(IdentityEntity_.deleted)));
            }
            if (this.filter.isExcludeDisabled()) {
                predicates.add(cb.isTrue((Expression)identity.get(IdentityEntity_.enabled)));
            }
            if (this.filter.getIdentityIds() != null && this.filter.getIdentityIds().size() > 0) {
                predicates.add(identity.get(IdentityEntity_.id).in(this.filter.getIdentityIds()));
            }
            if (this.filter.getProviderId() != null && !this.filter.getProviderId().isEmpty()) {
                predicates.add(cb.equal((Expression)identity.get(IdentityEntity_.providerId), (Object)this.filter.getProviderId()));
            }
            SetJoin experience = null;
            List<Identity> excludes = this.filter.getExcludedIdentityList();
            if (excludes != null && excludes.size() > 0) {
                ArrayList<Long> ids = new ArrayList<Long>(excludes.size());
                for (Identity id : excludes) {
                    ids.add(Long.parseLong(id.getId()));
                }
                predicates.add(cb.not((Expression)identity.get(IdentityEntity_.id).in(ids)));
            }
            if ((all = this.filter.getAll()) == null || all.trim().isEmpty()) {
                name = this.filter.getName();
                if (name != null && !name.isEmpty()) {
                    name = this.processLikeString(name);
                    MapJoin properties2 = identity.join(IdentityEntity_.properties, JoinType.LEFT);
                    predicates.add(cb.and((Expression)cb.like(cb.lower((Expression)properties2.value()), name), (Expression)properties2.key().in(Arrays.asList("firstName", "lastName", "fullName"))));
                }
                if ((val = this.filter.getPosition()) != null && !val.isEmpty()) {
                    val = this.processLikeString(val);
                    Predicate[] p = new Predicate[2];
                    MapJoin properties3 = identity.join(IdentityEntity_.properties, JoinType.LEFT);
                    p[1] = cb.and((Expression)cb.like(cb.lower((Expression)properties3.value()), val), (Expression)cb.equal((Expression)properties3.key(), (Object)"position"));
                    if (experience == null) {
                        experience = identity.join(IdentityEntity_.experiences, JoinType.LEFT);
                    }
                    p[0] = cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.position)), val);
                    predicates.add(cb.or(p));
                }
                if ((val = this.filter.getSkills()) != null && !val.isEmpty()) {
                    val = this.processLikeString(val);
                    if (experience == null) {
                        experience = identity.join(IdentityEntity_.experiences, JoinType.LEFT);
                    }
                    predicates.add(cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.skills)), val));
                }
                if ((val = this.filter.getCompany()) != null && !val.isEmpty()) {
                    val = this.processLikeString(val);
                    if (experience == null) {
                        experience = identity.join(IdentityEntity_.experiences, JoinType.LEFT);
                    }
                    predicates.add(cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.company)), val));
                }
            } else {
                name = this.filter.getName();
                all = this.processLikeString(all).toLowerCase();
                Predicate[] p = new Predicate[5];
                properties = identity.join(IdentityEntity_.properties, JoinType.LEFT);
                p[0] = cb.and((Expression)cb.like(cb.lower((Expression)properties.value()), name), (Expression)properties.key().in(Arrays.asList("firstName", "lastName", "fullName")));
                if (experience == null) {
                    experience = identity.join(IdentityEntity_.experiences, JoinType.LEFT);
                }
                p[1] = cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.position)), all);
                p[2] = cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.skills)), all);
                p[3] = cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.company)), all);
                p[4] = cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.description)), all);
                predicates.add(cb.or(p));
            }
            char c = this.filter.getFirstCharacterOfName();
            if (c != '\u0000') {
                val = Character.toLowerCase(c) + "%";
                properties = identity.join(IdentityEntity_.properties, JoinType.LEFT);
                predicates.add(cb.and((Expression)cb.equal((Expression)properties.key(), (Object)"lastName"), (Expression)cb.like(cb.lower((Expression)properties.value()), val)));
            }
        }
        Predicate[] pds = predicates.toArray(new Predicate[predicates.size()]);
        query.select((Selection)cb.countDistinct((Expression)identity)).where(pds);
        TypedQuery count = em.createQuery(query);
        query.select((Selection)identity).distinct(true).where(pds);
        TypedQuery select = em.createQuery(query);
        return new TypedQuery[]{select, count};
    }

    private String processLikeString(String s) {
        return "%" + s.toLowerCase() + "%";
    }
}

