/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.spacemanagementnotification;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

@Path(value="/spacemanagementinformation")
@Produces(value={"application/json"})
public class SpaceManagementInformationRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(SpaceManagementInformationRestService.class);
    private SpaceService spaceService_;
    private IdentityManager identityManager_;

    public SpaceManagementInformationRestService(SpaceService spaceService, IdentityManager identityManager) {
        this.spaceService_ = spaceService;
        this.identityManager_ = identityManager;
    }

    @GET
    @Path(value="getRequestsToValidate")
    public Response getRequestsToValidate(@Context UriInfo uriInfo, @Context SecurityContext sc) {
        MediaType mediaType = Util.getMediaType((String)"json");
        String userId = this.getUserId(sc, uriInfo);
        if (userId == null) {
            return Response.status((int)500).build();
        }
        ArrayList<SpaceResult> spacesUserIsManager = new ArrayList<SpaceResult>();
        try {
            List userSpaces = this.spaceService_.getAccessibleSpaces(userId);
            for (Space space : userSpaces) {
                if (!this.spaceService_.isManager(space, userId) || space.getPendingUsers() == null || space.getPendingUsers().length == 0) continue;
                spacesUserIsManager.add(new SpaceResult(space));
            }
        }
        catch (SpaceException e) {
            LOG.error((Object)("Error when getting user spaces: " + e.getMessage()), (Throwable)e);
            return this.renderJSON(new String("error"));
        }
        return this.renderJSON(spacesUserIsManager);
    }

    @GET
    @Path(value="request/confirm/{spaceId}/{requestedUserId}")
    public Response confirm(@PathParam(value="spaceId") String spaceId, @PathParam(value="requestedUserId") String requestedUserId, @Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).build();
            }
            Space space = this.spaceService_.getSpaceById(spaceId);
            if (space == null) {
                return Response.status((int)500).build();
            }
            if (!this.spaceService_.isManager(space, userId)) {
                return Response.status((int)500).build();
            }
            this.spaceService_.addMember(space, requestedUserId);
            return this.renderJSON(new String("Confirmed"));
        }
        catch (Exception e) {
            LOG.error((Object)("Error in validatating request: " + e.getMessage()), (Throwable)e);
            return this.renderJSON(new String("error"));
        }
    }

    @GET
    @Path(value="request/deny/{spaceId}/{requestedUserId}")
    public Response deny(@PathParam(value="spaceId") String spaceId, @PathParam(value="requestedUserId") String requestedUserId, @Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).build();
            }
            Space space = this.spaceService_.getSpaceById(spaceId);
            if (space == null) {
                return Response.status((int)500).build();
            }
            if (!this.spaceService_.isManager(space, userId)) {
                return Response.status((int)500).build();
            }
            this.spaceService_.removePendingUser(space, requestedUserId);
            return this.renderJSON(new String("Confirmed"));
        }
        catch (Exception e) {
            LOG.error((Object)("Error in validatating request: " + e.getMessage()), (Throwable)e);
            return this.renderJSON(new String("error"));
        }
    }

    private String getUserId(SecurityContext sc, UriInfo uriInfo) {
        try {
            return sc.getUserPrincipal().getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Response renderJSON(Object result) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        return Response.ok((Object)result, (String)"application/json").cacheControl(cacheControl).build();
    }

    public class SpaceResult {
        private String spaceId;
        private String displayName;
        private String spaceAvatarUrl;
        private String spaceRegistration;
        private int membersNumber;
        private List<UserResult> pendingUsers;

        public SpaceResult(Space space) {
            this.spaceId = space.getId();
            this.displayName = space.getDisplayName();
            this.spaceAvatarUrl = space.getAvatarUrl();
            this.spaceRegistration = space.getRegistration();
            this.membersNumber = space.getMembers().length;
            this.pendingUsers = new ArrayList<UserResult>();
            for (String user : space.getPendingUsers()) {
                this.pendingUsers.add(new UserResult(user));
            }
        }

        public String getSpaceId() {
            return this.spaceId;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public List<UserResult> getPendingUsers() {
            return this.pendingUsers;
        }

        public String getSpaceAvatarUrl() {
            return this.spaceAvatarUrl;
        }

        public void setSpaceAvatarUrl(String spaceAvatarUrl) {
            this.spaceAvatarUrl = spaceAvatarUrl;
        }

        public String getSpaceRegistration() {
            return this.spaceRegistration;
        }

        public void setSpaceRegistration(String spaceRegistration) {
            this.spaceRegistration = spaceRegistration;
        }

        public int getMembersNumber() {
            return this.membersNumber;
        }

        public void setMembersNumber(int membersNumber) {
            this.membersNumber = membersNumber;
        }
    }

    public class UserResult {
        private String username;
        private String userAvatarUrl;
        private String fullName;

        public UserResult(String username) {
            this.username = username;
            Identity identity = SpaceManagementInformationRestService.this.identityManager_.getOrCreateIdentity("organization", username, true);
            this.userAvatarUrl = identity.getProfile().getAvatarUrl();
            this.fullName = identity.getProfile().getFullName();
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getUserAvatarUrl() {
            return this.userAvatarUrl;
        }

        public void setUserAvatarUrl(String userAvatarUrl) {
            this.userAvatarUrl = userAvatarUrl;
        }

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }
    }
}

