/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.spacesadministration;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.security.MembershipEntry;

public class SettingsSpacesAdministrationStorage {
    public static final String SETTINGS = "spacesAdministrationMemberships";
    public static final String MEMBERSHIPS_SETTING_SEPARATOR = ",";
    private SettingService settingService;

    public SettingsSpacesAdministrationStorage(SettingService settingService) {
        this.settingService = settingService;
    }

    public boolean settingsEntityExists() throws Exception {
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), SETTINGS);
        return settingValue != null && settingValue.getValue() != null;
    }

    public void addSpaceCreationMembership(MembershipEntry membership) throws Exception {
        if (membership == null) {
            throw new IllegalArgumentException("Cannot add null membership");
        }
        String membershipToAdd = membership.getMembershipType() + ":" + membership.getGroup();
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), SETTINGS);
        if (settingValue == null) {
            settingValue = SettingValue.create((String)membershipToAdd);
        } else {
            String values = (String)settingValue.getValue();
            if (!values.contains(membershipToAdd)) {
                values = values + MEMBERSHIPS_SETTING_SEPARATOR + membershipToAdd;
            }
            settingValue = SettingValue.create((String)values);
        }
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(null), SETTINGS, settingValue);
    }

    public List<MembershipEntry> getSpaceCreationMemberships() throws Exception {
        ArrayList<MembershipEntry> memberships = new ArrayList<MembershipEntry>();
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), SETTINGS);
        if (settingValue != null) {
            String[] membershipIds;
            String values = (String)settingValue.getValue();
            for (String membershipId : membershipIds = values.split(MEMBERSHIPS_SETTING_SEPARATOR)) {
                String[] membershipParts = membershipId.split(":");
                memberships.add(new MembershipEntry(membershipParts[1], membershipParts[0]));
            }
        }
        return memberships;
    }

    public void deleteSpaceCreationMembership(MembershipEntry membership) throws Exception {
        String values;
        if (membership == null) {
            throw new IllegalArgumentException("Cannot delete null membership");
        }
        String membershipToDelete = membership.getMembershipType() + ":" + membership.getGroup();
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), SETTINGS);
        if (settingValue != null && (values = (String)settingValue.getValue()).contains(membershipToDelete)) {
            values = values.replace(membershipToDelete + MEMBERSHIPS_SETTING_SEPARATOR, "");
            values = values.replace(MEMBERSHIPS_SETTING_SEPARATOR + membershipToDelete, "");
            if ((values = values.replace(membershipToDelete, "")).trim().isEmpty()) {
                this.settingService.remove(Context.GLOBAL, Scope.GLOBAL.id(null), SETTINGS);
            } else {
                settingValue = SettingValue.create((String)values.trim());
                this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(null), SETTINGS, settingValue);
            }
        }
    }

    public void deleteSettingsEntity() throws RepositoryException {
        this.settingService.remove(Context.GLOBAL, Scope.GLOBAL.id(null), SETTINGS);
    }
}

