/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.cas.plugin;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gatein.sso.plugin.RestCallbackCaller;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;

public class CAS40AuthenticationPlugin
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final Log log = LogFactory.getLog(CAS40AuthenticationPlugin.class);
    private String gateInProtocol;
    private String gateInHost;
    private String gateInPort;
    private String gateInContext;
    private String httpMethod;
    private volatile RestCallbackCaller restCallbackCaller;

    public String getGateInHost() {
        return this.gateInHost;
    }

    public void setGateInHost(String gateInHost) {
        this.gateInHost = gateInHost;
    }

    public String getGateInPort() {
        return this.gateInPort;
    }

    public void setGateInPort(String gateInPort) {
        this.gateInPort = gateInPort;
    }

    public String getGateInContext() {
        return this.gateInContext;
    }

    public void setGateInContext(String gateInContext) {
        this.gateInContext = gateInContext;
    }

    public String getGateInProtocol() {
        return this.gateInProtocol;
    }

    public void setGateInProtocol(String gateInProtocol) {
        this.gateInProtocol = gateInProtocol;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credentials) throws GeneralSecurityException, PreventedException {
        boolean valid;
        try {
            String username = credentials.getUsername();
            String password = credentials.getPassword();
            valid = this.getRestCallbackCaller().executeRemoteCall(username, password);
        }
        catch (Exception e) {
            log.error((Object)"Remote Authentication Failed");
            log.error((Object)this, (Throwable)e);
            valid = false;
        }
        if (!valid) {
            throw new FailedLoginException();
        }
        return this.createHandlerResult((Credential)credentials, (Principal)new SimplePrincipal(credentials.getUsername()), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestCallbackCaller getRestCallbackCaller() {
        if (this.restCallbackCaller == null) {
            CAS40AuthenticationPlugin cAS40AuthenticationPlugin = this;
            synchronized (cAS40AuthenticationPlugin) {
                if (this.restCallbackCaller == null) {
                    this.restCallbackCaller = new RestCallbackCaller(this.gateInProtocol, this.gateInHost, this.gateInPort, this.gateInContext, this.httpMethod);
                }
            }
        }
        return this.restCallbackCaller;
    }
}

