/*
 * Decompiled with CFR 0.152.
 */
package org.josso.util.config;

import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.util.config.ConfigurationContext;
import org.josso.util.config.ConfigurationHandler;

public class XUpdateConfigurationHandler
implements ConfigurationHandler {
    private static final Log logger = LogFactory.getLog((Class)XUpdateConfigurationHandler.class);
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss_SSS");
    private ConfigurationContext _ctx;
    public static final String XUPDATE_START = "<xupdate:modifications version=\"1.0\"\n       xmlns:xupdate=\"http://www.xmldb.org/xupdate\">\n";
    public static final String XUPDATE_END = "\n</xupdate:modifications> ";
    private String elementsBaseLocation;
    private String newElementsBaseLocation;

    public XUpdateConfigurationHandler(ConfigurationContext ctx, String elementsBaseLocation, String newElementsBaseLocation) {
        this(elementsBaseLocation, newElementsBaseLocation);
        this._ctx = ctx;
    }

    public XUpdateConfigurationHandler(String elementsBaseLocation, String newElementsBaseLocation) {
        System.setProperty("org.xmldb.common.xml.queries.XPathQueryFactory", "org.xmldb.common.xml.queries.xalan2.XPathQueryFactoryImpl");
        this.elementsBaseLocation = elementsBaseLocation;
        this.newElementsBaseLocation = newElementsBaseLocation;
    }

    public void setSSOConfigurationContext(ConfigurationContext ctx) {
        this._ctx = ctx;
    }

    public ConfigurationContext getSSOConfigurationContext() {
        return this._ctx;
    }

    public void saveElement(String element, String oldValue, String newValue) {
        if (!this._ctx.isConfigurationUpdatable()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("saveElement : " + element + " [" + oldValue + "/" + newValue + "] at " + this.elementsBaseLocation + " " + this.newElementsBaseLocation));
        }
        try {
            String qry = oldValue == null ? this.buildXInsertAfterElementQueryString(this.newElementsBaseLocation, element, this.unicodeEscape(newValue)) : this.buildXUPdateElementQueryString(this.elementsBaseLocation + "/" + element, this.unicodeEscape(newValue));
            this.updateConfiguration(qry);
        }
        catch (Exception e) {
            logger.error((Object)("Can't update configuration element for : " + element + ", new value : " + newValue + " :\n" + e.getMessage()), (Throwable)e);
        }
    }

    public void removeElement(String element) {
        try {
            if (!this._ctx.isConfigurationUpdatable()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("removeElement : " + element + " at " + this.elementsBaseLocation));
            }
            String qry = this.buildXDeleteElementQuery(this.elementsBaseLocation, element);
            this.updateConfiguration(qry);
        }
        catch (Exception e) {
            logger.error((Object)("Can't update configuration element for : " + element + " :\n" + e.getMessage()), (Throwable)e);
        }
    }

    protected void updateConfiguration(String qry) throws Exception {
        if (!this._ctx.isConfigurationUpdatable()) {
            return;
        }
    }

    protected String buildXUPdateElementQueryString(String xpathExpr, String newValue) {
        String qry = "<xupdate:modifications version=\"1.0\"\n       xmlns:xupdate=\"http://www.xmldb.org/xupdate\">\n\t<xupdate:update select=\"" + xpathExpr + "\">" + newValue + "</xupdate:update>" + XUPDATE_END;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildXUPdateElementQueryString(" + xpathExpr + "," + newValue + ") = \n" + qry));
        }
        return qry;
    }

    protected String buildXAppendElementQueryString(String xpathExpr, String element, String value) {
        String qry = "<xupdate:modifications version=\"1.0\"\n       xmlns:xupdate=\"http://www.xmldb.org/xupdate\">\n\t<xupdate:append select=\"" + xpathExpr + "\" >\n" + "\t\t<xupdate:element name=\"" + element + "\">" + value + "</xupdate:element>\n" + "\t</xupdate:append>" + XUPDATE_END;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildXAppendElementQueryString(" + xpathExpr + "," + element + "," + value + ") = \n" + qry));
        }
        return qry;
    }

    protected String buildXInsertAfterElementQueryString(String xpathExpr, String element, String value) {
        String qry = "<xupdate:modifications version=\"1.0\"\n       xmlns:xupdate=\"http://www.xmldb.org/xupdate\">\n\t<xupdate:insert-after select=\"" + xpathExpr + "\" >\n" + "\t\t<xupdate:element name=\"" + element + "\">" + value + "</xupdate:element>\n" + "\t</xupdate:insert-after>" + XUPDATE_END;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildXAppendElementQueryString(" + xpathExpr + "," + element + "," + value + ") = \n" + qry));
        }
        return qry;
    }

    protected String buildXAppendElementXMLQueryString(String xpathExpr, String element, String xml) {
        String qry = "<xupdate:modifications version=\"1.0\"\n       xmlns:xupdate=\"http://www.xmldb.org/xupdate\">\n\t<xupdate:append select=\"" + xpathExpr + "\" >\n" + "\t\t<xupdate:element name=\"" + element + "\">\n" + xml + "\n" + "\t\t</xupdate:element>\n" + "\t</xupdate:append>" + XUPDATE_END;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildXInsertXMLQueryString(" + xpathExpr + "," + element + "," + xml + ") = \n" + qry));
        }
        return qry;
    }

    protected String buildXDeleteElementQuery(String xpathExpr, String element) {
        String qry = "<xupdate:modifications version=\"1.0\"\n       xmlns:xupdate=\"http://www.xmldb.org/xupdate\">\n\t<xupdate:remove select=\"" + xpathExpr + "/" + element + "\"/>" + XUPDATE_END;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildXDeleteElementQuery(" + xpathExpr + "," + element + ") = \n" + qry));
        }
        return qry;
    }

    protected String getElementsBaseLocation() {
        return this.elementsBaseLocation;
    }

    protected String getNewElementsBaseLocation() {
        return this.newElementsBaseLocation;
    }

    public String unicodeEscape(String v) {
        StringWriter w = new StringWriter();
        int len = v.length();
        block7: for (int j = 0; j < len; ++j) {
            char c = v.charAt(j);
            switch (c) {
                case '&': {
                    w.write("&amp;");
                    continue block7;
                }
                case '<': {
                    w.write("&lt;");
                    continue block7;
                }
                case '>': {
                    w.write("&gt;");
                    continue block7;
                }
                case '\'': {
                    w.write("&apos;");
                    continue block7;
                }
                case '\"': {
                    w.write("&quot;");
                    continue block7;
                }
                default: {
                    if (XUpdateConfigurationHandler.canEncode(c)) {
                        w.write(c);
                        continue block7;
                    }
                    w.write("&#");
                    w.write(Integer.toString(c));
                    w.write(59);
                }
            }
        }
        return w.toString();
    }

    public static boolean canEncode(char c) {
        return c < '\u007f';
    }
}

