/*
 * Decompiled with CFR 0.152.
 */
package org.josso.auth.scheme;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.Credential;
import org.josso.auth.CredentialKey;
import org.josso.auth.CredentialProvider;
import org.josso.auth.CredentialStore;
import org.josso.auth.CredentialStoreKeyAdapter;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.auth.scheme.AuthenticationScheme;
import org.josso.gateway.identity.exceptions.SSOIdentityException;

public abstract class AbstractAuthenticationScheme
implements AuthenticationScheme {
    private static final Log logger = LogFactory.getLog(AbstractAuthenticationScheme.class);
    private boolean _authenticated;
    protected Subject _subject;
    protected CredentialStore _credentialStore;
    protected CredentialStoreKeyAdapter _credentialStoreKeyAdapter;
    protected CredentialProvider _credentialProvider = this.doMakeCredentialProvider();
    protected Credential[] _inputCredentials;
    protected String _name;

    public void initialize(Credential[] userCredentials, Subject s) {
        this._inputCredentials = userCredentials;
        this._subject = s;
        this._authenticated = false;
        this._credentialProvider = this.doMakeCredentialProvider();
    }

    public void confirm() {
        if (!this.isAuthenticated()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[cancel()], ignored. Not authenticated for this scheme.");
            }
            return;
        }
        Principal principal = this.getPrincipal();
        Credential[] pc = null;
        Set<Principal> principals = this._subject.getPrincipals();
        principals.add(principal);
        Set<Object> privateCredentials = this._subject.getPrivateCredentials();
        pc = this.getPrivateCredentials();
        for (int i = 0; i < pc.length; ++i) {
            privateCredentials.add(pc[i]);
        }
        Set<Object> publicCredentials = this._subject.getPublicCredentials();
        pc = this.getPublicCredentials();
        for (int i = 0; i < pc.length; ++i) {
            publicCredentials.add(pc[i]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[confirm()], ok");
        }
    }

    public void cancel() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[cancel()], ok");
        }
        this.setAuthenticated(false);
    }

    public Credential newCredential(String name, Object value) {
        return this._credentialProvider.newCredential(name, value);
    }

    public Credential newEncodedCredential(String name, Object value) {
        return this._credentialProvider.newEncodedCredential(name, value);
    }

    protected boolean isAuthenticated() {
        return this._authenticated;
    }

    protected void setAuthenticated(boolean a) {
        this._authenticated = a;
    }

    protected Credential[] getKnownCredentials() throws SSOAuthenticationException {
        try {
            CredentialKey key = this.getCredentialStoreKeyAdapter().getKeyForPrincipal(this.getPrincipal());
            return this._credentialStore.loadCredentials(key, this);
        }
        catch (SSOIdentityException e) {
            throw new SSOAuthenticationException(e.getMessage(), e);
        }
    }

    protected CredentialStore getCredentialStore() {
        return this._credentialStore;
    }

    protected CredentialStoreKeyAdapter getCredentialStoreKeyAdapter() {
        return this._credentialStoreKeyAdapter;
    }

    public void setCredentialStore(CredentialStore c) {
        this._credentialStore = c;
    }

    public void setCredentialStoreKeyAdapter(CredentialStoreKeyAdapter a) {
        this._credentialStoreKeyAdapter = a;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected abstract CredentialProvider doMakeCredentialProvider();

    public void setName(String name) {
        logger.debug((Object)("setName() = " + name));
        this._name = name;
    }

    public String getName() {
        return this._name;
    }
}

