/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.impl.EmptyAttributeManager;
import org.picketlink.identity.federation.core.interfaces.AttributeManager;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.picketlink.identity.federation.web.handlers.saml2.SecurityActions;

public class SAML2AttributeHandler
extends BaseSAML2Handler {
    protected AttributeManager attribManager = new EmptyAttributeManager();
    protected List<String> attributeKeys = new ArrayList<String>();
    protected boolean chooseFriendlyName = false;

    public void initChainConfig(SAML2HandlerChainConfig handlerChainConfig) throws ConfigurationException {
        super.initChainConfig(handlerChainConfig);
        Object config = this.handlerChainConfig.getParameter("CONFIGURATION");
        if (config instanceof IDPType && this.getAttributeManager() == null) {
            IDPType idpType = (IDPType)config;
            String attribStr = idpType.getAttributeManager();
            this.insantiateAttributeManager(attribStr);
        }
    }

    private Object getAttributeManager() {
        if (this.handlerConfig == null) {
            return null;
        }
        return this.handlerConfig.getParameter("ATTRIBUTE_MANAGER");
    }

    public void initHandlerConfig(SAML2HandlerConfig handlerConfig) throws ConfigurationException {
        String chooseFriendlyNameStr;
        super.initHandlerConfig(handlerConfig);
        String attribStr = (String)this.getAttributeManager();
        this.insantiateAttributeManager(attribStr);
        String attribList = (String)this.handlerConfig.getParameter("ATTRIBUTE_KEYS");
        if (StringUtil.isNotNull(attribList)) {
            this.attributeKeys.addAll(StringUtil.tokenize(attribList));
        }
        if (StringUtil.isNotNull(chooseFriendlyNameStr = (String)handlerConfig.getParameter("ATTRIBUTE_CHOOSE_FRIENDLY_NAME"))) {
            this.chooseFriendlyName = Boolean.parseBoolean(chooseFriendlyNameStr);
        }
    }

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Map<String, Object> attribs;
        if (request.getSAML2Object() instanceof LogoutRequestType) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.SP) {
            return;
        }
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpSession session = httpContext.getRequest().getSession(false);
        Principal userPrincipal = (Principal)session.getAttribute("picketlink.principal");
        if (userPrincipal == null) {
            userPrincipal = httpContext.getRequest().getUserPrincipal();
        }
        if ((attribs = (Map<String, Object>)session.getAttribute("ATTRIBUTES")) == null) {
            attribs = this.attribManager.getAttributes(userPrincipal, this.attributeKeys);
            session.setAttribute("ATTRIBUTES", attribs);
        }
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            return;
        }
        this.handleIDPResponse(request);
    }

    private void insantiateAttributeManager(String attribStr) throws ConfigurationException {
        if (attribStr != null && !"".equals(attribStr)) {
            try {
                this.attribManager = (AttributeManager)SecurityActions.loadClass(this.getClass(), attribStr).newInstance();
                logger.samlHandlerAttributeSetup(this.attribManager.getClass().getName());
            }
            catch (Exception e) {
                logger.attributeProviderInstationError(e);
                throw logger.configurationError(e);
            }
        }
    }

    protected void handleIDPResponse(SAML2HandlerRequest request) {
        if (!(request.getSAML2Object() instanceof ResponseType)) {
            return;
        }
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpSession session = httpContext.getRequest().getSession(false);
        AssertionType assertion = (AssertionType)request.getOptions().get("ASSERTION");
        if (assertion == null) {
            throw logger.samlHandlerAssertionNotFound();
        }
        Set<StatementAbstractType> statements = assertion.getStatements();
        for (StatementAbstractType statement : statements) {
            if (!(statement instanceof AttributeStatementType)) continue;
            AttributeStatementType attrStat = (AttributeStatementType)statement;
            List<AttributeStatementType.ASTChoiceType> attrs = attrStat.getAttributes();
            for (AttributeStatementType.ASTChoiceType attrChoice : attrs) {
                AttributeType attr = attrChoice.getAttribute();
                HashMap<String, List<Object>> attrMap = (HashMap<String, List<Object>>)session.getAttribute("SESSION_ATTRIBUTE_MAP");
                if (attrMap == null) {
                    attrMap = new HashMap<String, List<Object>>();
                    session.setAttribute("SESSION_ATTRIBUTE_MAP", attrMap);
                }
                if (this.chooseFriendlyName) {
                    attrMap.put(attr.getFriendlyName(), attr.getAttributeValue());
                    continue;
                }
                attrMap.put(attr.getName(), attr.getAttributeValue());
            }
        }
    }
}

