/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.exceptions.fed.IssuerNotTrustedException;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.TrustType;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.factories.JBossSAMLAuthnResponseFactory;
import org.picketlink.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.web.util.HTTPRedirectUtil;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;

public class IDPWebRequestUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private boolean redirectProfile = false;
    private boolean postProfile = false;
    private final IDPType idpConfiguration;
    private final TrustKeyManager keyManager;
    protected String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";

    public IDPWebRequestUtil(HttpServletRequest request, IDPType idp, TrustKeyManager keym) {
        this.idpConfiguration = idp;
        this.keyManager = keym;
        this.redirectProfile = "GET".equals(request.getMethod());
        this.postProfile = "POST".equals(request.getMethod());
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setCanonicalizationMethod(String canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public boolean hasSAMLRequestInRedirectProfile() {
        return this.redirectProfile;
    }

    public boolean hasSAMLRequestInPostProfile() {
        return this.postProfile;
    }

    public SAMLDocumentHolder getSAMLDocumentHolder(String samlMessage) throws ParsingException, ConfigurationException, ProcessingException {
        InputStream is = null;
        SAML2Request saml2Request = new SAML2Request();
        try {
            is = this.redirectProfile ? this.parseSAMLRequestRedirectBinding(samlMessage) : this.parseSAMLRequestPostBinding(samlMessage);
            saml2Request.getSAML2ObjectFromStream(is);
            return saml2Request.getSamlDocumentHolder();
        }
        catch (Exception rte) {
            logger.samlBase64DecodingError((Throwable)rte);
            return null;
        }
    }

    public RequestAbstractType getSAMLRequest(String samlMessage) throws ParsingException, ConfigurationException, ProcessingException {
        InputStream is = null;
        SAML2Request saml2Request = new SAML2Request();
        if (this.redirectProfile) {
            try {
                is = this.parseSAMLRequestRedirectBinding(samlMessage);
            }
            catch (Exception e) {
                logger.samlParsingError((Throwable)e);
                throw logger.parserError((Throwable)e);
            }
        } else {
            is = this.parseSAMLRequestPostBinding(samlMessage);
        }
        return saml2Request.getRequestType(is);
    }

    public void isTrusted(String issuer) throws IssuerNotTrustedException {
        if (this.idpConfiguration == null) {
            throw logger.nullValueError("IDP Configuration");
        }
        try {
            String issuerDomain = IDPWebRequestUtil.getDomain(issuer);
            TrustType idpTrust = this.idpConfiguration.getTrust();
            if (idpTrust != null) {
                String domainsTrusted = idpTrust.getDomains();
                logger.trace("Domains that IDP trusts = " + domainsTrusted + " and issuer domain = " + issuerDomain);
                if (domainsTrusted.indexOf(issuerDomain) < 0) {
                    StringTokenizer st = new StringTokenizer(domainsTrusted, ",");
                    while (st != null && st.hasMoreTokens()) {
                        String uriBit = st.nextToken();
                        logger.trace("Matching uri bit = " + uriBit);
                        if (issuerDomain.indexOf(uriBit) <= 0) continue;
                        logger.trace("Matched " + uriBit + " trust for " + issuerDomain);
                        return;
                    }
                    throw logger.samlIssuerNotTrustedError(issuer);
                }
            }
        }
        catch (Exception e) {
            throw logger.samlIssuerNotTrustedException((Throwable)e);
        }
    }

    public void send(WebRequestUtilHolder holder) throws GeneralSecurityException, IOException {
        Document responseDoc = holder.getResponseDoc();
        if (responseDoc == null) {
            throw logger.nullValueError("responseType");
        }
        String destination = holder.getDestination();
        String relayState = holder.getRelayState();
        boolean supportSignature = holder.isSupportSignature();
        boolean sendRequest = holder.isAreWeSendingRequest();
        HttpServletResponse response = holder.getServletResponse();
        boolean isErrorResponse = holder.isErrorResponse();
        if (!holder.isPostBinding()) {
            String finalDest = null;
            if (holder.getDestinationQueryStringWithSignature() != null) {
                finalDest = destination + "?" + holder.getDestinationQueryStringWithSignature();
            } else {
                byte[] responseBytes = DocumentUtil.getDocumentAsString((Document)responseDoc).getBytes("UTF-8");
                String urlEncodedResponse = RedirectBindingUtil.deflateBase64URLEncode(responseBytes);
                if (StringUtil.isNotNull((String)relayState)) {
                    relayState = RedirectBindingUtil.urlEncode(relayState);
                }
                finalDest = destination + this.getDestination(urlEncodedResponse, relayState, supportSignature, sendRequest, isErrorResponse);
            }
            logger.trace("Destination = " + finalDest);
            HTTPRedirectUtil.sendRedirectForResponder(finalDest, response);
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("SAML Response Document: " + DocumentUtil.asString((Document)responseDoc));
            }
            byte[] responseBytes = DocumentUtil.getDocumentAsString((Document)responseDoc).getBytes("UTF-8");
            String samlResponse = PostBindingUtil.base64Encode(new String(responseBytes));
            PostBindingUtil.sendPost(new DestinationInfoHolder(destination, samlResponse, relayState), response, sendRequest);
        }
    }

    public String getDestination(String urlEncodedResponse, String urlEncodedRelayState, boolean supportSignature, boolean sendRequest, boolean errorResponse) {
        StringBuilder sb = new StringBuilder();
        if (supportSignature && errorResponse) {
            try {
                sb.append("?");
                sb.append(RedirectBindingSignatureUtil.getSAMLResponseURLWithSignature(urlEncodedResponse, urlEncodedRelayState, this.keyManager.getSigningKey()));
            }
            catch (Exception e) {
                logger.trace((Throwable)e);
            }
        } else {
            if (sendRequest) {
                sb.append("?SAMLRequest=").append(urlEncodedResponse);
            } else {
                sb.append("?SAMLResponse=").append(urlEncodedResponse);
            }
            if (StringUtil.isNotNull((String)urlEncodedRelayState)) {
                sb.append("&RelayState=").append(urlEncodedRelayState);
            }
        }
        return sb.toString();
    }

    public WebRequestUtilHolder getHolder() {
        return new WebRequestUtilHolder();
    }

    public Document getErrorResponse(String responseURL, String status, String identityURL, boolean supportSignature) {
        Document samlResponse = null;
        ResponseType responseType = null;
        SAML2Response saml2Response = new SAML2Response();
        String id = IDGenerator.create("ID_");
        IssuerInfoHolder issuerHolder = new IssuerInfoHolder(identityURL);
        issuerHolder.setStatusCode(status);
        IDPInfoHolder idp = new IDPInfoHolder();
        idp.setNameIDFormatValue(null);
        idp.setNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get());
        SPInfoHolder sp = new SPInfoHolder();
        sp.setResponseDestinationURI(responseURL);
        responseType = saml2Response.createResponseType(id);
        responseType.setStatus(JBossSAMLAuthnResponseFactory.createStatusType(status));
        if (logger.isTraceEnabled()) {
            StringWriter sw = new StringWriter();
            try {
                saml2Response.marshall(responseType, sw);
            }
            catch (ProcessingException e) {
                logger.trace((Throwable)e);
            }
            logger.trace("SAML Response Document: " + sw.toString());
        }
        if (supportSignature) {
            try {
                SAML2Signature ss = new SAML2Signature();
                samlResponse = ss.sign(responseType, this.keyManager.getSigningKeyPair());
            }
            catch (Exception e) {
                logger.trace((Throwable)e);
                throw new RuntimeException(logger.signatureError((Throwable)e));
            }
        }
        try {
            samlResponse = saml2Response.convert(responseType);
        }
        catch (Exception e) {
            logger.trace((Throwable)e);
        }
        return samlResponse;
    }

    private static String getDomain(String domainURL) throws IOException {
        URL url = new URL(domainURL);
        return url.getHost();
    }

    private InputStream parseSAMLRequestPostBinding(String samlMessage) {
        byte[] samlBytes = PostBindingUtil.base64Decode(samlMessage);
        logger.trace("SAML Request Document: " + new String(samlBytes));
        ByteArrayInputStream is = new ByteArrayInputStream(samlBytes);
        return is;
    }

    private InputStream parseSAMLRequestRedirectBinding(String samlMessage) {
        InputStream is = RedirectBindingUtil.base64DeflateDecode(samlMessage);
        return is;
    }

    public class WebRequestUtilHolder {
        private Document responseDoc;
        private String relayState;
        private String destination;
        private HttpServletResponse servletResponse;
        private PrivateKey privateKey;
        private boolean supportSignature;
        private boolean postBindingRequested;
        private boolean areWeSendingRequest;
        private boolean errorResponse = false;
        private String destinationQueryStringWithSignature;
        private boolean strictPostBinding = false;

        public boolean isStrictPostBinding() {
            return this.strictPostBinding;
        }

        public void setStrictPostBinding(boolean strictPostBinding) {
            this.strictPostBinding = strictPostBinding;
        }

        public Document getResponseDoc() {
            return this.responseDoc;
        }

        public WebRequestUtilHolder setResponseDoc(Document responseDoc) {
            this.responseDoc = responseDoc;
            return this;
        }

        public String getRelayState() {
            return this.relayState;
        }

        public WebRequestUtilHolder setRelayState(String relayState) {
            this.relayState = relayState;
            return this;
        }

        public String getDestination() {
            return this.destination;
        }

        public WebRequestUtilHolder setDestination(String destination) {
            this.destination = destination;
            return this;
        }

        public HttpServletResponse getServletResponse() {
            return this.servletResponse;
        }

        public WebRequestUtilHolder setServletResponse(HttpServletResponse servletResponse) {
            this.servletResponse = servletResponse;
            return this;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public WebRequestUtilHolder setPrivateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public boolean isSupportSignature() {
            return this.supportSignature;
        }

        public WebRequestUtilHolder setSupportSignature(boolean supportSignature) {
            this.supportSignature = supportSignature;
            return this;
        }

        public boolean isPostBindingRequested() {
            return this.postBindingRequested;
        }

        public WebRequestUtilHolder setPostBindingRequested(boolean postBindingRequested) {
            this.postBindingRequested = postBindingRequested;
            return this;
        }

        public boolean isPostBinding() {
            return this.isPostBindingRequested() || this.isStrictPostBinding();
        }

        public boolean isAreWeSendingRequest() {
            return this.areWeSendingRequest;
        }

        public WebRequestUtilHolder setAreWeSendingRequest(boolean areWeSendingRequest) {
            this.areWeSendingRequest = areWeSendingRequest;
            return this;
        }

        public boolean isErrorResponse() {
            return this.errorResponse;
        }

        public WebRequestUtilHolder setErrorResponse(boolean errorResponse) {
            this.errorResponse = errorResponse;
            return this;
        }

        public WebRequestUtilHolder setDestinationQueryStringWithSignature(String destinationQueryStringWithSignature) {
            this.destinationQueryStringWithSignature = destinationQueryStringWithSignature;
            return this;
        }

        public String getDestinationQueryStringWithSignature() {
            return this.destinationQueryStringWithSignature;
        }
    }
}

