/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.util;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.DocumentUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLEncryptionUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String CIPHER_DATA_LOCALNAME = "CipherData";
    public static final String ENCRYPTED_KEY_LOCALNAME = "EncryptedKey";
    public static final String DS_KEY_INFO = "ds:KeyInfo";
    public static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    public static String XMLSIG_NS;
    public static String XMLENC_NS;
    private static HashMap<String, EncryptionAlgorithm> algorithms;

    public static String getEncryptionURL(String certAlgo) {
        EncryptionAlgorithm ea = algorithms.get(certAlgo);
        if (ea == null) {
            throw logger.encryptUnknownAlgoError(certAlgo);
        }
        return ea.xmlSecName;
    }

    public static int getEncryptionKeySize(String certAlgo) {
        EncryptionAlgorithm ea = algorithms.get(certAlgo);
        if (ea == null) {
            throw logger.encryptUnknownAlgoError(certAlgo);
        }
        return ea.size;
    }

    public static EncryptedKey encryptKey(Document document, SecretKey keyToBeEncrypted, PublicKey keyUsedToEncryptSecretKey, int keySize) throws ProcessingException {
        XMLCipher keyCipher = null;
        String pubKeyAlg = keyUsedToEncryptSecretKey.getAlgorithm();
        try {
            String keyWrapAlgo = XMLEncryptionUtil.getXMLEncryptionURLForKeyUnwrap(pubKeyAlg, keySize);
            keyCipher = XMLCipher.getInstance((String)keyWrapAlgo);
            keyCipher.init(3, (Key)keyUsedToEncryptSecretKey);
            return keyCipher.encryptKey(document, (Key)keyToBeEncrypted);
        }
        catch (XMLEncryptionException e) {
            throw logger.processingError((Throwable)e);
        }
    }

    public static void encryptElement(QName elementQName, Document document, PublicKey publicKey, SecretKey secretKey, int keySize, QName wrappingElementQName, boolean addEncryptedKeyInKeyInfo) throws ProcessingException {
        Document encryptedDoc;
        if (elementQName == null) {
            throw logger.nullArgumentError("elementQName");
        }
        if (document == null) {
            throw logger.nullArgumentError("document");
        }
        String wrappingElementPrefix = wrappingElementQName.getPrefix();
        if (wrappingElementPrefix == null || wrappingElementPrefix == "") {
            throw logger.wrongTypeError("Wrapping element prefix invalid");
        }
        Element documentElement = DocumentUtil.getElement((Document)document, (QName)elementQName);
        if (documentElement == null) {
            throw logger.domMissingDocElementError(elementQName.toString());
        }
        XMLCipher cipher = null;
        EncryptedKey encryptedKey = XMLEncryptionUtil.encryptKey(document, secretKey, publicKey, keySize);
        String encryptionAlgorithm = XMLEncryptionUtil.getXMLEncryptionURL(secretKey.getAlgorithm(), keySize);
        try {
            cipher = XMLCipher.getInstance((String)encryptionAlgorithm);
            cipher.init(1, (Key)secretKey);
        }
        catch (XMLEncryptionException e1) {
            throw logger.processingError((Throwable)e1);
        }
        try {
            encryptedDoc = cipher.doFinal(document, documentElement);
        }
        catch (Exception e) {
            throw logger.processingError((Throwable)e);
        }
        Element encryptedKeyElement = cipher.martial(document, encryptedKey);
        String wrappingElementName = wrappingElementPrefix + ":" + wrappingElementQName.getLocalPart();
        Element wrappingElement = encryptedDoc.createElementNS(wrappingElementQName.getNamespaceURI(), wrappingElementName);
        if (wrappingElementPrefix == null || wrappingElementPrefix == "") {
            wrappingElementName = wrappingElementQName.getLocalPart();
        }
        wrappingElement.setAttributeNS(XMLNS, "xmlns:" + wrappingElementPrefix, wrappingElementQName.getNamespaceURI());
        NodeList cipherElements = encryptedDoc.getElementsByTagNameNS(XMLENC_NS, "EncryptedData");
        if (cipherElements == null || cipherElements.getLength() == 0) {
            throw logger.domMissingElementError("xenc:EncryptedData");
        }
        Element encryptedDataElement = (Element)cipherElements.item(0);
        Node parentOfEncNode = encryptedDataElement.getParentNode();
        parentOfEncNode.replaceChild(wrappingElement, encryptedDataElement);
        wrappingElement.appendChild(encryptedDataElement);
        if (addEncryptedKeyInKeyInfo) {
            Element sigElement = encryptedDoc.createElementNS(XMLSIG_NS, DS_KEY_INFO);
            sigElement.setAttributeNS(XMLNS, "xmlns:ds", XMLSIG_NS);
            sigElement.appendChild(encryptedKeyElement);
            NodeList nodeList = encryptedDoc.getElementsByTagNameNS(XMLENC_NS, CIPHER_DATA_LOCALNAME);
            if (nodeList == null || nodeList.getLength() == 0) {
                throw logger.domMissingElementError("xenc:CipherData");
            }
            Element cipherDataElement = (Element)nodeList.item(0);
            Node cipherParent = cipherDataElement.getParentNode();
            cipherParent.insertBefore(sigElement, cipherDataElement);
        } else {
            wrappingElement.appendChild(encryptedKeyElement);
        }
    }

    public static void encryptElement(Document document, Element element, PublicKey publicKey, SecretKey secretKey, int keySize) throws ProcessingException {
        Document encryptedDoc;
        if (element == null) {
            throw logger.nullArgumentError("element");
        }
        if (document == null) {
            throw logger.nullArgumentError("document");
        }
        XMLCipher cipher = null;
        EncryptedKey encryptedKey = XMLEncryptionUtil.encryptKey(document, secretKey, publicKey, keySize);
        String encryptionAlgorithm = XMLEncryptionUtil.getXMLEncryptionURL(secretKey.getAlgorithm(), keySize);
        try {
            cipher = XMLCipher.getInstance((String)encryptionAlgorithm);
            cipher.init(1, (Key)secretKey);
        }
        catch (XMLEncryptionException e1) {
            throw logger.processingError((Throwable)e1);
        }
        try {
            encryptedDoc = cipher.doFinal(document, element);
        }
        catch (Exception e) {
            throw logger.processingError((Throwable)e);
        }
        Element encryptedKeyElement = cipher.martial(document, encryptedKey);
        Element sigElement = encryptedDoc.createElementNS(XMLSIG_NS, DS_KEY_INFO);
        sigElement.setAttributeNS(XMLNS, "xmlns:ds", XMLSIG_NS);
        sigElement.appendChild(encryptedKeyElement);
        NodeList nodeList = encryptedDoc.getElementsByTagNameNS(XMLENC_NS, CIPHER_DATA_LOCALNAME);
        if (nodeList == null || nodeList.getLength() == 0) {
            throw logger.domMissingElementError("xenc:CipherData");
        }
        Element cipherDataElement = (Element)nodeList.item(0);
        Node cipherParent = cipherDataElement.getParentNode();
        cipherParent.insertBefore(sigElement, cipherDataElement);
    }

    public static Element encryptElementInDocument(Document document, PublicKey publicKey, SecretKey secretKey, int keySize, QName wrappingElementQName, boolean addEncryptedKeyInKeyInfo) throws ProcessingException, ConfigurationException {
        Document encryptedDoc;
        String wrappingElementPrefix = wrappingElementQName.getPrefix();
        if (wrappingElementPrefix == null || wrappingElementPrefix == "") {
            throw logger.wrongTypeError("Wrapping element prefix invalid");
        }
        XMLCipher cipher = null;
        EncryptedKey encryptedKey = XMLEncryptionUtil.encryptKey(document, secretKey, publicKey, keySize);
        String encryptionAlgorithm = XMLEncryptionUtil.getXMLEncryptionURL(secretKey.getAlgorithm(), keySize);
        try {
            cipher = XMLCipher.getInstance((String)encryptionAlgorithm);
            cipher.init(1, (Key)secretKey);
        }
        catch (XMLEncryptionException e1) {
            throw logger.configurationError((Throwable)e1);
        }
        try {
            encryptedDoc = cipher.doFinal(document, document.getDocumentElement());
        }
        catch (Exception e) {
            throw logger.processingError((Throwable)e);
        }
        Element encryptedKeyElement = cipher.martial(document, encryptedKey);
        String wrappingElementName = wrappingElementPrefix + ":" + wrappingElementQName.getLocalPart();
        Element wrappingElement = encryptedDoc.createElementNS(wrappingElementQName.getNamespaceURI(), wrappingElementName);
        if (wrappingElementPrefix == null || wrappingElementPrefix == "") {
            wrappingElementName = wrappingElementQName.getLocalPart();
        }
        wrappingElement.setAttributeNS(XMLNS, "xmlns:" + wrappingElementPrefix, wrappingElementQName.getNamespaceURI());
        Element encryptedDocRootElement = encryptedDoc.getDocumentElement();
        encryptedDoc.replaceChild(wrappingElement, encryptedDocRootElement);
        wrappingElement.appendChild(encryptedDocRootElement);
        if (addEncryptedKeyInKeyInfo) {
            Element sigElement = encryptedDoc.createElementNS(XMLSIG_NS, DS_KEY_INFO);
            sigElement.setAttributeNS(XMLNS, "xmlns:ds", XMLSIG_NS);
            sigElement.appendChild(encryptedKeyElement);
            NodeList nodeList = encryptedDocRootElement.getElementsByTagNameNS(XMLENC_NS, CIPHER_DATA_LOCALNAME);
            if (nodeList == null || nodeList.getLength() == 0) {
                throw logger.domMissingElementError("xenc:CipherData");
            }
            Element cipherDataElement = (Element)nodeList.item(0);
            encryptedDocRootElement.insertBefore(sigElement, cipherDataElement);
        } else {
            wrappingElement.appendChild(encryptedKeyElement);
        }
        return encryptedDoc.getDocumentElement();
    }

    public static Element decryptElementInDocument(Document documentWithEncryptedElement, PrivateKey privateKey) throws ProcessingException {
        Element decryptedRoot;
        Element dataElement;
        EncryptedKey encryptedKey;
        EncryptedData encryptedData;
        XMLCipher cipher;
        if (documentWithEncryptedElement == null) {
            throw logger.nullArgumentError("Input document is null");
        }
        Element documentRoot = documentWithEncryptedElement.getDocumentElement();
        Element encDataElement = XMLEncryptionUtil.getNextElementNode(documentRoot.getFirstChild());
        if (encDataElement == null) {
            throw logger.domMissingElementError("No element representing the encrypted data found");
        }
        Element encKeyElement = XMLEncryptionUtil.getNextElementNode(encDataElement.getNextSibling());
        if (encKeyElement == null) {
            NodeList nodeList = encDataElement.getElementsByTagNameNS(XMLENC_NS, ENCRYPTED_KEY_LOCALNAME);
            if (nodeList == null || nodeList.getLength() == 0) {
                throw logger.nullValueError("Encrypted Key not found in the enc data");
            }
            encKeyElement = (Element)nodeList.item(0);
        }
        try {
            cipher = XMLCipher.getInstance();
            cipher.init(2, null);
            encryptedData = cipher.loadEncryptedData(documentWithEncryptedElement, encDataElement);
            encryptedKey = cipher.loadEncryptedKey(documentWithEncryptedElement, encKeyElement);
        }
        catch (XMLEncryptionException e1) {
            throw logger.processingError((Throwable)e1);
        }
        Document decryptedDoc = null;
        if (encryptedData != null && encryptedKey != null) {
            try {
                String encAlgoURL = encryptedData.getEncryptionMethod().getAlgorithm();
                XMLCipher keyCipher = XMLCipher.getInstance();
                keyCipher.init(4, (Key)privateKey);
                Key encryptionKey = keyCipher.decryptKey(encryptedKey, encAlgoURL);
                cipher = XMLCipher.getInstance();
                cipher.init(2, encryptionKey);
                decryptedDoc = cipher.doFinal(documentWithEncryptedElement, encDataElement);
            }
            catch (Exception e) {
                throw logger.processingError((Throwable)e);
            }
        }
        if ((dataElement = XMLEncryptionUtil.getNextElementNode((decryptedRoot = decryptedDoc.getDocumentElement()).getFirstChild())) == null) {
            throw logger.nullValueError("Data Element after encryption is null");
        }
        decryptedRoot.removeChild(dataElement);
        decryptedDoc.replaceChild(dataElement, decryptedRoot);
        return decryptedDoc.getDocumentElement();
    }

    private static String getXMLEncryptionURLForKeyUnwrap(String publicKeyAlgo, int keySize) {
        if ("AES".equals(publicKeyAlgo)) {
            switch (keySize) {
                case 192: {
                    return "http://www.w3.org/2001/04/xmlenc#kw-aes192";
                }
                case 256: {
                    return "http://www.w3.org/2001/04/xmlenc#kw-aes256";
                }
            }
            return "http://www.w3.org/2001/04/xmlenc#kw-aes128";
        }
        if (publicKeyAlgo.contains("RSA")) {
            return "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        }
        if (publicKeyAlgo.contains("DES")) {
            return "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        }
        throw logger.unsupportedType("unsupported publicKey Algo:" + publicKeyAlgo);
    }

    private static String getXMLEncryptionURL(String algo, int keySize) {
        if ("AES".equals(algo)) {
            switch (keySize) {
                case 192: {
                    return "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
                }
                case 256: {
                    return "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
                }
            }
            return "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        }
        if (algo.contains("RSA")) {
            return "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        }
        if (algo.contains("DES")) {
            return "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        }
        throw logger.unsupportedType("Secret Key with unsupported algo:" + algo);
    }

    private static Element getNextElementNode(Node node) {
        while (node != null) {
            if (1 == node.getNodeType()) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    static {
        Init.init();
        XMLSIG_NS = "http://www.w3.org/2000/09/xmldsig#";
        XMLENC_NS = "http://www.w3.org/2001/04/xmlenc#";
        algorithms = new HashMap(4);
        algorithms.put("aes-128", new EncryptionAlgorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes128-cbc", 128));
        algorithms.put("aes-192", new EncryptionAlgorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes192-cbc", 192));
        algorithms.put("aes-256", new EncryptionAlgorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes256-cbc", 256));
        algorithms.put("aes", new EncryptionAlgorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes256-cbc", 256));
        algorithms.put("tripledes", new EncryptionAlgorithm("TripleDes", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc", 168));
    }

    private static class EncryptionAlgorithm {
        public String jceName;
        public String xmlSecName;
        public int size;

        EncryptionAlgorithm(String jceName, String xmlSecName, int size) {
            this.jceName = jceName;
            this.xmlSecName = xmlSecName;
            this.size = size;
        }
    }
}

