/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import java.io.InputStream;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.parsers.ParserNamespaceSupport;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.parsers.saml.SAML11SubjectParser;
import org.picketlink.identity.federation.core.parsers.util.SAML11ParserUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AttributeStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AuthenticationStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AuthorizationDecisionStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11ConditionsType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML11AssertionParser
implements ParserNamespaceSupport {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final String ASSERTION = JBossSAMLConstants.ASSERTION.get();

    public SAML11AssertionType fromElement(Element element) throws ConfigurationException, ProcessingException, ParsingException {
        XMLEventReader xmlEventReader = StaxParserUtil.getXMLEventReader((InputStream)DocumentUtil.getNodeAsStream((Node)element));
        return (SAML11AssertionType)this.parse(xmlEventReader);
    }

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
        startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)this.ASSERTION);
        SAML11AssertionType assertion = this.parseBaseAttributes(startElement);
        Attribute issuerAttribute = startElement.getAttributeByName(new QName("Issuer"));
        String issuer = StaxParserUtil.getAttributeValue((Attribute)issuerAttribute);
        assertion.setIssuer(issuer);
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                xmlEvent = StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                EndElement endElement = (EndElement)xmlEvent;
                String endElementTag = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (endElementTag.equals(JBossSAMLConstants.ASSERTION.get())) break;
                throw logger.parserUnknownEndElement(endElementTag);
            }
            StartElement peekedElement = null;
            peekedElement = xmlEvent instanceof StartElement ? (StartElement)xmlEvent : StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            if (peekedElement == null) break;
            String tag = StaxParserUtil.getStartElementName((StartElement)peekedElement);
            if (tag.equals(JBossSAMLConstants.SIGNATURE.get())) {
                assertion.setSignature(StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ISSUER.get().equalsIgnoreCase(tag)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                issuer = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                assertion.setIssuer(issuer);
                continue;
            }
            if (JBossSAMLConstants.SUBJECT.get().equalsIgnoreCase(tag)) {
                SAML11SubjectParser subjectParser = new SAML11SubjectParser();
                SAML11SubjectType subject = (SAML11SubjectType)subjectParser.parse(xmlEventReader);
                SAML11SubjectStatementType subStat = new SAML11SubjectStatementType();
                subStat.setSubject(subject);
                continue;
            }
            if (JBossSAMLConstants.CONDITIONS.get().equalsIgnoreCase(tag)) {
                startElement = (StartElement)xmlEvent;
                SAML11ConditionsType conditions = SAML11ParserUtil.parseSAML11Conditions(xmlEventReader);
                assertion.setConditions(conditions);
                continue;
            }
            if ("AuthenticationStatement".equals(tag)) {
                startElement = (StartElement)xmlEvent;
                SAML11AuthenticationStatementType authStat = SAML11ParserUtil.parseAuthenticationStatement(xmlEventReader);
                assertion.add(authStat);
                continue;
            }
            if ("AttributeStatement".equalsIgnoreCase(tag)) {
                SAML11AttributeStatementType attributeStatementType = SAML11ParserUtil.parseSAML11AttributeStatement(xmlEventReader);
                assertion.add(attributeStatementType);
                continue;
            }
            if ("AuthorizationDecisionStatement".equalsIgnoreCase(tag)) {
                SAML11AuthorizationDecisionStatementType authzStat = SAML11ParserUtil.parseSAML11AuthorizationDecisionStatement(xmlEventReader);
                assertion.add(authzStat);
                continue;
            }
            throw logger.parserUnknownTag(tag, peekedElement.getLocation());
        }
        return assertion;
    }

    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return nsURI.equals(JBossSAMLURIConstants.ASSERTION_NSURI.get()) && localPart.equals(JBossSAMLConstants.ASSERTION.get());
    }

    private SAML11AssertionType parseBaseAttributes(StartElement nextElement) throws ParsingException {
        Attribute idAttribute = nextElement.getAttributeByName(new QName("AssertionID"));
        if (idAttribute == null) {
            throw logger.parserRequiredAttribute("AssertionID");
        }
        String id = StaxParserUtil.getAttributeValue((Attribute)idAttribute);
        Attribute majVersionAttribute = nextElement.getAttributeByName(new QName("MajorVersion"));
        String majVersion = StaxParserUtil.getAttributeValue((Attribute)majVersionAttribute);
        StringUtil.match((String)"1", (String)majVersion);
        Attribute minVersionAttribute = nextElement.getAttributeByName(new QName("MinorVersion"));
        String minVersion = StaxParserUtil.getAttributeValue((Attribute)minVersionAttribute);
        StringUtil.match((String)"1", (String)minVersion);
        Attribute issueInstantAttribute = nextElement.getAttributeByName(new QName(JBossSAMLConstants.ISSUE_INSTANT.get()));
        XMLGregorianCalendar issueInstant = XMLTimeUtil.parse(StaxParserUtil.getAttributeValue((Attribute)issueInstantAttribute));
        return new SAML11AssertionType(id, issueInstant);
    }
}

