/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.handler;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.picketlink.identity.federation.core.util.SOAPUtil;
import org.picketlink.trust.jbossws.Util;
import org.picketlink.trust.jbossws.handler.AbstractPicketLinkTrustHandler;
import org.picketlink.trust.jbossws.handler.BinaryTokenValidation;
import org.picketlink.trust.jbossws.handler.SecurityActions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MapBasedTokenHandler
extends AbstractPicketLinkTrustHandler {
    public static final String SYS_PROP_TOKEN_KEY = "map.token.key";
    public static final String DEFAULT_TOKEN_KEY = "ClientID";
    private boolean trace = logger.isTraceEnabled();
    public final String tokenOptionKey = SecurityActions.getSystemProperty("map.token.key", "ClientID");
    public final String validationTokenClassKey = SecurityActions.getSystemProperty("map.token.validation.class.key", "tokenValidationClass");
    private String encodingType = SecurityActions.getSystemProperty("binary.http.encodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
    private String valueType = SecurityActions.getSystemProperty("binary.http.valueType", null);
    private String valueTypeNamespace = SecurityActions.getSystemProperty("binary.http.valueType.namespace", null);
    private String valueTypePrefix = SecurityActions.getSystemProperty("binary.http.valueType.prefix", null);
    private SOAPFactory factory = null;
    private Map<String, ?> jaasLoginModuleOptions = null;

    public MapBasedTokenHandler(Map<String, ?> jaasOptionsMap) {
        this.jaasLoginModuleOptions = jaasOptionsMap;
    }

    public void setEncodingType(String binaryEncodingType) {
        this.encodingType = binaryEncodingType;
    }

    public void setValueType(String binaryValueType) {
        this.valueType = binaryValueType;
    }

    public void setValueTypeNamespace(String binaryValueNamespace) {
        this.valueTypeNamespace = binaryValueNamespace;
    }

    public void setValueTypePrefix(String binaryValuePrefix) {
        this.valueTypePrefix = binaryValuePrefix;
    }

    @Override
    protected boolean handleInbound(MessageContext msgContext) {
        String tokenValidation;
        if (this.trace) {
            logger.trace("Handling Inbound Message");
        }
        if ((tokenValidation = (String)this.jaasLoginModuleOptions.get(this.validationTokenClassKey)) == null) {
            return true;
        }
        BinaryTokenValidation validation = null;
        try {
            ClassLoader cl = SecurityActions.getClassLoader(this.getClass());
            validation = (BinaryTokenValidation)cl.loadClass(tokenValidation).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("PL00085: Class Not Loaded:Class not loaded:" + tokenValidation, e);
        }
        String token = this.getToken(msgContext);
        if (this.trace) {
            logger.trace("Validating token=" + token);
        }
        return validation.validateBinaryToken(token, msgContext);
    }

    @Override
    protected boolean handleOutbound(MessageContext msgContext) {
        String token;
        if (this.trace) {
            logger.trace("Handling Outbound Message");
        }
        if ((token = (String)this.jaasLoginModuleOptions.get(this.tokenOptionKey)) == null) {
            throw new RuntimeException("PL00077: Injected Value Missing:" + this.tokenOptionKey + " has to be set by calling LoginMoule in option map.");
        }
        SOAPElement security = null;
        try {
            security = this.create(token);
        }
        catch (SOAPException e) {
            logger.jbossWSUnableToCreateBinaryToken((Throwable)e);
        }
        if (security == null) {
            logger.jbossWSUnableToCreateSecurityToken();
            return true;
        }
        SOAPMessage sm = ((SOAPMessageContext)msgContext).getMessage();
        try {
            SOAPEnvelope envelope = sm.getSOAPPart().getEnvelope();
            SOAPHeader header = (SOAPHeader)Util.findElement((Element)envelope, new QName(envelope.getNamespaceURI(), "Header"));
            if (header == null) {
                header = (SOAPHeader)envelope.getOwnerDocument().createElementNS(envelope.getNamespaceURI(), envelope.getPrefix() + ":Header");
                envelope.insertBefore((Node)header, envelope.getFirstChild());
            }
            header.addChildElement(security);
        }
        catch (SOAPException e) {
            logger.jbossWSUnableToCreateBinaryToken((Throwable)e);
        }
        if (this.trace) {
            logger.trace("SOAP Message=" + SOAPUtil.soapMessageAsString((SOAPMessage)sm));
        }
        return true;
    }

    private SOAPElement create(String token) throws SOAPException {
        if (this.factory == null) {
            this.factory = SOAPFactory.newInstance();
        }
        SOAPElement security = this.factory.createElement("Security", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (this.valueTypeNamespace != null) {
            security.addNamespaceDeclaration(this.valueTypePrefix, this.valueTypeNamespace);
        }
        SOAPElement binarySecurityToken = this.factory.createElement("BinarySecurityToken", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        binarySecurityToken.addTextNode(token);
        if (this.valueType != null && !this.valueType.isEmpty()) {
            binarySecurityToken.setAttribute("ValueType", this.valueType);
        }
        if (this.encodingType != null) {
            binarySecurityToken.setAttribute("EncodingType", this.encodingType);
        }
        security.addChildElement(binarySecurityToken);
        return security;
    }

    private String getToken(MessageContext msgContext) {
        SOAPMessage sm = ((SOAPMessageContext)msgContext).getMessage();
        try {
            SOAPEnvelope envelope = sm.getSOAPPart().getEnvelope();
            SOAPHeader header = (SOAPHeader)Util.findElement((Element)envelope, new QName(envelope.getNamespaceURI(), "Header"));
            if (header == null) {
                header = (SOAPHeader)envelope.getOwnerDocument().createElementNS(envelope.getNamespaceURI(), envelope.getPrefix() + ":Header");
            }
            return Util.findElementByWsuId((Element)header, "BinarySecurityToken").getTextContent();
        }
        catch (SOAPException e) {
            logger.jbossWSUnableToCreateBinaryToken((Throwable)e);
            return null;
        }
    }
}

