/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.workflow;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.picketlink.identity.federation.web.util.HTTPRedirectUtil;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;

public class ServiceProviderSAMLWorkflow {
    private RedirectionHandler redirectionHandler = new RedirectionHandler();
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public ServiceProviderSAMLWorkflow setRedirectionHandler(RedirectionHandler theHandler) {
        this.redirectionHandler = theHandler;
        return this;
    }

    public boolean validate(HttpServletRequest request) {
        return request.getParameter("SAMLResponse") != null;
    }

    public boolean isGlobalLogout(HttpServletRequest request) {
        String gloStr = request.getParameter("GLO");
        return StringUtil.isNotNull((String)gloStr) && "true".equalsIgnoreCase(gloStr);
    }

    public boolean isLocalLogoutRequest(HttpServletRequest request) {
        String lloStr = request.getParameter("LLO");
        return StringUtil.isNotNull((String)lloStr) && "true".equalsIgnoreCase(lloStr);
    }

    public void sendToLogoutPage(HttpServletRequest request, HttpServletResponse response, HttpSession session, ServletContext servletContext, String logOutPage) throws IOException, ServletException {
        RequestDispatcher dispatch = servletContext.getRequestDispatcher(logOutPage);
        if (dispatch == null) {
            logger.samlSPCouldNotDispatchToLogoutPage(logOutPage);
        } else {
            logger.trace("Forwarding request to logOutPage: " + logOutPage);
            if (request.getSession(false) != null) {
                session.invalidate();
            }
            try {
                dispatch.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sendRequestToIDP(String destination, Document samlDocument, String relayState, HttpServletResponse response, boolean willSendRequest, String destinationQueryStringWithSignature, boolean httpPostBinding) throws ProcessingException, ConfigurationException, IOException {
        if (httpPostBinding) {
            this.sendHttpPostBindingRequest(destination, samlDocument, relayState, response, willSendRequest);
        } else {
            this.sendHttpRedirectRequest(destination, samlDocument, relayState, response, willSendRequest, destinationQueryStringWithSignature);
        }
    }

    public void sendHttpRedirectRequest(String destination, Document samlDocument, String relayState, HttpServletResponse response, boolean willSendRequest, String destinationQueryStringWithSignature) throws IOException, ProcessingException, ConfigurationException {
        String destinationQueryString = null;
        if (destinationQueryStringWithSignature != null) {
            destinationQueryString = destinationQueryStringWithSignature;
        } else {
            String samlMessage = DocumentUtil.getDocumentAsString((Document)samlDocument);
            String base64Request = RedirectBindingUtil.deflateBase64URLEncode(samlMessage.getBytes("UTF-8"));
            destinationQueryString = RedirectBindingUtil.getDestinationQueryString(base64Request, relayState, willSendRequest);
        }
        RedirectBindingUtil.RedirectBindingUtilDestHolder holder = new RedirectBindingUtil.RedirectBindingUtilDestHolder();
        holder.setDestination(destination).setDestinationQueryString(destinationQueryString);
        this.redirectionHandler.sendRedirectForRequestor(RedirectBindingUtil.getDestinationURL(holder), response);
    }

    public void sendHttpPostBindingRequest(String destination, Document samlDocument, String relayState, HttpServletResponse response, boolean willSendRequest) throws ProcessingException, IOException, ConfigurationException {
        String samlMessage = PostBindingUtil.base64Encode(DocumentUtil.getDocumentAsString((Document)samlDocument));
        DestinationInfoHolder destinationHolder = new DestinationInfoHolder(destination, samlMessage, relayState);
        this.redirectionHandler.sendPost(destinationHolder, response, willSendRequest);
    }

    public static class RedirectionHandler {
        public void sendPost(DestinationInfoHolder destinationHolder, HttpServletResponse response, boolean willSendRequest) throws IOException {
            PostBindingUtil.sendPost(destinationHolder, response, willSendRequest);
        }

        public void sendRedirectForRequestor(String url, HttpServletResponse response) throws IOException {
            HTTPRedirectUtil.sendRedirectForRequestor(url, response);
        }

        public void sendRedirectForResponder(String destination, HttpServletResponse response) throws IOException {
            HTTPRedirectUtil.sendRedirectForResponder(destination, response);
        }
    }
}

