/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.saml.plugin;

import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.integration.SSOUtils;

public class IDPHttpSessionListener
extends Listener<PortalContainer, HttpSessionEvent> {
    private static final Logger log = LoggerFactory.getLogger(IDPHttpSessionListener.class);
    private static final String PROPERTY_IDP_ENABLED = "gatein.sso.idp.listener.enabled";
    private volatile HttpSessionListener delegate;

    public void onEvent(Event<PortalContainer, HttpSessionEvent> event) throws Exception {
        if ("true".equals(SSOUtils.getSystemProperty((String)PROPERTY_IDP_ENABLED, (String)"false"))) {
            HttpSessionEvent se = (HttpSessionEvent)event.getData();
            HttpSessionListener delegate = this.getOrInitDelegate();
            delegate.sessionDestroyed(se);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)"Portal is not acting as SAML2 IDP. Ignore this listener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpSessionListener getOrInitDelegate() {
        if (this.delegate == null) {
            IDPHttpSessionListener iDPHttpSessionListener = this;
            synchronized (iDPHttpSessionListener) {
                if (this.delegate == null) {
                    this.delegate = new org.picketlink.identity.federation.web.listeners.IDPHttpSessionListener();
                }
            }
        }
        return this.delegate;
    }
}

