/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import org.jboss.security.xacml.core.JBossRequestContext;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.jboss.security.xacml.core.model.context.ResponseType;
import org.jboss.security.xacml.core.model.context.ResultType;
import org.jboss.security.xacml.interfaces.PolicyDecisionPoint;
import org.jboss.security.xacml.interfaces.RequestContext;
import org.jboss.security.xacml.interfaces.ResponseContext;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.identity.federation.core.factories.XACMLContextFactory;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.parsers.saml.xacml.SAMLXACMLRequestParser;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.factories.JBossSAMLAuthnResponseFactory;
import org.picketlink.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.util.JAXPValidationUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.profiles.xacml.assertion.XACMLAuthzDecisionStatementType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.XACMLAuthzDecisionQueryType;
import org.w3c.dom.Node;

public class SOAPSAMLXACMLUtil {
    public static XACMLAuthzDecisionQueryType getXACMLQueryType(Node samlRequest) throws ParsingException, ConfigurationException, ProcessingException {
        XMLEventReader xmlEventReader = StaxParserUtil.getXMLEventReader((InputStream)DocumentUtil.getNodeAsStream((Node)samlRequest));
        SAMLXACMLRequestParser samlXACMLRequestParser = new SAMLXACMLRequestParser();
        return (XACMLAuthzDecisionQueryType)samlXACMLRequestParser.parse(xmlEventReader);
    }

    public static XACMLAuthzDecisionStatementType getDecisionStatement(Node samlResponse) throws ConfigurationException, ProcessingException, ParsingException {
        XMLEventReader xmlEventReader = StaxParserUtil.getXMLEventReader((InputStream)DocumentUtil.getNodeAsStream((Node)samlResponse));
        SAMLParser samlParser = new SAMLParser();
        JAXPValidationUtil.checkSchemaValidation(samlResponse);
        org.picketlink.identity.federation.saml.v2.protocol.ResponseType response = (org.picketlink.identity.federation.saml.v2.protocol.ResponseType)samlParser.parse(xmlEventReader);
        List<ResponseType.RTChoiceType> choices = response.getAssertions();
        for (ResponseType.RTChoiceType rst : choices) {
            AssertionType assertion = rst.getAssertion();
            if (assertion == null) continue;
            Set<StatementAbstractType> stats = assertion.getStatements();
            for (StatementAbstractType stat : stats) {
                if (!(stat instanceof XACMLAuthzDecisionStatementType)) continue;
                return (XACMLAuthzDecisionStatementType)stat;
            }
        }
        throw new RuntimeException("Not found XACMLAuthzDecisionStatementType");
    }

    public static synchronized org.picketlink.identity.federation.saml.v2.protocol.ResponseType handleXACMLQuery(PolicyDecisionPoint pdp, String issuer, XACMLAuthzDecisionQueryType xacmlRequest) throws ProcessingException, ConfigurationException {
        RequestType requestType = xacmlRequest.getRequest();
        JBossRequestContext requestContext = new JBossRequestContext();
        try {
            requestContext.setRequest(requestType);
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
        ResponseContext responseContext = pdp.evaluate((RequestContext)requestContext);
        ResponseType responseType = new ResponseType();
        ResultType resultType = responseContext.getResult();
        responseType.getResult().add(resultType);
        XACMLAuthzDecisionStatementType xacmlStatement = XACMLContextFactory.createXACMLAuthzDecisionStatementType(requestType, responseType);
        String ID = IDGenerator.create("ID_");
        IssuerInfoHolder issuerInfo = new IssuerInfoHolder(issuer);
        ArrayList<StatementAbstractType> statements = new ArrayList<StatementAbstractType>();
        statements.add(xacmlStatement);
        AssertionType assertion = SAMLAssertionFactory.createAssertion(ID, issuerInfo.getIssuer(), XMLTimeUtil.getIssueInstant(), null, null, statements);
        org.picketlink.identity.federation.saml.v2.protocol.ResponseType samlResponseType = JBossSAMLAuthnResponseFactory.createResponseType(ID, issuerInfo, assertion);
        return samlResponseType;
    }
}

