/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts.registry;

import java.io.IOException;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.picketlink.identity.federation.core.sts.registry.AbstractJPARegistry;
import org.picketlink.identity.federation.core.sts.registry.SecurityToken;
import org.picketlink.identity.federation.core.sts.registry.SecurityTokenRegistry;

public class JPABasedTokenRegistry
extends AbstractJPARegistry
implements SecurityTokenRegistry {
    public JPABasedTokenRegistry() {
    }

    public JPABasedTokenRegistry(String configuration) {
    }

    @Override
    public void addToken(final String id, final Object token) throws IOException {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void executeInTransaction(EntityManager entityManager) {
                if (entityManager.find(SecurityToken.class, (Object)id) != null) {
                    AbstractJPARegistry.logger.samlSecurityTokenAlreadyPersisted(id);
                } else {
                    SecurityToken securityToken = new SecurityToken(id, token);
                    entityManager.persist((Object)securityToken);
                }
            }
        });
    }

    @Override
    public void removeToken(final String id) throws IOException {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void executeInTransaction(EntityManager entityManager) {
                SecurityToken securityToken = (SecurityToken)entityManager.find(SecurityToken.class, (Object)id);
                if (securityToken == null) {
                    AbstractJPARegistry.logger.samlSecurityTokenNotFoundInRegistry(id);
                } else {
                    entityManager.remove((Object)securityToken);
                }
            }
        });
    }

    @Override
    public Object getToken(String id) {
        SecurityToken token = (SecurityToken)this.getEntityManagerFactory().createEntityManager().find(SecurityToken.class, (Object)id);
        if (token != null) {
            return token.unmarshalToken();
        }
        logger.samlSecurityTokenNotFoundInRegistry(id);
        return null;
    }

    private void executeInTransaction(TransactionCallback callback) {
        EntityManager manager = null;
        EntityTransaction transaction = null;
        try {
            manager = this.getEntityManagerFactory().createEntityManager();
            transaction = manager.getTransaction();
            transaction.begin();
            callback.executeInTransaction(manager);
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw new RuntimeException("Error executing transaction.", e);
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            manager.close();
        }
    }

    private static interface TransactionCallback {
        public void executeInTransaction(EntityManager var1);
    }
}

