/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.factories;

import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.factories.SecurityActions;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;

public class SAML2HandlerChainFactory {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static SAML2HandlerChain createChain() {
        return new DefaultSAML2HandlerChain();
    }

    public static SAML2HandlerChain createChain(String fqn) throws ProcessingException {
        if (fqn == null) {
            throw logger.nullArgumentError("fqn");
        }
        Class<?> clazz = SecurityActions.loadClass(SAML2HandlerChainFactory.class, fqn);
        if (clazz == null) {
            throw logger.classNotLoadedError(fqn);
        }
        try {
            return (SAML2HandlerChain)clazz.newInstance();
        }
        catch (Exception e) {
            throw logger.couldNotCreateInstance(fqn, (Throwable)e);
        }
    }
}

