/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.SPType;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.web.core.HTTPContext;

public abstract class BaseSAML2Handler
implements SAML2Handler {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected SAML2HandlerConfig handlerConfig = null;
    protected SAML2HandlerChainConfig handlerChainConfig = null;
    private ProviderType providerConfig;

    @Override
    public void initHandlerConfig(SAML2HandlerConfig handlerConfig) throws ConfigurationException {
        this.handlerConfig = handlerConfig;
    }

    @Override
    public void initChainConfig(SAML2HandlerChainConfig handlerChainConfig) throws ConfigurationException {
        this.handlerChainConfig = handlerChainConfig;
        this.providerConfig = (ProviderType)this.handlerChainConfig.getParameter("CONFIGURATION");
        if (!this.isSupportedProviderType(this.providerConfig)) {
            throw logger.unsupportedType(this.providerConfig.getClass().getName());
        }
    }

    @Override
    public SAML2Handler.HANDLER_TYPE getType() {
        if (this.providerConfig instanceof IDPType) {
            return SAML2Handler.HANDLER_TYPE.IDP;
        }
        return SAML2Handler.HANDLER_TYPE.SP;
    }

    @Override
    public void reset() throws ProcessingException {
    }

    @Override
    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
    }

    @Override
    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
    }

    public static HttpServletRequest getHttpRequest(SAML2HandlerRequest request) {
        HTTPContext context = (HTTPContext)request.getContext();
        return context.getRequest();
    }

    public static HttpSession getHttpSession(SAML2HandlerRequest request) {
        HTTPContext context = (HTTPContext)request.getContext();
        return context.getRequest().getSession(false);
    }

    protected ProviderType getProviderconfig() {
        return this.providerConfig;
    }

    protected void checkDestination(String destination, String expectedDestination) throws ProcessingException {
        if (expectedDestination == null) {
            throw logger.nullArgumentError("Expected destination.");
        }
        if (destination != null && !destination.startsWith(expectedDestination)) {
            throw new ProcessingException("Invalid destination [" + destination + "]. Expected [" + expectedDestination + "].");
        }
    }

    protected void checkDestination(URI destination, String expectedDestination) throws ProcessingException {
        if (destination != null) {
            this.checkDestination(destination.toString(), expectedDestination);
        }
    }

    private boolean isSupportedProviderType(ProviderType providerType) {
        if (providerType == null) {
            throw logger.nullArgumentError("ProviderType configuration.");
        }
        return providerType instanceof IDPType || providerType instanceof SPType;
    }
}

