/*
 * JBoss, Home of Professional Open Source
 *
 * Copyright 2013 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.picketlink.identity.federation.saml.common;

import javax.xml.datatype.XMLGregorianCalendar;
import java.io.Serializable;

/**
 * SAML AssertionType
 *
 * @author Anil.Saldhana@redhat.com
 * @since Jun 21, 2011
 */
public class CommonAssertionType implements Serializable {

    private static final long serialVersionUID = 1L;

    protected XMLGregorianCalendar issueInstant;

    protected String ID;

    public CommonAssertionType(String iD, XMLGregorianCalendar issueInstant) {
        if (iD == null)
            throw new IllegalArgumentException("iD is null");
        if (issueInstant == null)
            throw new IllegalArgumentException("issueInstant is null");

        this.issueInstant = issueInstant;
        ID = iD;
    }

    public XMLGregorianCalendar getIssueInstant() {
        return issueInstant;
    }

    public String getID() {
        return ID;
    }
}