/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.injector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.injector.TaskInjector$AjcClosure1;
import org.exoplatform.task.injector.TaskInjector$AjcClosure3;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;

public class TaskInjector
extends DataInjector {
    private static final Log LOG;
    private static final String NUMBER_PROJECTS = "nbProject";
    private static final int DEFAULT_NUMBER_PROJECTS = 15;
    private static final String NUMBER_TASKS = "nbTaskPerProject";
    private static final int DEFAULT_NUMBER_TASKS = 42;
    private static final String NUMBER_INCOMING_TASKS = "nbIncomingTask";
    private static final int DEFAULT_NUMBER_INCOMING_TASKS = 10;
    private static final String NUMBER_COMMENTS = "nbComPerTask";
    private static final int DEFAULT_NUMBER_COMMENTS = 2;
    private static final String PERCENTAGE_COMPLETED = "perCompleted";
    private static final int DEFAULT_PERCENTAGE_COMPLETED = 70;
    private static final String TASK_TYPE = "type";
    private static final String USER_TASK_TYPE = "user";
    private static final String SPACE_TASK_TYPE = "space";
    private static final String DEFAULT_TASK_TYPE = "user";
    private static final String NAME_PREFIX = "prefix";
    private static final String DEFAULT_USER_PREFIX = "bench.user";
    private static final String DEFAULT_SPACE_PREFIX = "bench.space";
    private static final String TASK_PREFIX = "taskPrefix";
    private static final String DEFAULT_TASK_PREFIX = "Task";
    private static final String PROJECT_PREFIX = "projectPrefix";
    private static final String DEFAULT_PROJECT_PREFIX = "Project";
    private static final String NAME_SUFFIX = "suffix";
    private static final int DEFAULT_SUFFIX = 4;
    private static final String USER_FROM = "from";
    private static final int DEFAULT_USER_FROM = 0;
    private static final String USER_TO = "to";
    private static final int DEFAULT_USER_TO = 10;
    private final TaskService taskService;
    private final ProjectService projectService;
    private final StatusService statusService;
    private List<String> statusName = Arrays.asList("To Do", "On Going", "Done");
    private Random random = new Random();
    private int nbProject;
    private int nbTasks;
    private int nbIncomingTasks;
    private int nbComments;
    private int perCompleted;
    private String taskType;
    private String namePrefix;
    private int nameSuffix;
    private String suffixPattern;
    private String taskPrefix;
    private String projectPrefix;
    private int userFrom;
    private int userTo;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public TaskInjector() {
        PortalContainer container = PortalContainer.getInstance();
        this.taskService = (TaskService)container.getComponentInstanceOfType(TaskService.class);
        this.projectService = (ProjectService)container.getComponentInstanceOfType(ProjectService.class);
        this.statusService = (StatusService)container.getComponentInstanceOfType(StatusService.class);
    }

    private void init() {
        this.suffixPattern = "%s%0" + this.nameSuffix + "d";
    }

    private void initParam(HashMap<String, String> params) {
        this.nbProject = this.getIntegerParam(params, NUMBER_PROJECTS, 15);
        this.nbTasks = this.getIntegerParam(params, NUMBER_TASKS, 42);
        this.nbComments = this.getIntegerParam(params, NUMBER_COMMENTS, 2);
        this.perCompleted = this.getIntegerParam(params, PERCENTAGE_COMPLETED, 70);
        this.nbIncomingTasks = this.getIntegerParam(params, NUMBER_INCOMING_TASKS, 10);
        this.taskType = this.getStringParam(params, TASK_TYPE, "user");
        if (!"user".equals(this.taskType) && !SPACE_TASK_TYPE.equals(this.taskType)) {
            LOG.warn((Object)("type parameter [" + this.taskType + "] is invalid, the default one will be used." + TASK_TYPE + " parameter must be equal to " + "user" + " (default) or " + SPACE_TASK_TYPE));
            this.taskType = "user";
        }
        this.namePrefix = "user".equals(this.taskType) ? this.getStringParam(params, NAME_PREFIX, DEFAULT_USER_PREFIX) : this.getStringParam(params, NAME_PREFIX, DEFAULT_SPACE_PREFIX);
        this.nameSuffix = this.getIntegerParam(params, NAME_SUFFIX, 4);
        this.taskPrefix = this.getStringParam(params, TASK_PREFIX, DEFAULT_TASK_PREFIX);
        this.projectPrefix = this.getStringParam(params, PROJECT_PREFIX, DEFAULT_PROJECT_PREFIX);
        this.userFrom = this.getIntegerParam(params, USER_FROM, 0);
        this.userTo = this.getIntegerParam(params, USER_TO, 10);
    }

    public void inject(HashMap<String, String> hashMap) throws Exception {
        LOG.info((Object)"Start Inject Data for Task...");
        this.initParam(hashMap);
        this.init();
        if ("user".equals(this.taskType)) {
            this.addPersonalTasks();
        } else {
            this.addSpaceTasks();
        }
        LOG.info((Object)"... Finish Inject Data for Task");
    }

    public void reject(HashMap<String, String> hashMap) throws Exception {
    }

    public Log getLog() {
        return LOG;
    }

    public Object execute(HashMap<String, String> hashMap) throws Exception {
        return null;
    }

    private void addPersonalTasks() {
        LOG.info((Object)("Adding " + this.nbProject + " personal projects with " + this.nbTasks + " tasks for " + (this.userTo - this.userFrom) + " user(s)"));
        for (int i = this.userFrom; i < this.userTo; ++i) {
            this.addPersonalTasksByUser(i);
        }
    }

    @ExoTransactional
    private void addPersonalTasksByUser(int userNb) {
        int n = userNb;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskInjector$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private void addSpaceTasks() {
        LOG.info((Object)("Adding " + this.nbProject + " space projects with " + this.nbTasks + " tasks for " + (this.userTo - this.userFrom) + " space(s)"));
        for (int i = this.userFrom; i < this.userTo; ++i) {
            this.addSpaceTasksByUser(i);
        }
    }

    @ExoTransactional
    private void addSpaceTasksByUser(int userNb) {
        int n = userNb;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskInjector$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    private Task createTask(Status status, String username, String project, int numtask, boolean isRandomCompleted) {
        Task task = new Task();
        task.setTitle(this.taskPrefix + "-" + numtask);
        task.setDescription(this.randomWords(20));
        task.setCreatedBy(username);
        task.setAssignee(username);
        task.setCreatedTime(new Date());
        if (isRandomCompleted && this.random.nextInt(100) < this.perCompleted) {
            task.setCompleted(true);
        }
        if (status != null) {
            task.setStatus(status);
        }
        task = this.taskService.createTask(task);
        this.createComments(task, username, this.nbComments);
        return task;
    }

    private Set<Comment> createComments(Task task, String username, int nbComments) {
        HashSet<Comment> comments = new HashSet<Comment>();
        for (int i = 0; i < nbComments; ++i) {
            try {
                Comment comment = this.taskService.addComment(task.getId(), username, this.randomWords(20));
                comments.add(comment);
                continue;
            }
            catch (EntityNotFoundException ex) {
                throw new IllegalArgumentException("Task with id: " + task.getId() + " is not found in database");
            }
        }
        return comments;
    }

    private Project createProject(String username, int numProject) {
        Project project = new Project();
        project.setName(this.projectPrefix + "-" + username + "-" + numProject);
        project.setDescription(this.randomWords(20));
        HashSet<String> managers = new HashSet<String>();
        managers.add(username);
        project.setManager(managers);
        return project;
    }

    private List<Status> createStatus(Project project) {
        ArrayList<Status> statusList = new ArrayList<Status>();
        for (String name : this.statusName) {
            Status status = this.statusService.createStatus(project, name);
            statusList.add(status);
        }
        return statusList;
    }

    private String getUsername(int userNumber) {
        return String.format(this.suffixPattern, this.namePrefix, userNumber);
    }

    private String getSpaceName(int spaceNumber) {
        return String.format(this.suffixPattern, this.namePrefix.replace(".", ""), spaceNumber);
    }

    private int getIntegerParam(HashMap<String, String> params, String name, int defaultNb) {
        if (params == null) {
            return defaultNb;
        }
        if (name == null) {
            return defaultNb;
        }
        try {
            String value = params.get(name);
            if (value != null) {
                return Integer.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Integer number expected for property " + name + " ! Default value will be use instead"));
        }
        return defaultNb;
    }

    protected String getStringParam(HashMap<String, String> params, String name, String defaultParam) {
        if (params == null) {
            return defaultParam;
        }
        if (name == null) {
            return defaultParam;
        }
        String value = params.get(name);
        if (value != null) {
            return value;
        }
        return defaultParam;
    }

    static {
        TaskInjector.ajc$preClinit();
        LOG = ExoLogger.getLogger(TaskInjector.class);
    }

    static /* synthetic */ void addPersonalTasksByUser_aroundBody0(TaskInjector ajc$this, int userNb, JoinPoint joinPoint) {
        int j;
        String userName = ajc$this.getUsername(userNb);
        LOG.info((Object)("Add personnal tasks to user: " + userName));
        for (j = 0; j < ajc$this.nbProject; ++j) {
            Project project = ajc$this.createProject(userName, j);
            project = ajc$this.projectService.createProject(project);
            List<Status> statuses = ajc$this.createStatus(project);
            for (int k = 0; k < ajc$this.nbTasks; ++k) {
                ajc$this.createTask(statuses.get(ajc$this.random.nextInt(3)), userName, project.getName(), k, true);
            }
        }
        for (j = 0; j < ajc$this.nbIncomingTasks; ++j) {
            ajc$this.createTask(null, userName, "Incoming-" + userName, j, false);
        }
    }

    static /* synthetic */ void addSpaceTasksByUser_aroundBody2(TaskInjector ajc$this, int userNb, JoinPoint joinPoint) {
        String spaceName = ajc$this.getSpaceName(userNb);
        String manager = "manager:/spaces/" + spaceName;
        String member = "member:/spaces/" + spaceName;
        LOG.info((Object)("Add tasks to space: " + spaceName));
        for (int j = 0; j < ajc$this.nbProject; ++j) {
            Project project = ajc$this.createProject(manager, j);
            HashSet<String> members = new HashSet<String>();
            members.add(member);
            project.setParticipator(members);
            project = ajc$this.projectService.createProject(project);
            List<Status> statuses = ajc$this.createStatus(project);
            for (int k = 0; k < ajc$this.nbTasks; ++k) {
                ajc$this.createTask(statuses.get(ajc$this.random.nextInt(3)), manager, project.getName(), k, true);
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskInjector.java", TaskInjector.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addPersonalTasksByUser", "org.exoplatform.task.injector.TaskInjector", "int", "userNb", "", "void"), 196);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addSpaceTasksByUser", "org.exoplatform.task.injector.TaskInjector", "int", "userNb", "", "void"), 237);
    }
}

