/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.util.List;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.integration.ActivityTaskProcessor;
import org.exoplatform.task.service.ParserContext;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskParser;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.StringUtil;

public class ActivityTaskCreationListener
extends ActivityListenerPlugin {
    private TaskService taskService;
    private ProjectService projectService;
    private StatusService statusService;
    private TaskParser parser;
    private final IdentityManager identityManager;
    private final ActivityManager activityManager;
    private final SpaceService spaceService;
    private UserService userService;
    public static final String PREFIX = "++";

    public ActivityTaskCreationListener(TaskService taskServ, ProjectService projectService, StatusService statusService, TaskParser parser, IdentityManager identityManager, ActivityManager activityManager, SpaceService spaceService, UserService userService) {
        this.taskService = taskServ;
        this.projectService = projectService;
        this.statusService = statusService;
        this.parser = parser;
        this.identityManager = identityManager;
        this.activityManager = activityManager;
        this.spaceService = spaceService;
        this.userService = userService;
    }

    public void saveActivity(ActivityLifeCycleEvent event) {
        this.createTask(event, false);
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        this.createTask(event, true);
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
    }

    private void createTask(ActivityLifeCycleEvent event, boolean isComment) {
        int idx;
        ExoSocialActivity activity = event.getActivity();
        ExoSocialActivity rootActivity = isComment ? this.activityManager.getActivity(activity.getParentId()) : activity;
        Identity identity = this.identityManager.getIdentity(activity.getPosterId(), false);
        ParserContext context = new ParserContext(this.userService.getUserTimezone(identity.getRemoteId()));
        String comment = activity.getTitle();
        if (comment != null && !comment.isEmpty() && (idx = comment.indexOf(PREFIX)) >= 0 && idx + 2 < comment.length() - 1) {
            String spaceName;
            Space space;
            List projects;
            String description;
            String title;
            comment = ActivityTaskProcessor.decode(comment);
            String text = comment.substring(idx + 2);
            int index = (text = text.replaceFirst("<br(\\s*\\/?)>", "\n")).indexOf("\n");
            if (index > 1) {
                title = text.substring(0, index);
                description = text.substring(index).trim();
            } else {
                title = text.trim();
                description = "";
            }
            Task task = this.parser.parse(title, context);
            task.setDescription(StringUtil.encodeInjectedHtmlTag((String)description));
            task.setContext(LinkProvider.getSingleActivityUrl((String)activity.getId()));
            task.setCreatedBy(identity.getRemoteId());
            task.setActivityId(activity.getId());
            if (rootActivity.getActivityStream().getType() == ActivityStream.Type.SPACE && (projects = ProjectUtil.getProjectTree((String)(space = this.spaceService.getSpaceByPrettyName(spaceName = rootActivity.getActivityStream().getPrettyId())).getGroupId(), (ProjectService)this.projectService)) != null && projects.size() > 0) {
                task.setStatus(this.statusService.getDefaultStatus(((Project)projects.get(0)).getId()));
            }
            this.taskService.createTask(task);
            activity.setTitle(comment);
            this.activityManager.updateActivity(activity);
        }
    }
}

