/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.UserSetting;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.NotAllowedOperationOnEntityException;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.service.impl.UserServiceImpl$AjcClosure1;
import org.exoplatform.task.service.impl.UserServiceImpl$AjcClosure3;
import org.exoplatform.task.service.impl.UserServiceImpl$AjcClosure5;
import org.exoplatform.task.service.impl.UserServiceImpl$AjcClosure7;

@Singleton
public class UserServiceImpl
implements UserService {
    private static final org.exoplatform.task.model.User GUEST;
    private static final org.exoplatform.task.model.User NULL;
    private static final Log LOG;
    @Inject
    private OrganizationService orgService;
    @Inject
    private IdentityManager identityManager;
    @Inject
    private DAOHandler daoHandler;
    private CalendarService calService;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public UserServiceImpl(OrganizationService orgService, CalendarService calService, IdentityManager idMgr, DAOHandler handler) {
        this.orgService = orgService;
        this.identityManager = idMgr;
        this.daoHandler = handler;
        this.calService = calService;
    }

    @Override
    public org.exoplatform.task.model.User loadUser(String username) {
        if (username == null) {
            return GUEST;
        }
        try {
            User u = this.orgService.getUserHandler().findUserByName(username);
            if (u == null) {
                return GUEST;
            }
            Profile profile = this.identityManager.getOrCreateIdentity("organization", username, false).getProfile();
            String avatarURL = profile.getAvatarUrl();
            if (avatarURL == null) {
                avatarURL = "/eXoSkin/skin/images/system/UserAvtDefault.png";
            }
            return new org.exoplatform.task.model.User(username, u.getEmail(), u.getFirstName(), u.getLastName(), profile.getFullName(), avatarURL, profile.getUrl());
        }
        catch (Exception ex) {
            LOG.debug((Object)"User not find, return GUEST", (Throwable)ex);
            return GUEST;
        }
    }

    @Override
    @ExoTransactional
    public UserSetting getUserSetting(String username) {
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (UserSetting)ExoTransactionalAspect.aspectOf().around(new UserServiceImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void hideProject(Identity identity, Long projectId, boolean hide) throws EntityNotFoundException, NotAllowedOperationOnEntityException {
        Identity identity2 = identity;
        Long l = projectId;
        boolean bl = hide;
        Object[] objectArray = new Object[]{identity2, l, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity2, l, Conversions.booleanObject((boolean)bl), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new UserServiceImpl$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void showHiddenProject(String username, boolean show) {
        String string = username;
        boolean bl = show;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, string, Conversions.booleanObject((boolean)bl), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new UserServiceImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void showHiddenLabel(String username, boolean show) {
        String string = username;
        boolean bl = show;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, string, Conversions.booleanObject((boolean)bl), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new UserServiceImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public TimeZone getUserTimezone(String username) {
        try {
            CalendarSetting setting = this.calService.getCalendarSetting(username);
            return TimeZone.getTimeZone(setting.getTimeZone());
        }
        catch (Exception e) {
            LOG.error((Object)"Can't retrieve timezone", (Throwable)e);
            return null;
        }
    }

    static {
        UserServiceImpl.ajc$preClinit();
        GUEST = new org.exoplatform.task.model.User("guest", null, "", "", "Guest", "/eXoSkin/skin/images/system/UserAvtDefault.png", "#");
        NULL = new org.exoplatform.task.model.User(null, null, "", "", "Guest", "/eXoSkin/skin/images/system/UserAvtDefault.png", "#");
        LOG = ExoLogger.getExoLogger(UserServiceImpl.class);
    }

    static /* synthetic */ UserSetting getUserSetting_aroundBody0(UserServiceImpl ajc$this, String username, JoinPoint joinPoint) {
        return ajc$this.daoHandler.getUserSettingHandler().getOrCreate(username);
    }

    static /* synthetic */ void hideProject_aroundBody2(UserServiceImpl ajc$this, Identity identity, Long projectId, boolean hide, JoinPoint joinPoint) {
        Project project = (Project)ajc$this.daoHandler.getProjectHandler().find(projectId);
        if (project == null) {
            throw new EntityNotFoundException((long)projectId, (Class<?>)Project.class);
        }
        if (!project.canView(identity)) {
            throw new NotAllowedOperationOnEntityException(projectId, Project.class, "hide");
        }
        UserSetting setting = ajc$this.daoHandler.getUserSettingHandler().getOrCreate(identity.getUserId());
        if (hide) {
            setting.getHiddenProjects().add(project);
        } else {
            setting.getHiddenProjects().remove(project);
        }
        ajc$this.daoHandler.getUserSettingHandler().update(setting);
    }

    static /* synthetic */ void showHiddenProject_aroundBody4(UserServiceImpl ajc$this, String username, boolean show, JoinPoint joinPoint) {
        UserSetting setting = ajc$this.daoHandler.getUserSettingHandler().getOrCreate(username);
        setting.setShowHiddenProject(show);
        ajc$this.daoHandler.getUserSettingHandler().update(setting);
    }

    static /* synthetic */ void showHiddenLabel_aroundBody6(UserServiceImpl ajc$this, String username, boolean show, JoinPoint joinPoint) {
        UserSetting setting = ajc$this.daoHandler.getUserSettingHandler().getOrCreate(username);
        setting.setShowHiddenLabel(show);
        ajc$this.daoHandler.getUserSettingHandler().update(setting);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserServiceImpl.java", UserServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserSetting", "org.exoplatform.task.service.impl.UserServiceImpl", "java.lang.String", "username", "", "org.exoplatform.task.domain.UserSetting"), 102);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hideProject", "org.exoplatform.task.service.impl.UserServiceImpl", "org.exoplatform.services.security.Identity:java.lang.Long:boolean", "identity:projectId:hide", "org.exoplatform.task.exception.EntityNotFoundException:org.exoplatform.task.exception.NotAllowedOperationOnEntityException", "void"), 108);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "showHiddenProject", "org.exoplatform.task.service.impl.UserServiceImpl", "java.lang.String:boolean", "username:show", "", "void"), 130);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "showHiddenLabel", "org.exoplatform.task.service.impl.UserServiceImpl", "java.lang.String:boolean", "username:show", "", "void"), 138);
    }
}

