/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.ProjectQuery;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.ParameterEntityException;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.util.ResourceUtil;
import org.exoplatform.task.util.UserUtil;
import org.exoplatform.web.controller.router.Router;

public final class ProjectUtil {
    private static final Log LOG = ExoLogger.getExoLogger(ProjectUtil.class);
    public static final String URL_PROJECT_DETAIL = "/projectDetail/";
    public static final int INCOMING_PROJECT_ID = -1;
    public static final int TODO_PROJECT_ID = -2;
    public static final int LABEL_PROJECT_ID = -5;
    public static final String NAME = "name";
    public static final String DUE_DATE = "dueDate";

    private ProjectUtil() {
    }

    public static List<Project> getProjectTree(String space_group_id, ProjectService projectService) {
        LinkedList<String> memberships = new LinkedList<String>();
        ConversationState state = ConversationState.getCurrent();
        Identity identity = state.getIdentity();
        if (space_group_id == null) {
            memberships.addAll(UserUtil.getMemberships(identity));
        } else {
            memberships.addAll(UserUtil.getSpaceMemberships(space_group_id));
        }
        ProjectQuery manQ = new ProjectQuery();
        manQ.setManager(memberships);
        ListAccess<Project> editPrj = projectService.findProjects(manQ);
        ProjectQuery parQ = new ProjectQuery();
        parQ.setParticipator(memberships);
        ListAccess<Project> viewPrj = projectService.findProjects(parQ);
        HashSet<Project> tmp = new HashSet<Project>();
        try {
            tmp.addAll(ProjectUtil.buildProxy(Arrays.asList(editPrj.load(0, -1)), identity, true));
            tmp.addAll(ProjectUtil.buildProxy(Arrays.asList(viewPrj.load(0, -1)), identity, false));
        }
        catch (Exception ex) {
            LOG.error((Object)"Can't load project list", (Throwable)ex);
        }
        return ProjectUtil.buildRootProjects(new LinkedList<Project>(tmp));
    }

    private static Collection<? extends Project> buildProxy(List<Project> projects, Identity user, boolean editable) {
        LinkedList<ProjectProxy> tmp = new LinkedList<ProjectProxy>();
        for (Project p : projects) {
            tmp.add(new ProjectProxy(p, user, editable));
        }
        return tmp;
    }

    public static List<Project> buildRootProjects(List<Project> projects) {
        if (projects == null) {
            return projects;
        }
        HashMap<Long, Project> maps = new HashMap<Long, Project>();
        LinkedHashSet<Project> rootPRJs = new LinkedHashSet<Project>();
        block0: for (Project p : projects) {
            while (true) {
                Project parent;
                if (!maps.containsKey(p.getId())) {
                    maps.put(p.getId(), p);
                }
                if ((parent = p.getParent()) == null) {
                    rootPRJs.add(p);
                    continue block0;
                }
                if (maps.containsKey(parent.getId())) {
                    parent = (Project)maps.get(parent.getId());
                }
                if (!parent.getChildren().contains(p)) {
                    parent.getChildren().add(p);
                }
                p = parent;
            }
        }
        return new LinkedList<Project>(rootPRJs);
    }

    public static List<Project> flattenTree(List<Project> projectTree, ProjectService projectService) {
        if (projectTree == null) {
            return null;
        }
        HashSet<Project> projects = new HashSet<Project>();
        for (Project p : projectTree) {
            projects.add(p);
            ListAccess<Project> tmp = projectService.getSubProjects(p.getId());
            List<Object> children = new LinkedList();
            try {
                children = Arrays.asList(tmp.load(0, -1));
            }
            catch (Exception ex) {
                LOG.error((Object)"Can't load project list", (Throwable)ex);
            }
            if (children == null || children.isEmpty()) continue;
            projects.addAll(ProjectUtil.flattenTree(children, projectService));
        }
        return new ArrayList<Project>(projects);
    }

    public static String buildBreadcumbs(Long id, ProjectService projectService, ResourceBundle bundle) {
        StringBuilder el;
        Project project = null;
        if (id > 0L) {
            try {
                project = projectService.getProject(id);
            }
            catch (EntityNotFoundException e) {
                LOG.warn("project {} not found", new Object[]{id});
            }
        }
        HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
        StringBuilder builder = new StringBuilder();
        if (project != null) {
            for (Project tmp = project; tmp != null; tmp = tmp.getParent()) {
                el = new StringBuilder();
                if (builder.length() == 0) {
                    el.append("<li class=\"active\">").append(encoder.encode(tmp.getName())).append("</li>");
                } else {
                    el.append("<li>").append("<a class=\"Selected\" title=\"\" data-placement=\"bottom\" rel=\"tooltip\" href=\"#\" data-original-title=\"").append(encoder.encode(tmp.getName())).append("\">").append(encoder.encode(tmp.getName())).append("</a>").append("<span class=\"uiIconMiniArrowRight\"></span>").append("</li>");
                }
                builder.insert(0, el.toString());
            }
        }
        String label = bundle.getString("label.projects");
        el = new StringBuilder();
        if (builder.length() == 0) {
            el.append("<li class=\"active\">").append(label).append("</li>");
        } else {
            el.append("<li>").append("<a class=\"Selected\" title=\"\" data-placement=\"bottom\" rel=\"tooltip\" href=\"#\" data-original-title=\"").append(label).append("\">").append(label).append("</a>").append("<span class=\"uiIconMiniArrowRight\"></span>").append("</li>");
        }
        builder.insert(0, el.toString());
        return builder.toString();
    }

    public static String buildProjectURL(Project project, SiteKey siteKey, ExoContainer container, Router router) {
        StringBuilder urlBuilder;
        long projectId = -2L;
        if (project != null) {
            projectId = project.getId();
        }
        if ((urlBuilder = new StringBuilder(ResourceUtil.buildBaseURL(siteKey, container, router))).length() <= 1) {
            return urlBuilder.toString();
        }
        return urlBuilder.append(URL_PROJECT_DETAIL).append(projectId).toString();
    }

    public static long getProjectIdFromURI(String requestPath) {
        long projectId = -1L;
        int index = requestPath.indexOf(URL_PROJECT_DETAIL);
        if (index >= 0) {
            int lastIndex = requestPath.indexOf(47, index += URL_PROJECT_DETAIL.length());
            String id = lastIndex > 0 ? requestPath.substring(index, lastIndex) : requestPath.substring(index);
            try {
                projectId = Long.parseLong(id);
            }
            catch (NumberFormatException ex) {
                projectId = -100L;
            }
        }
        return projectId;
    }

    public static Project newProjectInstance(String name, String description, String username) {
        HashSet<String> managers = new HashSet<String>();
        managers.add(username);
        return ProjectUtil.newProjectInstance(name, description, managers, Collections.<String>emptySet());
    }

    public static Project newProjectInstance(String name, String description, Set<String> managers, Set<String> participators) {
        Project p = new Project(name, description, new HashSet<Status>(), managers, participators);
        return p;
    }

    public static Project saveProjectField(ProjectService projService, long projectId, Map<String, String[]> fields) throws EntityNotFoundException, ParameterEntityException {
        Project project = projService.getProject(projectId);
        project.setManager(projService.getManager(projectId));
        project.setParticipator(projService.getParticipator(projectId));
        for (Map.Entry<String, String[]> field : fields.entrySet()) {
            String val;
            String fieldName = field.getKey();
            String[] values = field.getValue();
            String string = val = values != null && values.length > 0 ? values[0] : null;
            if (NAME.equalsIgnoreCase(fieldName)) {
                if (val == null || val.isEmpty()) {
                    LOG.info((Object)"Name of project must not empty");
                    throw new ParameterEntityException(projectId, Project.class, fieldName, val, "must not be empty", null);
                }
                project.setName(val);
                continue;
            }
            if ("manager".equalsIgnoreCase(fieldName)) {
                HashSet<String> manager = new HashSet<String>();
                if (values != null) {
                    for (String v : values) {
                        manager.add(v);
                    }
                }
                project.setManager(manager);
                continue;
            }
            if ("participator".equalsIgnoreCase(fieldName)) {
                HashSet<String> participator = new HashSet<String>();
                if (values != null) {
                    for (String v : values) {
                        participator.add(v);
                    }
                }
                project.setParticipator(participator);
                continue;
            }
            if (DUE_DATE.equalsIgnoreCase(fieldName)) {
                if (val == null || val.isEmpty()) {
                    project.setDueDate(null);
                    continue;
                }
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date date = df.parse(val);
                    project.setDueDate(date);
                    continue;
                }
                catch (ParseException e) {
                    LOG.info((Object)("can not parse date string: " + val));
                    throw new ParameterEntityException(projectId, Project.class, fieldName, val, "cannot be parse to date", e);
                }
            }
            if ("description".equalsIgnoreCase(fieldName)) {
                project.setDescription(val);
                continue;
            }
            if ("color".equalsIgnoreCase(fieldName)) {
                project.setColor(val);
                continue;
            }
            if ("calendarIntegrated".equalsIgnoreCase(fieldName)) {
                project.setCalendarIntegrated(Boolean.parseBoolean(val));
                continue;
            }
            if ("parent".equalsIgnoreCase(fieldName)) {
                try {
                    long pId = Long.parseLong(val);
                    if (pId == 0L) {
                        project.setParent(null);
                        continue;
                    }
                    if (pId == project.getId()) {
                        throw new ParameterEntityException(pId, Project.class, fieldName, val, "project can not be child of itself", null);
                    }
                    Project parent = projService.getProject(pId);
                    project.setParent(parent);
                    continue;
                }
                catch (NumberFormatException ex) {
                    LOG.info((Object)("can not parse date string: " + val));
                    throw new ParameterEntityException(projectId, Project.class, fieldName, val, "cannot be parse to Long", ex);
                }
            }
            LOG.info((Object)("Field name: " + fieldName + " is not supported for entity Project"));
            throw new ParameterEntityException(projectId, Project.class, fieldName, val, "is not supported for the entity Project", null);
        }
        return project;
    }

    public static Set<String> getParticipator(long projectId) {
        ProjectService service = ProjectUtil.getProjectService();
        return service.getParticipator(projectId);
    }

    public static Set<String> getManager(long projectId) {
        ProjectService service = ProjectUtil.getProjectService();
        return service.getManager(projectId);
    }

    private static ProjectService getProjectService() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return (ProjectService)container.getComponentInstanceOfType(ProjectService.class);
    }

    private static class ProjectProxy
    extends Project {
        private Project project;
        private boolean editable;
        private Identity identity;

        public ProjectProxy(Project project, Identity identity, boolean editable) {
            this.project = project;
            this.editable = editable;
            this.identity = identity;
        }

        @Override
        public long getId() {
            return this.project.getId();
        }

        @Override
        public void setId(long id) {
            this.project.setId(id);
        }

        @Override
        public String getName() {
            return this.project.getName();
        }

        @Override
        public void setName(String name) {
            this.project.setName(name);
        }

        @Override
        public Set<Status> getStatus() {
            return this.project.getStatus();
        }

        @Override
        public void setStatus(Set<Status> status) {
            this.project.setStatus(status);
        }

        @Override
        public Set<String> getParticipator() {
            return this.project.getParticipator();
        }

        @Override
        public void setParticipator(Set<String> participator) {
            this.project.setParticipator(participator);
        }

        @Override
        public Set<String> getManager() {
            return this.project.getManager();
        }

        @Override
        public void setManager(Set<String> manager) {
            this.project.setManager(manager);
        }

        @Override
        public String getDescription() {
            return this.project.getDescription();
        }

        @Override
        public void setDescription(String description) {
            this.project.setDescription(description);
        }

        @Override
        public Date getDueDate() {
            return this.project.getDueDate();
        }

        @Override
        public void setDueDate(Date dueDate) {
            this.project.setDueDate(dueDate);
        }

        @Override
        public String getColor() {
            return this.project.getColor();
        }

        @Override
        public void setColor(String color) {
            this.project.setColor(color);
        }

        @Override
        public boolean isCalendarIntegrated() {
            return this.project.isCalendarIntegrated();
        }

        @Override
        public void setCalendarIntegrated(boolean calendarIntegrated) {
            this.project.setCalendarIntegrated(calendarIntegrated);
        }

        @Override
        public Project getParent() {
            return this.project.getParent();
        }

        @Override
        public void setParent(Project parent) {
            this.project.setParent(parent);
        }

        @Override
        public List<Project> getChildren() {
            return this.project.getChildren();
        }

        @Override
        public void setChildren(List<Project> children) {
            this.project.setChildren(children);
        }

        @Override
        public Project clone(boolean cloneTask) {
            return this.project.clone(cloneTask);
        }

        @Override
        public boolean canView(Identity user) {
            if (user != null && user.getUserId().equals(this.identity.getUserId())) {
                return true;
            }
            return this.project.canView(user);
        }

        @Override
        public boolean canEdit(Identity user) {
            if (user != null && user.getUserId().equals(this.identity.getUserId())) {
                return this.editable;
            }
            return this.project.canEdit(user);
        }

        @Override
        public int hashCode() {
            return this.project.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this.project.equals(obj);
        }

        public String toString() {
            return this.project.toString();
        }
    }
}

