/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;

public class ResourceUtil {
    public static final String TASK_PAGE_NAME = "tasks";
    public static final String TASK_PORTLET_NAME = "TaskManagementApplication";

    public static String resolveMessage(ResourceBundle bundle, String key, Object ... args) {
        if (bundle == null || key == null) {
            return key;
        }
        try {
            String msg = bundle.getString(key);
            if (msg != null && args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] == null) continue;
                    String messageArg = String.valueOf(args[i]);
                    msg = msg.replace("{" + i + "}", messageArg);
                }
            }
            return msg;
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }

    public static <T> List<T> subList(List<T> it, int offset, int limit) {
        if (it == null) {
            return it;
        }
        if (it.size() <= offset) {
            return Collections.emptyList();
        }
        if (limit < 0) {
            limit = it.size();
        }
        if (offset < 0) {
            offset = 0;
        }
        limit = offset + limit > it.size() ? it.size() - offset : limit;
        return limit == it.size() && offset == 0 ? it : it.subList(offset, offset + limit);
    }

    public static String buildBaseURL(SiteKey siteKey, ExoContainer container, Router router) {
        Scope scope;
        NavigationContext ctx;
        if (siteKey == null) {
            return "#";
        }
        NodeContext page = null;
        NavigationService navService = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        NodeContext nodeCtx = navService.loadNode(NodeModel.SELF_MODEL, ctx = navService.loadNavigation(siteKey), scope = siteKey.getType().equals((Object)SiteType.GROUP) ? Scope.GRANDCHILDREN : Scope.CHILDREN, null);
        if (nodeCtx.getNodeSize() > 0) {
            Collection children = nodeCtx.getNodes();
            if (siteKey.getType() == SiteType.GROUP) {
                children = ((NodeContext)nodeCtx.get(0)).getNodes();
            }
            Iterator it = children.iterator();
            NodeContext child = null;
            while (it.hasNext()) {
                child = (NodeContext)it.next();
                if (!TASK_PAGE_NAME.equals(child.getName()) && child.getName().indexOf(TASK_PORTLET_NAME) < 0) continue;
                page = child;
                break;
            }
        }
        if (page == null) {
            return "#";
        }
        String portalName = ((ExoContainerContext)container.getComponentInstanceOfType(ExoContainerContext.class)).getPortalContainerName();
        HashMap<QualifiedName, String> qualifiedName = new HashMap<QualifiedName, String>();
        qualifiedName.put(QualifiedName.create((String)"gtn", (String)"handler"), portalName);
        qualifiedName.put(QualifiedName.create((String)"gtn", (String)"sitetype"), siteKey.getTypeName());
        qualifiedName.put(QualifiedName.create((String)"gtn", (String)"sitename"), siteKey.getName());
        qualifiedName.put(QualifiedName.create((String)"gtn", (String)"path"), page.getName());
        qualifiedName.put(QualifiedName.create((String)"gtn", (String)"lang"), "");
        try {
            return "/" + portalName + URLDecoder.decode(router.render(qualifiedName), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

