/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.ChangeLog;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.LabelTaskMapping;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.TaskPayload;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure1;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure11;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure13;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure15;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure17;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure19;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure21;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure23;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure25;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure3;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure5;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure7;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure9;

@Singleton
public class TaskServiceImpl
implements TaskService {
    private static final Log LOG;
    @Inject
    private DAOHandler daoHandler;
    private ListenerService listenerService;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    public TaskServiceImpl(DAOHandler daoHandler, ListenerService listenerService) {
        this.daoHandler = daoHandler;
        this.listenerService = listenerService;
    }

    @Override
    @ExoTransactional
    public Task createTask(Task task) {
        Task task2 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)task2);
        Object[] objectArray = new Object[]{this, task2, joinPoint};
        return (Task)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Task updateTask(Task task) {
        Task task2 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)task2);
        Object[] objectArray = new Object[]{this, task2, joinPoint};
        return (Task)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void updateTaskOrder(long currentTaskId, Status newStatus, long[] orders) {
        long l = currentTaskId;
        Status status = newStatus;
        long[] lArray = orders;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l), status, lArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.longObject((long)l), status, lArray, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeTask(long id) throws EntityNotFoundException {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Task cloneTask(long id) throws EntityNotFoundException {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        return (Task)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public Task getTask(long id) throws EntityNotFoundException {
        Task task = (Task)this.daoHandler.getTaskHandler().find(Long.valueOf(id));
        if (task == null) {
            LOG.info((Object)("Can not find task with ID: " + id));
            throw new EntityNotFoundException(id, (Class<?>)Task.class);
        }
        return task;
    }

    @Override
    public Comment getComment(long commentId) {
        return (Comment)this.daoHandler.getCommentHandler().find(Long.valueOf(commentId));
    }

    @Override
    public ListAccess<Comment> getComments(long taskId) {
        return this.daoHandler.getCommentHandler().findComments(taskId);
    }

    @Override
    @ExoTransactional
    public Comment addComment(long id, String username, String comment) throws EntityNotFoundException {
        long l = id;
        String string = username;
        String string2 = comment;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l), string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.longObject((long)l), string, string2, joinPoint};
        return (Comment)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure11(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public ChangeLog addTaskLog(long id, String username, String actionName, String target) throws EntityNotFoundException {
        long l = id;
        String string = username;
        String string2 = actionName;
        String string3 = target;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l), string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.longObject((long)l), string, string2, string3, joinPoint};
        return (ChangeLog)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure13(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    public ListAccess<ChangeLog> getTaskLogs(long taskId) {
        return this.daoHandler.getTaskLogHandler().findTaskLogs(taskId);
    }

    @Override
    @ExoTransactional
    public void removeComment(long commentId) throws EntityNotFoundException {
        long l = commentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public ListAccess<Task> findTasks(TaskQuery query) {
        return this.daoHandler.getTaskHandler().findTasks(query);
    }

    @Override
    public <T> List<T> selectTaskField(TaskQuery query, String fieldName) {
        return this.daoHandler.getTaskHandler().selectTaskField(query, fieldName);
    }

    @Override
    @ExoTransactional
    public void addTaskToLabel(Long taskId, Long labelId) throws EntityNotFoundException {
        Long l = taskId;
        Long l2 = labelId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)l, (Object)l2);
        Object[] objectArray = new Object[]{this, l, l2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeTaskFromLabel(Long taskId, Long labelId) throws EntityNotFoundException {
        Long l = taskId;
        Long l2 = labelId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)l, (Object)l2);
        Object[] objectArray = new Object[]{this, l, l2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public ListAccess<Task> findTasksByLabel(long labelId, List<Long> projectIds, String username, OrderBy orderBy) throws EntityNotFoundException {
        Label label;
        if (labelId > 0L && (label = this.getLabel(labelId)) == null) {
            throw new EntityNotFoundException(labelId, (Class<?>)Label.class);
        }
        return this.daoHandler.getTaskHandler().findTasksByLabel(labelId, projectIds, username, orderBy);
    }

    @Override
    public ListAccess<Label> findLabelsByUser(String username) {
        return this.daoHandler.getLabelHandler().findLabelsByUser(username);
    }

    @Override
    public ListAccess<Label> findLabelsByTask(long taskId, String username) throws EntityNotFoundException {
        return this.daoHandler.getLabelHandler().findLabelsByTask(taskId, username);
    }

    @Override
    public Label getLabel(long labelId) {
        return (Label)this.daoHandler.getLabelHandler().find(Long.valueOf(labelId));
    }

    @Override
    @ExoTransactional
    public Label createLabel(Label label) {
        Label label2 = label;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)label2);
        Object[] objectArray = new Object[]{this, label2, joinPoint};
        return (Label)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Label updateLabel(Label label, List<Label.FIELDS> fields) throws EntityNotFoundException {
        Label label2 = label;
        List<Label.FIELDS> list = fields;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)label2, list);
        Object[] objectArray = new Object[]{this, label2, list, joinPoint};
        return (Label)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeLabel(long labelId) {
        long l = labelId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure25(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public Task findTaskByActivityId(String id) {
        return this.daoHandler.getTaskHandler().findTaskByActivityId(id);
    }

    @Override
    public Set<String> getCoworker(long taskId) {
        return this.daoHandler.getTaskHandler().getCoworker(taskId);
    }

    static {
        TaskServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(TaskServiceImpl.class);
    }

    static /* synthetic */ Task createTask_aroundBody0(TaskServiceImpl ajc$this, Task task, JoinPoint joinPoint) {
        Task result = (Task)ajc$this.daoHandler.getTaskHandler().create(task);
        TaskPayload event = new TaskPayload(null, result);
        try {
            ajc$this.listenerService.broadcast("exo.task.taskCreation", (Object)ajc$this, (Object)event);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while broadcasting task creation event", (Throwable)e);
        }
        return result;
    }

    static /* synthetic */ Task updateTask_aroundBody2(TaskServiceImpl ajc$this, Task task, JoinPoint joinPoint) {
        if (task == null) {
            throw new IllegalArgumentException("Task must not be NULL");
        }
        Task oldTask = ajc$this.daoHandler.getTaskHandler().getTaskWithCoworkers(task.getId());
        Task newTask = (Task)ajc$this.daoHandler.getTaskHandler().update(task);
        TaskPayload event = new TaskPayload(oldTask, newTask);
        try {
            ajc$this.listenerService.broadcast("exo.task.taskUpdate", (Object)ajc$this, (Object)event);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while broadcasting task creation event", (Throwable)e);
        }
        return newTask;
    }

    static /* synthetic */ void updateTaskOrder_aroundBody4(TaskServiceImpl ajc$this, long currentTaskId, Status newStatus, long[] orders, JoinPoint joinPoint) {
        ajc$this.daoHandler.getTaskHandler().updateTaskOrder(currentTaskId, newStatus, orders);
    }

    static /* synthetic */ void removeTask_aroundBody6(TaskServiceImpl ajc$this, long id, JoinPoint joinPoint) {
        Task task = ajc$this.getTask(id);
        ajc$this.daoHandler.getTaskHandler().delete(task);
    }

    static /* synthetic */ Task cloneTask_aroundBody8(TaskServiceImpl ajc$this, long id, JoinPoint joinPoint) {
        Task task = ajc$this.getTask(id);
        Task newTask = task.clone();
        newTask.setId(0L);
        newTask.setCoworker(ajc$this.getCoworker(id));
        newTask.setTitle("Copy of " + newTask.getTitle());
        return ajc$this.createTask(newTask);
    }

    static /* synthetic */ Comment addComment_aroundBody10(TaskServiceImpl ajc$this, long id, String username, String comment, JoinPoint joinPoint) {
        Task task = ajc$this.getTask(id);
        Comment newComment = new Comment();
        newComment.setTask(task);
        newComment.setAuthor(username);
        newComment.setComment(comment);
        newComment.setCreatedTime(new Date());
        Comment obj = (Comment)ajc$this.daoHandler.getCommentHandler().create(newComment);
        try {
            ajc$this.listenerService.broadcast("exo.task.taskCommentCreation", (Object)ajc$this, (Object)obj);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while broadcasting task creation event", (Throwable)e);
        }
        return obj;
    }

    static /* synthetic */ ChangeLog addTaskLog_aroundBody12(TaskServiceImpl ajc$this, long id, String username, String actionName, String target, JoinPoint joinPoint) {
        ChangeLog log = new ChangeLog();
        log.setTask(ajc$this.getTask(id));
        log.setAuthor(username);
        log.setActionName(actionName);
        log.setTarget(target);
        return (ChangeLog)ajc$this.daoHandler.getTaskLogHandler().create(log);
    }

    static /* synthetic */ void removeComment_aroundBody14(TaskServiceImpl ajc$this, long commentId, JoinPoint joinPoint) {
        Comment comment = (Comment)ajc$this.daoHandler.getCommentHandler().find(Long.valueOf(commentId));
        if (comment == null) {
            LOG.info((Object)("Can not find comment with ID: " + commentId));
            throw new EntityNotFoundException(commentId, (Class<?>)Comment.class);
        }
        ajc$this.daoHandler.getCommentHandler().delete(comment);
    }

    static /* synthetic */ void addTaskToLabel_aroundBody16(TaskServiceImpl ajc$this, Long taskId, Long labelId, JoinPoint joinPoint) {
        LabelTaskMapping mapping = new LabelTaskMapping();
        mapping.setLabel(ajc$this.getLabel(labelId));
        mapping.setTask(ajc$this.getTask(taskId));
        ajc$this.daoHandler.getLabelTaskMappingHandler().create(mapping);
    }

    static /* synthetic */ void removeTaskFromLabel_aroundBody18(TaskServiceImpl ajc$this, Long taskId, Long labelId, JoinPoint joinPoint) {
        LabelTaskMapping mapping = new LabelTaskMapping();
        mapping.setLabel(ajc$this.getLabel(labelId));
        mapping.setTask(ajc$this.getTask(taskId));
        ajc$this.daoHandler.getLabelTaskMappingHandler().delete(mapping);
    }

    static /* synthetic */ Label createLabel_aroundBody20(TaskServiceImpl ajc$this, Label label, JoinPoint joinPoint) {
        return (Label)ajc$this.daoHandler.getLabelHandler().create(label);
    }

    static /* synthetic */ Label updateLabel_aroundBody22(TaskServiceImpl ajc$this, Label label, List fields, JoinPoint joinPoint) {
        Label lb = ajc$this.getLabel(label.getId());
        if (lb == null) {
            throw new EntityNotFoundException(label.getId(), (Class<?>)Label.class);
        }
        for (Label.FIELDS field : fields) {
            switch (field) {
                case NAME: {
                    lb.setName(label.getName());
                    break;
                }
                case COLOR: {
                    lb.setColor(label.getColor());
                    break;
                }
                case PARENT: {
                    lb.setParent(label.getParent());
                    break;
                }
                case HIDDEN: {
                    lb.setHidden(label.isHidden());
                }
            }
        }
        return (Label)ajc$this.daoHandler.getLabelHandler().update(lb);
    }

    static /* synthetic */ void removeLabel_aroundBody24(TaskServiceImpl ajc$this, long labelId, JoinPoint joinPoint) {
        ajc$this.daoHandler.getLabelHandler().delete(ajc$this.getLabel(labelId));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskServiceImpl.java", TaskServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTask", "org.exoplatform.task.service.impl.TaskServiceImpl", "org.exoplatform.task.domain.Task", "task", "", "org.exoplatform.task.domain.Task"), 70);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTask", "org.exoplatform.task.service.impl.TaskServiceImpl", "org.exoplatform.task.domain.Task", "task", "", "org.exoplatform.task.domain.Task"), 85);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createLabel", "org.exoplatform.task.service.impl.TaskServiceImpl", "org.exoplatform.task.domain.Label", "label", "", "org.exoplatform.task.domain.Label"), 258);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateLabel", "org.exoplatform.task.service.impl.TaskServiceImpl", "org.exoplatform.task.domain.Label:java.util.List", "label:fields", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.domain.Label"), 264);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeLabel", "org.exoplatform.task.service.impl.TaskServiceImpl", "long", "labelId", "", "void"), 291);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTaskOrder", "org.exoplatform.task.service.impl.TaskServiceImpl", "long:org.exoplatform.task.domain.Status:[J", "currentTaskId:newStatus:orders", "", "void"), 104);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeTask", "org.exoplatform.task.service.impl.TaskServiceImpl", "long", "id", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 110);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cloneTask", "org.exoplatform.task.service.impl.TaskServiceImpl", "long", "id", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.domain.Task"), 119);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addComment", "org.exoplatform.task.service.impl.TaskServiceImpl", "long:java.lang.String:java.lang.String", "id:username:comment", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.domain.Comment"), 153);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addTaskLog", "org.exoplatform.task.service.impl.TaskServiceImpl", "long:java.lang.String:java.lang.String:java.lang.String", "id:username:actionName:target", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.domain.ChangeLog"), 174);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeComment", "org.exoplatform.task.service.impl.TaskServiceImpl", "long", "commentId", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 191);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addTaskToLabel", "org.exoplatform.task.service.impl.TaskServiceImpl", "java.lang.Long:java.lang.Long", "taskId:labelId", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 214);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeTaskFromLabel", "org.exoplatform.task.service.impl.TaskServiceImpl", "java.lang.Long:java.lang.Long", "taskId:labelId", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 223);
    }
}

