/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.util.Map;
import javax.xml.namespace.QName;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.application.state.AbstractContextualPropertyProviderPlugin;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class SpacePropertiesPlugin
extends AbstractContextualPropertyProviderPlugin {
    private final QName spaceIdQName;
    private final QName spaceGroupIdQName;

    public SpacePropertiesPlugin(InitParams params) throws Exception {
        super(params);
        this.spaceIdQName = new QName(this.namespaceURI, "space_id");
        this.spaceGroupIdQName = new QName(this.namespaceURI, "space_group_id");
    }

    public void getProperties(UIPortlet portletWindow, Map<QName, String[]> properties) {
        try {
            Space space = this.getSpace();
            if (space != null) {
                this.addProperty(properties, this.spaceIdQName, space.getId());
                this.addProperty(properties, this.spaceGroupIdQName, space.getGroupId());
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Could not obtain contextual properties for portlet " + portletWindow), (Throwable)ex);
        }
    }

    private Space getSpace() {
        PortalRequestContext pContext = Util.getPortalRequestContext();
        if (!pContext.getSiteType().equals((Object)SiteType.GROUP) || !pContext.getSiteName().startsWith("/spaces")) {
            return null;
        }
        String requestPath = pContext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        ExoRouter.Route er = ExoRouter.route((String)requestPath);
        if (er != null && er.localArgs != null) {
            String spacePrettyName = (String)er.localArgs.get("spacePrettyName");
            SpaceService sService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
            if (spacePrettyName != null && !spacePrettyName.isEmpty()) {
                Space space = sService.getSpaceByPrettyName(spacePrettyName);
                return space;
            }
        }
        return null;
    }
}

