/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.command.NotificationCommand;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.integration.notification.NotificationUtils;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.ListUtil;

public class TaskCommentNotificationListener
extends Listener<TaskService, Comment> {
    private Pattern MENTION_REGEX = Pattern.compile("(\\s|^)(@)([\\S]+)");

    public void onEvent(Event<TaskService, Comment> event) throws Exception {
        TaskService taskService = (TaskService)event.getSource();
        Comment comment = (Comment)event.getData();
        NotificationContext ctx = this.buildContext(taskService, comment);
        this.dispatch(ctx, "TaskCommentedPlugin", "TaskMentionedPlugin");
    }

    private NotificationContext buildContext(TaskService taskService, Comment comment) {
        ListAccess comments;
        Set coworker;
        Task task = comment.getTask();
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(NotificationUtils.COMMENT, (Object)comment).append(NotificationUtils.TASK, (Object)task);
        String creator = ConversationState.getCurrent().getIdentity().getUserId();
        ctx.append(NotificationUtils.CREATOR, (Object)creator);
        HashSet<String> receiver = new HashSet<String>();
        receiver.add(task.getCreatedBy());
        if (task.getAssignee() != null && !task.getAssignee().isEmpty()) {
            receiver.add(task.getAssignee());
        }
        if ((coworker = taskService.getCoworker(task.getId())) != null && coworker.size() > 0) {
            receiver.addAll(coworker);
        }
        if ((comments = taskService.getComments(task.getId())) != null && ListUtil.getSize((ListAccess)comments) > 0) {
            for (Comment c : (Comment[])ListUtil.load((ListAccess)comments, (int)0, (int)-1)) {
                receiver.add(c.getAuthor());
                List subComments = c.getSubComments();
                if (subComments == null) continue;
                for (Comment subComment : subComments) {
                    receiver.add(subComment.getAuthor());
                }
            }
        }
        receiver.remove(creator);
        Set<String> mentioned = this.getMentioned(comment.getComment());
        mentioned.remove(creator);
        ctx.append(NotificationUtils.RECEIVERS, receiver);
        ctx.append(NotificationUtils.MENTIONED, mentioned);
        return ctx;
    }

    private void dispatch(NotificationContext ctx, String ... pluginId) {
        ArrayList<NotificationCommand> commands = new ArrayList<NotificationCommand>(pluginId.length);
        for (String p : pluginId) {
            commands.add(ctx.makeCommand(PluginKey.key((String)p)));
        }
        ctx.getNotificationExecutor().with(commands).execute(ctx);
    }

    private Set<String> getMentioned(String text) {
        HashSet<String> set = new HashSet<String>();
        if (text == null || text.isEmpty()) {
            return set;
        }
        Matcher m = this.MENTION_REGEX.matcher(text);
        while (m.find()) {
            set.add(m.group(3));
        }
        return set;
    }
}

