/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.notification;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.task.integration.notification.NotificationUtils;
import org.exoplatform.task.integration.notification.TemplateUtils;
import org.exoplatform.task.service.UserService;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="TaskAssignPlugin", template="war:/notification/templates/web/TaskAssignPlugin.gtmpl"), @TemplateConfig(pluginId="TaskCoworkerPlugin", template="war:/notification/templates/web/TaskCoworkerPlugin.gtmpl"), @TemplateConfig(pluginId="TaskDueDatePlugin", template="war:/notification/templates/web/TaskDueDatePlugin.gtmpl"), @TemplateConfig(pluginId="TaskCompletedPlugin", template="war:/notification/templates/web/TaskCompletedPlugin.gtmpl"), @TemplateConfig(pluginId="TaskCommentedPlugin", template="war:/notification/templates/web/TaskCommentPlugin.gtmpl"), @TemplateConfig(pluginId="TaskMentionedPlugin", template="war:/notification/templates/web/TaskMentionPlugin.gtmpl")})
public class WebTemplateProvider
extends TemplateProvider {
    public WebTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"TaskAssignPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"TaskCoworkerPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"TaskDueDatePlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"TaskCompletedPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"TaskCommentedPlugin"), new CommentTemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"TaskMentionedPlugin"), new TemplateBuilder());
    }

    private List<Long> parseListTaskId(String ids) {
        ArrayList<Long> set = new ArrayList<Long>();
        if (ids != null && !ids.trim().isEmpty()) {
            for (String id : ids.trim().split(",")) {
                set.add(Long.parseLong(id));
            }
        }
        return set;
    }

    private String mergeListTaskId(List<Long> ids) {
        StringBuilder sb = new StringBuilder();
        if (ids != null && ids.size() > 0) {
            for (Long id : ids) {
                sb.append(id).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private List<String> parseListUser(String users) {
        ArrayList<String> set = new ArrayList<String>();
        if (users != null && !users.isEmpty()) {
            for (String s : users.split(",")) {
                if (s.trim().length() <= 0) continue;
                set.add(s.trim());
            }
        }
        return set;
    }

    private String mergeUsers(List<String> users) {
        StringBuilder sb = new StringBuilder();
        if (users != null && users.size() > 0) {
            for (String u : users) {
                sb.append(u).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private class CommentTemplateBuilder
    extends AbstractTemplateBuilder {
        private CommentTemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            WebNotificationStorage storage;
            NotificationInfo prevNotif;
            NotificationInfo notification = ctx.getNotificationInfo();
            String pluginId = notification.getKey().getId();
            String activityId = notification.getValueOwnerParameter("activityId");
            if (ctx.isWritingProcess() && (prevNotif = (storage = (WebNotificationStorage)CommonsUtils.getService(WebNotificationStorage.class)).getUnreadNotification(pluginId, activityId, notification.getTo())) != null) {
                List taskIds = WebTemplateProvider.this.parseListTaskId(prevNotif.getValueOwnerParameter("tasks"));
                Long newId = Long.parseLong(notification.getValueOwnerParameter("tasks"));
                taskIds.remove(newId);
                taskIds.add(newId);
                if (taskIds.size() > 1) {
                    prevNotif.with("taskName", "");
                    prevNotif.with("count", String.valueOf(taskIds.size()));
                }
                prevNotif.with("tasks", WebTemplateProvider.this.mergeListTaskId(taskIds));
                List users = WebTemplateProvider.this.parseListUser(prevNotif.getValueOwnerParameter(NotificationUtils.CREATOR.getKey()));
                String newUser = notification.getValueOwnerParameter(NotificationUtils.CREATOR.getKey());
                users.remove(newUser);
                users.add(newUser);
                prevNotif.with(NotificationUtils.CREATOR.getKey(), WebTemplateProvider.this.mergeUsers(users));
                prevNotif.setUpdate(true);
                prevNotif.setLastModifiedDate(System.currentTimeMillis());
                prevNotif.setDateCreated(Calendar.getInstance());
                ctx.setNotificationInfo(prevNotif);
                notification = prevNotif;
            }
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            List creator = WebTemplateProvider.this.parseListUser(notification.getValueOwnerParameter(NotificationUtils.CREATOR.getKey()));
            String projectName = notification.getValueOwnerParameter("projectName");
            String taskTitle = notification.getValueOwnerParameter("taskName");
            String taskUrl = notification.getValueOwnerParameter("taskUrl");
            String projectUrl = notification.getValueOwnerParameter("projectUrl");
            Date dueDate = null;
            String tmpD = notification.getValueOwnerParameter("dueDate");
            if (tmpD != null) {
                dueDate = new Date(Long.parseLong(tmpD));
            }
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            Collections.reverse(creator);
            templateContext.put((Object)"TOTAL_USER", (Object)creator.size());
            Profile lastUser = identityManager.getOrCreateIdentity("organization", (String)creator.get(0), true).getProfile();
            templateContext.put((Object)"AVATAR", (Object)(lastUser.getAvatarUrl() != null ? lastUser.getAvatarUrl() : "/eXoSkin/skin/images/system/UserAvtDefault.png"));
            templateContext.put((Object)"USER", (Object)encoder.encode(lastUser.getFullName().toString()));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)((String)lastUser.getProperty("username"))));
            templateContext.put((Object)"COUNT_USER", (Object)(creator.size() > 2 ? creator.size() - 2 : 0));
            if (creator.size() > 1) {
                Profile lastUser2 = identityManager.getOrCreateIdentity("organization", (String)creator.get(1), true).getProfile();
                templateContext.put((Object)"USER2", (Object)encoder.encode(lastUser2.getFullName().toString()));
                templateContext.put((Object)"PROFILE_URL2", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)((String)lastUser2.getProperty("username"))));
            }
            templateContext.put((Object)"PROJECT_NAME", (Object)encoder.encode(projectName));
            templateContext.put((Object)"TASK_URL", (Object)taskUrl);
            templateContext.put((Object)"PROJECT_URL", (Object)projectUrl);
            templateContext.put((Object)"TASK_TITLE", (Object)encoder.encode(taskTitle));
            UserService userService = (UserService)CommonsUtils.getService(UserService.class);
            templateContext.put((Object)"DUE_DATE", (Object)TemplateUtils.format(dueDate, userService.getUserTimezone(notification.getTo())));
            templateContext.put((Object)"COUNT", (Object)notification.getValueOwnerParameter("count"));
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            String body = org.exoplatform.commons.notification.template.TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            WebNotificationStorage storage;
            NotificationInfo prevNotif;
            NotificationInfo notification = ctx.getNotificationInfo();
            String pluginId = notification.getKey().getId();
            String activityId = notification.getValueOwnerParameter("activityId");
            if (ctx.isWritingProcess() && (prevNotif = (storage = (WebNotificationStorage)CommonsUtils.getService(WebNotificationStorage.class)).getUnreadNotification(pluginId, activityId, notification.getTo())) != null) {
                prevNotif.with("taskName", "");
                String count = prevNotif.getValueOwnerParameter("count");
                if (count != null) {
                    prevNotif.with("count", String.valueOf(Integer.parseInt(count) + 1));
                } else {
                    prevNotif.with("count", String.valueOf(2));
                }
                prevNotif.setUpdate(true);
                prevNotif.setLastModifiedDate(System.currentTimeMillis());
                ctx.setNotificationInfo(prevNotif);
                notification = prevNotif;
            }
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            String creator = notification.getValueOwnerParameter(NotificationUtils.CREATOR.getKey());
            String projectName = notification.getValueOwnerParameter("projectName");
            String taskTitle = notification.getValueOwnerParameter("taskName");
            String taskUrl = notification.getValueOwnerParameter("taskUrl");
            String projectUrl = notification.getValueOwnerParameter("projectUrl");
            Date dueDate = null;
            String tmpD = notification.getValueOwnerParameter("dueDate");
            if (tmpD != null) {
                dueDate = new Date(Long.parseLong(tmpD));
            }
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            Identity identity = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", creator, true);
            Profile profile = identity.getProfile();
            templateContext.put((Object)"USER", (Object)encoder.encode(profile.getFullName().toString()));
            templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/eXoSkin/skin/images/system/UserAvtDefault.png"));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)identity.getRemoteId()));
            templateContext.put((Object)"PROJECT_NAME", (Object)encoder.encode(projectName));
            templateContext.put((Object)"TASK_URL", (Object)taskUrl);
            templateContext.put((Object)"PROJECT_URL", (Object)projectUrl);
            templateContext.put((Object)"TASK_TITLE", (Object)encoder.encode(taskTitle));
            UserService userService = (UserService)CommonsUtils.getService(UserService.class);
            templateContext.put((Object)"DUE_DATE", (Object)TemplateUtils.format(dueDate, userService.getUserTimezone(notification.getTo())));
            templateContext.put((Object)"COUNT", (Object)notification.getValueOwnerParameter("count"));
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            String body = org.exoplatform.commons.notification.template.TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    }
}

