/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.ProjectQuery;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.model.User;
import org.exoplatform.task.service.CommentService;
import org.exoplatform.task.service.LabelService;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.StringUtil;
import org.exoplatform.task.util.TaskUtil;
import org.exoplatform.task.util.UserUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/projects")
@Api(value="/projects", description="Managing tasks")
@RolesAllowed(value={"users"})
public class ProjectRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ProjectRestService.class);
    private TaskService taskService;
    private ProjectService projectService;
    private StatusService statusService;
    private UserService userService;
    private SpaceService spaceService;
    private LabelService labelService;
    private CommentService commentService;
    private IdentityManager identityManager;

    public ProjectRestService(TaskService taskService, CommentService commentService, ProjectService projectService, StatusService statusService, UserService userService, SpaceService spaceService, LabelService labelService, IdentityManager identityManager) {
        this.taskService = taskService;
        this.commentService = commentService;
        this.projectService = projectService;
        this.statusService = statusService;
        this.userService = userService;
        this.spaceService = spaceService;
        this.labelService = labelService;
        this.identityManager = identityManager;
    }

    @GET
    @Path(value="projects")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets projects", httpMethod="GET", response=Response.class, notes="This returns projects of the authenticated user")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getProjects(@ApiParam(value="Search term", required=false, defaultValue="null") @QueryParam(value="q") String query, @ApiParam(value="Space Name", required=false, defaultValue="null") @QueryParam(value="spaceName") String spaceName, @ApiParam(value="Filter", required=false, defaultValue="") @QueryParam(value="projectsFilter") String projectsFilter, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="-1") @QueryParam(value="limit") int limit, @ApiParam(value="Participator Need", required=false, defaultValue="false") @QueryParam(value="participatorParam") boolean participatorParam) {
        if (limit == 0) {
            limit = -1;
        }
        try {
            LinkedList<String> memberships = new LinkedList<String>();
            ConversationState state = ConversationState.getCurrent();
            Identity identity = state.getIdentity();
            List<Object> projects = new ArrayList();
            int projectNumber = 0;
            if (projectsFilter != null && projectsFilter.equals("MANAGED")) {
                ArrayList<String> managers = new ArrayList<String>();
                managers.add(identity.getUserId());
                ProjectQuery projectQuery = new ProjectQuery();
                projectQuery.setManager(managers);
                projectQuery.setKeyword(query);
                OrderBy.DESC orderBy = new OrderBy.DESC("lastModifiedDate");
                projectQuery.setOrderBy(Arrays.asList(orderBy));
                projects = this.projectService.findProjects(projectQuery, offset, limit);
                projectNumber = this.projectService.countProjects(projectQuery);
            } else if (projectsFilter != null && projectsFilter.equals("COLLABORATED")) {
                projects = this.projectService.findCollaboratedProjects(identity.getUserId(), query, offset, limit);
                projectNumber = this.projectService.countCollaboratedProjects(identity.getUserId(), query);
            } else if (projectsFilter != null && projectsFilter.equals("WITH_TASKS")) {
                memberships.addAll(UserUtil.getMemberships(identity));
                projects = this.projectService.findNotEmptyProjects(memberships, query, offset, limit);
                projectNumber = this.projectService.countNotEmptyProjects(memberships, query);
            } else {
                if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{spaceName})) {
                    Space space = this.spaceService.getSpaceByPrettyName(spaceName);
                    if (space != null) {
                        memberships.addAll(UserUtil.getSpaceMemberships(space.getGroupId()));
                    }
                } else {
                    memberships.addAll(UserUtil.getMemberships(identity));
                }
                OrderBy.DESC orderBy = new OrderBy.DESC("lastModifiedDate");
                projects = this.projectService.findProjects(memberships, query, orderBy, offset, limit);
                projectNumber = this.projectService.countProjects(memberships, query);
            }
            JSONObject global = new JSONObject();
            JSONArray projectsJsonArray = new JSONArray();
            projectsJsonArray = this.buildJSON(projectsJsonArray, projects, participatorParam);
            global.put("projects", (Object)projectsJsonArray);
            global.put("projectNumber", projectNumber);
            return Response.ok((Object)global.toString()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting projects", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="projects/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets  project by id", httpMethod="GET", response=Response.class, notes="This returns the default status by project id")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getProjectById(@ApiParam(value="Project id", required=true) @PathParam(value="id") long id, @ApiParam(value="Participator Need", required=false, defaultValue="false") @QueryParam(value="participatorParam") boolean participatorParam) {
        try {
            Identity currentUser = ConversationState.getCurrent().getIdentity();
            ProjectDto project = this.projectService.getProject(id);
            if (project == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!project.canView(currentUser)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok((Object)this.buildJsonProject(project, participatorParam).toString()).build();
        }
        catch (Exception e) {
            LOG.error("Can't get Project with id {}", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="projects/status/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the default status by project id", httpMethod="GET", response=Response.class, notes="This returns the default status by project id")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getDefaultStatusByProjectId(@ApiParam(value="Project id", required=true) @PathParam(value="id") long id) {
        try {
            Identity currentUser = ConversationState.getCurrent().getIdentity();
            ProjectDto project = this.projectService.getProject(id);
            if (project == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!project.canView(currentUser)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            StatusDto status = this.statusService.getDefaultStatus(id);
            return Response.ok((Object)status).build();
        }
        catch (Exception e) {
            LOG.error("Can't get Default StatusBy Project id {}", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="projects/statuses/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the statuses by project id", httpMethod="GET", response=Response.class, notes="This returns the statuses by project id")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response getStatusesByProjectId(@ApiParam(value="Project id", required=true) @PathParam(value="id") long id) {
        try {
            Identity currentUser = ConversationState.getCurrent().getIdentity();
            ProjectDto project = this.projectService.getProject(id);
            if (project == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!project.canView(currentUser)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            List<StatusDto> projectStatuses = this.statusService.getStatuses(id);
            return Response.ok(projectStatuses).build();
        }
        catch (Exception e) {
            LOG.error("Can't get Statuses for ProjectId {}", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="project/statistics/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets users by query and project name", httpMethod="GET", response=Response.class, notes="This returns users by query and project name")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled")})
    public Response getProjectsStatistics(@ApiParam(value="id", required=true) @PathParam(value="id") long id) {
        try {
            HashMap<String, Integer> hm = new HashMap<String, Integer>();
            for (StatusDto statusDto : this.statusService.getStatuses(id)) {
                hm.put(statusDto.getName(), 0);
            }
            int tasksNum = 0;
            JSONObject projectJson = new JSONObject();
            List<Object[]> statusObjects = this.taskService.countTaskStatusByProject(id);
            JSONArray statusStats = new JSONArray();
            if (statusObjects != null && statusObjects.size() > 0) {
                for (Object[] objectArray : statusObjects) {
                    hm.put((String)objectArray[0], ((Number)objectArray[1]).intValue());
                    tasksNum += ((Number)objectArray[1]).intValue();
                }
                for (Map.Entry entry : hm.entrySet()) {
                    JSONObject statJson = new JSONObject();
                    statJson.put("name", entry.getKey());
                    statJson.put("value", entry.getValue());
                    statusStats.put((Object)statJson);
                }
            }
            projectJson.put("statusStats", (Object)statusStats);
            projectJson.put("totalNumberTasks", tasksNum);
            return Response.ok((Object)projectJson.toString()).build();
        }
        catch (Exception e) {
            LOG.error("Can't get Statistics for project {}", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="users/{query}/{projectName}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets users by query and project name", httpMethod="GET", response=Response.class, notes="This returns users by query and project name")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled")})
    public Response getUsersByQueryAndProjectName(@ApiParam(value="Query", required=true) @PathParam(value="query") String query, @ApiParam(value="projectName", required=true) @PathParam(value="projectName") String projectName) {
        try {
            ListAccess<User> usersList = this.userService.findUserByName(query);
            JSONArray usersJsonArray = new JSONArray();
            for (User user : (User[])usersList.load(0, 10)) {
                JSONObject userJson = new JSONObject();
                Space space = this.spaceService.getSpaceByPrettyName(projectName);
                if (space != null && !this.spaceService.isMember(space, user.getUsername())) continue;
                userJson.put("username", (Object)user.getUsername());
                userJson.put("fullname", (Object)user.getDisplayName());
                userJson.put("avatar", (Object)user.getAvatar());
                usersJsonArray.put((Object)userJson);
            }
            return Response.ok((Object)usersJsonArray.toString()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Can't get Users ", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    private JSONArray buildJSON(JSONArray projectsJsonArray, List<ProjectDto> projects, boolean participatorParam) throws JSONException {
        Identity currentUser = ConversationState.getCurrent().getIdentity();
        for (ProjectDto project : projects) {
            if (!project.canView(currentUser)) continue;
            projectsJsonArray.put((Object)this.buildJsonProject(project, participatorParam));
        }
        return projectsJsonArray;
    }

    private JSONObject buildJsonProject(ProjectDto project, boolean participatorParam) throws JSONException {
        User user_;
        User user_2;
        JSONObject profile;
        String groupId;
        int index;
        long projectId = project.getId();
        Space space = null;
        Set<String> projectManagers = this.projectService.getManager(projectId);
        LinkedHashSet<String> managers = new LinkedHashSet<String>();
        Set<String> projectParticipators = this.projectService.getParticipator(projectId);
        LinkedHashSet<String> participators = new LinkedHashSet<String>();
        JSONArray participatorsDetail = new JSONArray();
        JSONArray managersDetail = new JSONArray();
        JSONObject projectJson = new JSONObject();
        if (projectManagers.size() > 0) {
            for (String permission : this.projectService.getManager(projectId)) {
                JSONObject manager;
                if (permission == null) continue;
                index = permission.indexOf(58);
                if (index > -1) {
                    groupId = permission.substring(index + 1);
                    space = this.spaceService.getSpaceByGroupId(groupId);
                    if (space == null) continue;
                    managers.addAll(Arrays.asList(space.getManagers()));
                    manager = new JSONObject();
                    manager.put("id", (Object)("space:" + space.getPrettyName()));
                    manager.put("remoteId", (Object)space.getPrettyName());
                    manager.put("providerId", (Object)"space");
                    profile = new JSONObject();
                    profile.put("fullName", (Object)space.getDisplayName());
                    profile.put("originalName", (Object)space.getPrettyName());
                    profile.put("avatarUrl", (Object)("/portal/rest/v1/social/spaces/" + space.getPrettyName() + "/avatar"));
                    manager.put("profile", (Object)profile);
                    managersDetail.put((Object)manager);
                    continue;
                }
                user_2 = UserUtil.getUser(permission);
                if (user_2 == null) continue;
                managers.add(permission);
                manager = new JSONObject();
                manager.put("id", (Object)("organization:" + permission));
                manager.put("remoteId", (Object)permission);
                manager.put("providerId", (Object)"organization");
                profile = new JSONObject();
                profile.put("fullName", (Object)user_2.getDisplayName());
                profile.put("avatarUrl", (Object)user_2.getAvatar());
                manager.put("profile", (Object)profile);
                managersDetail.put((Object)manager);
            }
        }
        if (projectParticipators.size() > 0 && participatorParam) {
            for (String permission : projectParticipators) {
                if (permission == null) continue;
                index = permission.indexOf(58);
                if (index > -1) {
                    groupId = permission.substring(index + 1);
                    Space spaceP = this.spaceService.getSpaceByGroupId(groupId);
                    if (spaceP != null) {
                        participators.addAll(Arrays.asList(spaceP.getMembers()));
                        JSONObject participator = new JSONObject();
                        participator.put("id", (Object)("space:" + spaceP.getPrettyName()));
                        participator.put("remoteId", (Object)spaceP.getPrettyName());
                        participator.put("providerId", (Object)"space");
                        JSONObject profile2 = new JSONObject();
                        profile2.put("fullName", (Object)spaceP.getDisplayName());
                        profile2.put("originalName", (Object)spaceP.getPrettyName());
                        profile2.put("avatarUrl", (Object)("/portal/rest/v1/social/spaces/" + spaceP.getPrettyName() + "/avatar"));
                        participator.put("profile", (Object)profile2);
                        participatorsDetail.put((Object)participator);
                        continue;
                    }
                    projectParticipators.remove(permission);
                    continue;
                }
                user_2 = UserUtil.getUser(permission);
                if (user_2 == null) continue;
                participators.add(permission);
                JSONObject participator = new JSONObject();
                participator.put("id", (Object)("organization:" + permission));
                participator.put("remoteId", (Object)permission);
                participator.put("providerId", (Object)"organization");
                profile = new JSONObject();
                profile.put("fullName", (Object)user_2.getDisplayName());
                profile.put("avatarUrl", (Object)user_2.getAvatar());
                participator.put("profile", (Object)profile);
                participatorsDetail.put((Object)participator);
            }
        }
        if (participators.size() > 0) {
            JSONArray participatorsJsonArray = new JSONArray();
            for (String usr : participators) {
                JSONObject participator = new JSONObject();
                user_ = UserUtil.getUser(usr);
                if (user_ == null) continue;
                participator.put("username", (Object)user_.getUsername());
                participator.put("email", (Object)user_.getEmail());
                participator.put("displayName", (Object)user_.getDisplayName());
                participator.put("avatar", (Object)user_.getAvatar());
                participator.put("url", (Object)user_.getUrl());
                participator.put("enable", user_.isEnable());
                participator.put("deleted", user_.isDeleted());
                participatorsJsonArray.put((Object)participator);
            }
            projectJson.put("participatorIdentities", (Object)participatorsJsonArray);
        }
        if (managers.size() > 0) {
            JSONArray managersJsonArray = new JSONArray();
            for (String usr : managers) {
                JSONObject manager = new JSONObject();
                user_ = UserUtil.getUser(usr);
                if (user_ == null) continue;
                manager.put("username", (Object)user_.getUsername());
                manager.put("email", (Object)user_.getEmail());
                manager.put("displayName", (Object)user_.getDisplayName());
                manager.put("avatar", (Object)user_.getAvatar());
                manager.put("url", (Object)user_.getUrl());
                manager.put("enable", user_.isEnable());
                manager.put("deleted", user_.isDeleted());
                managersJsonArray.put((Object)manager);
            }
            projectJson.put("managerIdentities", (Object)managersJsonArray);
        }
        if (space != null) {
            JSONObject spaceJson = new JSONObject();
            spaceJson.put("prettyName", (Object)space.getPrettyName());
            spaceJson.put("url", (Object)space.getUrl());
            spaceJson.put("displayName", (Object)space.getDisplayName());
            spaceJson.put("id", (Object)space.getId());
            spaceJson.put("avatarUrl", (Object)space.getAvatarUrl());
            spaceJson.put("description", (Object)space.getDescription());
            projectJson.put("space", (Object)space);
            projectJson.put("spaceDetails", (Object)spaceJson);
        }
        projectJson.put("id", projectId);
        projectJson.put("name", (Object)project.getName());
        projectJson.put("color", (Object)project.getColor());
        projectJson.put("participator", projectParticipators);
        projectJson.put("participatorsDetail", (Object)participatorsDetail);
        projectJson.put("hiddenOn", project.getHiddenOn());
        projectJson.put("manager", this.projectService.getManager(projectId));
        projectJson.put("managersDetail", (Object)managersDetail);
        projectJson.put("dueDate", (Object)project.getDueDate());
        projectJson.put("description", (Object)project.getDescription());
        projectJson.put("canManage", project.canEdit(ConversationState.getCurrent().getIdentity()));
        return projectJson;
    }

    @POST
    @Path(value="createproject")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Adds a project", httpMethod="POST", response=Response.class, notes="This Adds project")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response createProject(@ApiParam(value="ProjectDto", required=true) ProjectDto projectDto) {
        try {
            ProjectDto project;
            String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
            if (currentUser == null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            if (projectDto.getName() == null || projectDto.getName().isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String description = StringUtil.encodeInjectedHtmlTag(projectDto.getDescription());
            Space space = null;
            if (StringUtils.isNotBlank((CharSequence)projectDto.getSpaceName()) && (space = this.spaceService.getSpaceByPrettyName(projectDto.getSpaceName())) == null) {
                LOG.warn("User {} attempts to create a project under a non existing space {}", new Object[]{currentUser, projectDto.getSpaceName()});
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (space != null) {
                if (!this.spaceService.isMember(space, currentUser)) {
                    LOG.warn("User {} attempts to create a project under a non authorized space {}", new Object[]{currentUser, projectDto.getSpaceName()});
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                List<String> memberships = UserUtil.getSpaceMemberships(space.getGroupId());
                HashSet<String> managers = new HashSet<String>(Arrays.asList(memberships.get(0)));
                HashSet<String> participators = new HashSet<String>(Arrays.asList(memberships.get(1)));
                project = ProjectUtil.newProjectInstanceDto(projectDto.getName(), description, managers, participators);
            } else if (projectDto.getManager() != null && projectDto.getManager().size() != 0 || projectDto.getParticipator() != null && projectDto.getParticipator().size() != 0) {
                HashSet<String> managers = new HashSet<String>();
                if (projectDto.getManager().size() == 0) {
                    managers.add(currentUser);
                } else {
                    projectDto.getManager().forEach(name -> managers.add((String)name));
                }
                HashSet<String> paticipator = new HashSet<String>();
                if (projectDto.getParticipator() != null) {
                    projectDto.getParticipator().forEach(name -> paticipator.add((String)name));
                }
                project = ProjectUtil.newProjectInstanceDto(projectDto.getName(), description, managers, paticipator);
            } else {
                project = ProjectUtil.newProjectInstanceDto(projectDto.getName(), description, currentUser);
            }
            if (projectDto.getParent() != null) {
                Long parentId = projectDto.getParent().getId();
                ProjectDto parent = this.projectService.getProject(parentId);
                if (!parent.canEdit(ConversationState.getCurrent().getIdentity())) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                project = this.projectService.createProject(project, parentId);
            } else {
                project = this.projectService.createProject(project);
                this.statusService.createInitialStatuses(project);
            }
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            JSONObject result = new JSONObject();
            result.put("id", project.getId());
            result.put("name", (Object)encoder.encode(project.getName()));
            result.put("color", (Object)"transparent");
            return Response.ok((Object)result.toString()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Can't create Project", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="updateproject/{projectId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Update Project", httpMethod="POST", response=Response.class, notes="This Update Project info")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response updateProject(@ApiParam(value="projectId", required=true) @PathParam(value="projectId") long projectId, @ApiParam(value="Project", required=true) ProjectDto projectDto) {
        try {
            String[] array;
            if (projectDto.getName() == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Identity identity = ConversationState.getCurrent().getIdentity();
            if (projectDto.getParent() != null && !projectDto.getParent().toString().isEmpty()) {
                Long parentId = Long.parseLong(projectDto.getParent().toString());
                try {
                    if (!this.projectService.getProject(parentId).canEdit(identity)) {
                        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                    }
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    // empty catch block
                }
            }
            if (!this.projectService.getProject(projectId).canEdit(identity)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            HashMap<String, String[]> fields = new HashMap<String, String[]>();
            HashMap fieldsSet = new HashMap();
            fields.put("name", new String[]{projectDto.getName()});
            String description = StringUtil.encodeInjectedHtmlTag(projectDto.getDescription());
            fields.put("description", new String[]{description});
            if (projectDto.getParent() != null) {
                fields.put("parent", new String[]{projectDto.getParent().toString()});
            }
            if (projectDto.getManager() != null) {
                HashSet managers = new HashSet();
                projectDto.getManager().forEach(name -> managers.add(name));
                array = managers.toArray(new String[0]);
                fieldsSet.put("manager", managers);
                fields.put("manager", array);
            }
            if (projectDto.getParticipator() != null) {
                HashSet participators = new HashSet();
                projectDto.getParticipator().forEach(name -> participators.add(name));
                array = participators.toArray(new String[0]);
                fieldsSet.put("participator", participators);
                fields.put("participator", array);
            }
            ProjectDto project = ProjectUtil.saveProjectField(this.projectService, projectId, fields);
            this.projectService.updateProjectNoReturn(project);
            return Response.ok((Object)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOG.error("Can't update Project {}", new Object[]{projectId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="{projectId}")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Delete Project", httpMethod="DELETE", response=Response.class, notes="This deletes the Project", consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Project deleted"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to delete the Project"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteProject(@ApiParam(value="projectId", required=true) @PathParam(value="projectId") Long projectId, @ApiParam(value="deleteChild", defaultValue="false") @QueryParam(value="deleteChild") Boolean deleteChild, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="-1") @QueryParam(value="limit") int limit) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            ProjectDto project = this.projectService.getProject(projectId);
            if (!project.canEdit(identity)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (deleteChild.booleanValue()) {
                List<ProjectDto> childs = this.projectService.getSubProjects(projectId, offset, limit);
                for (ProjectDto child : childs) {
                    if (child.canEdit(identity)) continue;
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
            }
            this.projectService.removeProject(projectId, deleteChild);
            return Response.ok((Object)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOG.error("Can't deleteProject {}", new Object[]{projectId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="cloneproject")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Clone a project", httpMethod="POST", response=Response.class, notes="This Clone project")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response cloneProject(@ApiParam(value="ProjectDto", required=true) ProjectDto projectDto) {
        try {
            ProjectDto currentProject = projectDto;
            if (!currentProject.canEdit(ConversationState.getCurrent().getIdentity())) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            ProjectDto project = this.projectService.cloneProject(projectDto.getId(), Boolean.parseBoolean("true"));
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            JSONObject result = new JSONObject();
            result.put("id", project.getId());
            result.put("name", (Object)encoder.encode(project.getName()));
            result.put("color", (Object)project.getColor());
            return Response.ok((Object)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOG.error("Can't clone Project {}", new Object[]{projectDto.getId(), e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="changeProjectColor/{projectId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Change Project Color", httpMethod="POST", response=Response.class, notes="This change Project Color")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response changeProjectColor(@ApiParam(value="projectId", required=true) @PathParam(value="projectId") Long projectId, @ApiParam(value="color", required=false, defaultValue="null") @QueryParam(value="color") String color) {
        try {
            HashMap<String, String[]> fields = new HashMap<String, String[]>();
            fields.put("color", new String[]{color});
            ProjectDto project = this.projectService.getProject(projectId);
            if (!project.canEdit(ConversationState.getCurrent().getIdentity())) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            project = ProjectUtil.saveProjectField(this.projectService, projectId, fields);
            this.projectService.updateProjectNoReturn(project);
            return Response.ok((Object)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOG.error("Can't change Project Color {}", new Object[]{projectId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="projectParticipants/{idProject}/{term}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets participants", httpMethod="GET", response=Response.class, notes="This returns participants in project")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled")})
    public Response getProjectParticipants(@ApiParam(value="Project id", required=true) @PathParam(value="idProject") long idProject, @ApiParam(value="User name search information", required=false) @PathParam(value="term") String term, @ApiParam(value="Include or not current user", required=false) @QueryParam(value="includeCurrentUser") boolean includeCurrentUser) {
        Identity currentUser = ConversationState.getCurrent().getIdentity();
        Set<String> participants = this.projectService.getParticipator(idProject);
        Set<String> managers = this.projectService.getManager(idProject);
        managers.forEach(manager -> participants.add((String)manager));
        try {
            JSONArray usersJsonArray = new JSONArray();
            HashSet<org.exoplatform.social.core.identity.model.Identity> userIdentities = new HashSet<org.exoplatform.social.core.identity.model.Identity>();
            SpaceMemberFilterListAccess.Type type = SpaceMemberFilterListAccess.Type.valueOf((String)SpaceMemberFilterListAccess.Type.MEMBER.name().toUpperCase());
            ProfileFilter profileFilter = new ProfileFilter();
            profileFilter.setName(term);
            for (String participant : participants) {
                int index = participant.indexOf(58);
                if (index > -1) {
                    String groupId = participant.substring(index + 1);
                    Space space = this.spaceService.getSpaceByGroupId(groupId);
                    ListAccess spaceIdentitiesListAccess = this.identityManager.getSpaceIdentityByProfileFilter(space, profileFilter, type, true);
                    org.exoplatform.social.core.identity.model.Identity[] spaceIdentities = (org.exoplatform.social.core.identity.model.Identity[])spaceIdentitiesListAccess.load(0, 21);
                    if (spaceIdentities.length <= 0) continue;
                    for (org.exoplatform.social.core.identity.model.Identity spaceMember : spaceIdentities) {
                        if (StringUtils.equals((CharSequence)spaceMember.getRemoteId(), (CharSequence)currentUser.getUserId()) && !includeCurrentUser) continue;
                        userIdentities.add(spaceMember);
                    }
                    continue;
                }
                if (StringUtils.equals((CharSequence)currentUser.getUserId(), (CharSequence)participant) && !includeCurrentUser || !participant.contains(term)) continue;
                org.exoplatform.social.core.identity.model.Identity userIdentity2 = this.identityManager.getOrCreateIdentity("organization", participant);
                userIdentities.add(userIdentity2);
            }
            userIdentities.forEach(userIdentity -> this.addParticipantToUserList(usersJsonArray, (org.exoplatform.social.core.identity.model.Identity)userIdentity));
            return Response.ok((Object)usersJsonArray.toString()).build();
        }
        catch (Exception e) {
            LOG.error("Can't get Project Participants {}", new Object[]{idProject, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    private void addParticipantToUserList(JSONArray usersJsonArray, org.exoplatform.social.core.identity.model.Identity userIdentity) {
        if (userIdentity.isEnable() && !userIdentity.isDeleted()) {
            JSONObject userJson = new JSONObject();
            try {
                userJson.put("id", (Object)("@" + userIdentity.getRemoteId()));
                Object fullName = userIdentity.getProfile().getFullName();
                if (this.taskService.isExternal(userIdentity.getRemoteId())) {
                    fullName = (String)fullName + " (" + TaskUtil.getResourceBundleLabel(new Locale(TaskUtil.getUserLanguage(userIdentity.getProfile().getId())), "external.label.tag") + ")";
                }
                userJson.put("name", fullName);
                userJson.put("avatar", (Object)userIdentity.getProfile().getAvatarUrl());
                userJson.put("type", (Object)"contact");
                usersJsonArray.put((Object)userJson);
            }
            catch (JSONException e) {
                throw new IllegalStateException("Error while adding participant to JSONArray", e);
            }
        }
    }

    private static enum TaskType {
        ALL,
        INCOMING,
        OVERDUE;

    }
}

