/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.TaskUtil;

public class TaskAttachmentPlugin
extends AttachmentPlugin {
    public static final String TASK_OBJECT_TYPE = "task";
    public static final String TASK_NOT_FOUND_EXCEPTION_MESSAGE = "Task with id %s wasn't found";
    private TaskService taskService;
    private ProjectService projectService;
    private SpaceService spaceService;

    public TaskAttachmentPlugin(TaskService taskService, ProjectService projectService, SpaceService spaceService) {
        this.taskService = taskService;
        this.projectService = projectService;
        this.spaceService = spaceService;
    }

    public String getObjectType() {
        return TASK_OBJECT_TYPE;
    }

    public boolean hasAccessPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
        try {
            TaskDto task = this.taskService.getTask(Long.parseLong(entityId));
            return TaskUtil.hasViewPermission(this.taskService, task, userIdentity);
        }
        catch (Exception e) {
            throw new ObjectNotFoundException(String.format(TASK_NOT_FOUND_EXCEPTION_MESSAGE, entityId));
        }
    }

    public boolean hasEditPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
        try {
            TaskDto task = this.taskService.getTask(Long.parseLong(entityId));
            return TaskUtil.hasEditPermission(this.taskService, task, userIdentity);
        }
        catch (Exception e) {
            throw new ObjectNotFoundException(String.format(TASK_NOT_FOUND_EXCEPTION_MESSAGE, entityId));
        }
    }

    public long getAudienceId(String entityId) throws ObjectNotFoundException {
        return this.getSpaceId(entityId);
    }

    public long getSpaceId(String entityId) throws ObjectNotFoundException {
        long spaceId = 0L;
        try {
            Space space;
            TaskDto task = this.taskService.getTask(Long.parseLong(entityId));
            Space space2 = space = task.getStatus() == null || task.getStatus().getProject() == null ? null : this.getProjectSpace(task.getStatus().getProject().getId());
            if (space != null) {
                spaceId = Long.parseLong(space.getId());
            }
        }
        catch (Exception e) {
            throw new ObjectNotFoundException(String.format(TASK_NOT_FOUND_EXCEPTION_MESSAGE, entityId));
        }
        return spaceId;
    }

    private Space getProjectSpace(long projectId) {
        Space space = null;
        for (String permission : this.projectService.getManager(projectId)) {
            int index = permission.indexOf(58);
            if (index <= -1) continue;
            String groupId = permission.substring(index + 1);
            space = this.spaceService.getSpaceByGroupId(groupId);
        }
        return space;
    }
}

