/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.tasks.listener.analytics;

import io.meeds.analytics.listener.social.BaseAttachmentAnalyticsListener;
import java.util.List;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.ObjectAttachmentId;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class TaskAttachmentAnalyticsListener
extends BaseAttachmentAnalyticsListener {
    private AttachmentService attachmentService;
    private SpaceService spaceService;
    private List<String> supportedObjectType;

    public TaskAttachmentAnalyticsListener(AttachmentService attachmentService, SpaceService spaceService, InitParams initParam) {
        this.attachmentService = attachmentService;
        this.spaceService = spaceService;
        this.supportedObjectType = initParam.getValuesParam("supported-type").getValues();
    }

    protected String getModule(ObjectAttachmentId objectAttachment) {
        return "tasks";
    }

    protected String getSubModule(ObjectAttachmentId objectAttachment) {
        return switch (objectAttachment.getObjectType()) {
            case "task" -> "taskDescription";
            case "taskComment" -> "taskComment";
            default -> "task";
        };
    }

    public AttachmentService getAttachmentService() {
        return this.attachmentService;
    }

    public SpaceService getSpaceService() {
        return this.spaceService;
    }

    public List<String> getSupportedObjectType() {
        return this.supportedObjectType;
    }
}

