/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao.jpa;

import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.task.dao.CommentHandler;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Task;

public class CommentDAOImpl
extends GenericDAOJPAImpl<Comment, Long>
implements CommentHandler {
    private EntityManagerService entityService;

    public CommentDAOImpl(EntityManagerService entityService) {
        this.entityService = entityService;
    }

    public EntityManager getEntityManager() {
        return this.entityService.getEntityManager();
    }

    @Override
    public long count(Task task) {
        Long count = (Long)this.getEntityManager().createNamedQuery("Comment.countCommentOfTask", Long.class).setParameter("taskId", (Object)task.getId()).getSingleResult();
        return count;
    }

    @Override
    public List<Comment> findCommentsOfTask(Task task, int start, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Comment.findCommentsOfTask", Comment.class);
        query.setParameter("taskId", (Object)task.getId());
        if (limit > 0) {
            query.setFirstResult(start);
            query.setMaxResults(limit);
        }
        List comments = query.getResultList();
        Collections.reverse(comments);
        return comments;
    }
}

