/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao.jpa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.ProjectHandler;
import org.exoplatform.task.domain.Project;

public class ProjectDAOImpl
extends GenericDAOJPAImpl<Project, Long>
implements ProjectHandler {
    private static final Logger LOG = Logger.getLogger("ProjectDAOImpl");
    private EntityManagerService entityService;

    public ProjectDAOImpl(EntityManagerService entityService) {
        this.entityService = entityService;
    }

    public EntityManager getEntityManager() {
        return this.entityService.getEntityManager();
    }

    @Override
    public List<Project> findSubProjects(Project project) {
        EntityManager em = this.getEntityManager();
        Query query = em.createNamedQuery(project != null ? "Project.findSubProjects" : "Project.getRootProjects");
        if (project != null) {
            query.setParameter("projectId", (Object)project.getId());
        }
        return query.getResultList();
    }

    @Override
    public List<Project> findSubProjectsByMemberships(Project project, List<String> memberships) {
        EntityManager em = this.getEntityManager();
        Query query = em.createNamedQuery(project != null ? "Project.findSubProjectsByMemberships" : "Project.findRootProjectsByMemberships");
        if (project != null) {
            query.setParameter("projectId", (Object)project.getId());
        }
        query.setParameter("memberships", memberships);
        return query.getResultList();
    }

    @Override
    public List<Project> findAllByMemberships(List<String> memberships) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Project.findAllByMembership", Project.class);
        query.setParameter("memberships", memberships);
        return query.getResultList();
    }

    @Override
    public List<Project> findAllByMembershipsAndKeyword(List<String> memberships, String keyword, OrderBy order) {
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Project.class);
        Root project = q.from(Project.class);
        q.select((Selection)project);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(cb.or((Expression)project.join("manager", JoinType.LEFT).in(memberships), (Expression)project.join("participator", JoinType.LEFT).in(memberships)));
        if (keyword != null && !keyword.isEmpty()) {
            LinkedList<Predicate> keyConditions = new LinkedList<Predicate>();
            for (String k : keyword.split(" ")) {
                if ((k = k.trim()).isEmpty()) continue;
                k = "%" + k.toLowerCase() + "%";
                keyConditions.add(cb.like(cb.lower((Expression)project.get("name")), k));
            }
            predicates.add(cb.or(keyConditions.toArray(new Predicate[keyConditions.size()])));
        }
        if (predicates.size() > 0) {
            Iterator it = predicates.iterator();
            Predicate p = (Predicate)it.next();
            while (it.hasNext()) {
                p = cb.and((Expression)p, (Expression)it.next());
            }
            q.where((Expression)p);
        }
        if (order != null) {
            Path p = project.get(order.getFieldName());
            q.orderBy(new Order[]{order.isAscending() ? cb.asc((Expression)p) : cb.desc((Expression)p)});
        }
        return em.createQuery(q).getResultList();
    }
}

