/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao.jpa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;

public class TaskDAOImpl
extends GenericDAOJPAImpl<Task, Long>
implements TaskHandler {
    private EntityManagerService entityService;

    public TaskDAOImpl(EntityManagerService entityService) {
        this.entityService = entityService;
    }

    public EntityManager getEntityManager() {
        return this.entityService.getEntityManager();
    }

    @Override
    public List<Task> findByProject(Long projectId) {
        EntityManager em = this.getEntityManager();
        TypedQuery query = em.createNamedQuery("Task.findTaskByProject", Task.class);
        query.setParameter("projectId", (Object)projectId);
        return query.getResultList();
    }

    @Override
    public List<Task> findByUser(String user) {
        ArrayList<String> memberships = new ArrayList<String>();
        memberships.add(user);
        return this.findAllByMembership(user, memberships);
    }

    @Override
    public List<Task> findAllByMembership(String user, List<String> memberships) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.findByMemberships", Task.class);
        query.setParameter("userName", (Object)user);
        query.setParameter("memberships", memberships);
        return query.getResultList();
    }

    @Override
    public List<Task> findByTag(String tag) {
        return null;
    }

    @Override
    public List<Task> findByTags(List<String> tags) {
        return null;
    }

    @Override
    public List<Task> findTaskByQuery(TaskQuery query) {
        Root p;
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Task.class);
        Root task = q.from(Task.class);
        q.select((Selection)task);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (query.getTaskId() > 0L) {
            predicates.add(cb.equal((Expression)task.get("id"), (Object)query.getTaskId()));
        }
        if (query.getTitle() != null && !query.getTitle().isEmpty()) {
            predicates.add(cb.like((Expression)task.get("title"), "%" + query.getTitle() + "%"));
        }
        if (query.getDescription() != null && !query.getDescription().isEmpty()) {
            predicates.add(cb.like((Expression)task.get("description"), '%' + query.getDescription() + '%'));
        }
        Predicate assignPred = null;
        if (query.getAssignee() != null && !query.getAssignee().isEmpty()) {
            assignPred = cb.like((Expression)task.get("assignee"), '%' + query.getAssignee() + '%');
        }
        Predicate msPred = null;
        if (query.getMemberships() != null) {
            Subquery subm = q.subquery(Long.class);
            Root m = subm.from(Status.class);
            subm.select((Expression)m.get("id")).where((Expression)m.join("project").join("manager").in(query.getMemberships()));
            Subquery subp = q.subquery(Long.class);
            p = subp.from(Status.class);
            subp.select((Expression)p.get("id")).where((Expression)p.join("project").join("participator").in(query.getMemberships()));
            msPred = cb.or((Expression)cb.in((Expression)task.get("status").get("id")).value((Expression)subm), (Expression)cb.in((Expression)task.get("status").get("id")).value((Expression)subp));
        }
        Predicate projectPred = null;
        if (query.getProjectIds() != null) {
            if (query.getProjectIds().size() == 1 && query.getProjectIds().get(0) == 0L) {
                projectPred = cb.isNotNull((Expression)task.get("status"));
            } else {
                if (query.getProjectIds().isEmpty()) {
                    return Collections.emptyList();
                }
                Subquery subp = q.subquery(Long.class);
                Root p2 = subp.from(Status.class);
                subp.select((Expression)p2.get("id")).where((Expression)p2.join("project").get("id").in(query.getProjectIds()));
                projectPred = cb.in((Expression)task.get("status").get("id")).value((Expression)subp);
            }
        }
        LinkedList<Predicate> tmp = new LinkedList<Predicate>();
        for (String or : query.getOrFields()) {
            if (or.equals("assignee")) {
                tmp.add(assignPred);
            }
            if (or.equals("membership")) {
                tmp.add(msPred);
            }
            if (!or.equals("project")) continue;
            tmp.add(projectPred);
        }
        if (!tmp.isEmpty()) {
            predicates.add(cb.or(tmp.toArray(new Predicate[tmp.size()])));
        }
        if (!query.getOrFields().contains("assignee") && assignPred != null) {
            predicates.add(assignPred);
        }
        if (!query.getOrFields().contains("membership") && msPred != null) {
            predicates.add(msPred);
        }
        if (!query.getOrFields().contains("project") && projectPred != null) {
            predicates.add(projectPred);
        }
        if (query.getKeyword() != null && !query.getKeyword().isEmpty()) {
            LinkedList<Predicate> keyConditions = new LinkedList<Predicate>();
            Join tagJoin = task.join("tag", JoinType.LEFT);
            for (String k : query.getKeyword().split(" ")) {
                if ((k = k.trim()).isEmpty()) continue;
                k = "%" + k.toLowerCase() + "%";
                keyConditions.add(cb.or(new Predicate[]{cb.like(cb.lower((Expression)task.get("title")), k), cb.like(cb.lower((Expression)task.get("description")), k), cb.like(cb.lower((Expression)task.get("assignee")), k), cb.like(cb.lower((Expression)tagJoin), k)}));
            }
            predicates.add(cb.or(keyConditions.toArray(new Predicate[keyConditions.size()])));
        }
        if (query.getCompleted() != null) {
            if (query.getCompleted().booleanValue()) {
                predicates.add(cb.equal((Expression)task.get("completed"), (Object)query.getCompleted()));
            } else {
                predicates.add(cb.notEqual((Expression)task.get("completed"), (Object)(query.getCompleted() == false ? 1 : 0)));
            }
        }
        if (query.getCalendarIntegrated() != null) {
            if (query.getCalendarIntegrated().booleanValue()) {
                predicates.add(cb.equal((Expression)task.get("calendarIntegrated"), (Object)query.getCalendarIntegrated()));
            } else {
                predicates.add(cb.notEqual((Expression)task.get("calendarIntegrated"), (Object)(query.getCalendarIntegrated() == false ? 1 : 0)));
            }
        }
        if (query.getStartDate() != null) {
            predicates.add(cb.greaterThanOrEqualTo((Expression)task.get("endDate"), (Comparable)query.getStartDate()));
        }
        if (query.getEndDate() != null) {
            predicates.add(cb.lessThanOrEqualTo((Expression)task.get("startDate"), (Comparable)query.getEndDate()));
        }
        if (predicates.size() > 0) {
            Iterator it = predicates.iterator();
            p = (Predicate)it.next();
            while (it.hasNext()) {
                p = cb.and((Expression)p, (Expression)it.next());
            }
            q.where((Expression)p);
        }
        if (query.getOrderBy() != null && !query.getOrderBy().isEmpty()) {
            List<OrderBy> orderBies = query.getOrderBy();
            Order[] orders = new Order[orderBies.size()];
            for (int i = 0; i < orders.length; ++i) {
                OrderBy orderBy = orderBies.get(i);
                Path p3 = task.get(orderBy.getFieldName());
                orders[i] = orderBy.isAscending() ? cb.asc((Expression)p3) : cb.desc((Expression)p3);
            }
            q.orderBy(orders);
        }
        return em.createQuery(q).getResultList();
    }

    @Override
    public List<Task> getIncomingTask(String username, OrderBy orderBy) {
        StringBuilder jql = new StringBuilder();
        jql.append("SELECT ta FROM Task ta LEFT JOIN ta.coworker cowoker ").append("WHERE ta.status.id is null ").append("AND (ta.assignee = :userName OR ta.createdBy = :userName OR cowoker = :userName)").append(" AND ta.completed = FALSE");
        if (orderBy != null && !orderBy.getFieldName().isEmpty()) {
            jql.append(" ORDER BY ta.").append(orderBy.getFieldName()).append(" ").append(orderBy.isAscending() ? "ASC" : " DESC");
        }
        return this.getEntityManager().createQuery(jql.toString(), Task.class).setParameter("userName", (Object)username).getResultList();
    }

    @Override
    public List<Task> getToDoTask(String username, List<Long> projectIds, OrderBy orderBy, Date fromDueDate, Date toDueDate) {
        StringBuilder jql = new StringBuilder();
        jql.append("SELECT ta FROM Task ta LEFT JOIN ta.status st ").append("WHERE ta.assignee = :userName ").append("AND ta.completed = FALSE ");
        if (fromDueDate != null || toDueDate != null) {
            jql.append("AND ta.dueDate IS NOT NULL ");
        }
        if (projectIds != null && !projectIds.isEmpty()) {
            jql.append("AND ta.status.project.id IN (:projectIds) ");
        }
        if (fromDueDate != null) {
            jql.append("AND ta.dueDate >= :fromDueDate ");
        }
        if (toDueDate != null) {
            jql.append("AND ta.dueDate <= :toDueDate ");
        }
        if (orderBy != null && !orderBy.getFieldName().isEmpty()) {
            String fieldName = orderBy.getFieldName();
            fieldName = fieldName.startsWith("status.") ? fieldName.replace("status.", "st.") : "ta." + fieldName;
            jql.append(" ORDER BY ").append(fieldName).append(" ").append(orderBy.isAscending() ? "ASC" : " DESC");
        }
        TypedQuery query = this.getEntityManager().createQuery(jql.toString(), Task.class);
        query.setParameter("userName", (Object)username);
        if (projectIds != null && !projectIds.isEmpty()) {
            query.setParameter("projectIds", projectIds);
        }
        if (fromDueDate != null) {
            query.setParameter("fromDueDate", (Object)fromDueDate);
        }
        if (toDueDate != null) {
            query.setParameter("toDueDate", (Object)toDueDate);
        }
        return query.getResultList();
    }

    @Override
    public Task findTaskByActivityId(String activityId) {
        if (activityId == null || activityId.isEmpty()) {
            return null;
        }
        EntityManager em = this.getEntityManager();
        TypedQuery query = em.createNamedQuery("Task.findTaskByActivityId", Task.class);
        query.setParameter("activityId", (Object)activityId);
        try {
            return (Task)query.getSingleResult();
        }
        catch (PersistenceException e) {
            return null;
        }
    }

    @Override
    public long getTaskNum(String userName, List<Long> projectIds) {
        if (userName == null && (projectIds == null || projectIds.isEmpty())) {
            return 0L;
        }
        StringBuilder jql = new StringBuilder();
        jql.append("SELECT count(*) FROM Task ta");
        if (userName != null) {
            jql.append(" LEFT JOIN ta.coworker cowoker ");
        }
        jql.append(" WHERE ");
        if (userName != null) {
            jql.append("(ta.assignee = :userName OR ta.createdBy = :userName OR cowoker = :userName)");
            if (projectIds != null && !projectIds.isEmpty() && projectIds.get(0) != -2L) {
                jql.append(" AND");
            }
        }
        boolean needParam = false;
        if (projectIds != null && !projectIds.isEmpty()) {
            if (projectIds.size() == 1 && projectIds.get(0) <= 0L) {
                if (projectIds.get(0) == 0L) {
                    jql.append(" NOT ta.status is null");
                } else if (projectIds.get(0) == -1L) {
                    jql.append(" ta.status is null");
                }
            } else {
                needParam = true;
                jql.append(" ta.status.project.id IN (:projectIds)");
            }
        }
        Query query = this.getEntityManager().createQuery(jql.toString());
        if (userName != null) {
            query.setParameter("userName", (Object)userName);
        }
        if (needParam) {
            query.setParameter("projectIds", projectIds);
        }
        return (Long)query.getSingleResult();
    }

    @Override
    public void updateTaskOrder(long currentTaskId, Status newStatus, long[] orders) {
        int currentTaskIndex = -1;
        for (int i = 0; i < orders.length; ++i) {
            if (orders[i] != currentTaskId) continue;
            currentTaskIndex = i;
            break;
        }
        if (currentTaskIndex == -1) {
            return;
        }
        Task currentTask = (Task)this.find(Long.valueOf(currentTaskId));
        Task prevTask = null;
        Task nextTask = null;
        if (currentTaskIndex < orders.length - 1) {
            prevTask = (Task)this.find(Long.valueOf(orders[currentTaskIndex + 1]));
        }
        if (currentTaskIndex > 0) {
            nextTask = (Task)this.find(Long.valueOf(orders[currentTaskIndex - 1]));
        }
        int oldRank = currentTask.getRank();
        int prevRank = prevTask != null ? prevTask.getRank() : 0;
        int nextRank = nextTask != null ? nextTask.getRank() : 0;
        int newRank = prevRank + 1;
        if (newStatus != null && currentTask.getStatus().getId() != newStatus.getId()) {
            oldRank = 0;
            currentTask.setStatus(newStatus);
        }
        EntityManager em = this.getEntityManager();
        StringBuilder sql = null;
        if (newRank == 1 || oldRank == 0) {
            int increment = 1;
            StringBuilder exclude = new StringBuilder();
            if (nextRank == 0) {
                Task task;
                for (int i = currentTaskIndex - 1; i >= 0 && (task = (Task)this.find(Long.valueOf(orders[i]))).getRank() <= 0; --i) {
                    task.setRank(newRank + currentTaskIndex - i);
                    this.update(task);
                    if (exclude.length() > 0) {
                        exclude.append(',');
                    }
                    exclude.append(task.getId());
                    ++increment;
                }
            }
            sql = new StringBuilder("UPDATE Task as ta SET ta.rank = ta.rank + ").append(increment).append(" WHERE ta.rank >= ").append(newRank);
            if (exclude.length() > 0) {
                sql.append(" AND ta.id NOT IN (").append(exclude.toString()).append(")");
            }
        } else if (oldRank < newRank) {
            sql = new StringBuilder("UPDATE Task as ta SET ta.rank = ta.rank - 1").append(" WHERE ta.rank > ").append(oldRank).append(" AND ta.rank < ").append(newRank);
            --newRank;
        } else if (oldRank > newRank) {
            sql = new StringBuilder("UPDATE Task as ta SET ta.rank = ta.rank + 1").append(" WHERE ta.rank >= ").append(newRank).append(" AND ta.rank < ").append(oldRank);
            ++newRank;
        }
        if (sql != null && sql.length() > 0) {
            sql.append(" AND ta.completed = FALSE AND ta.status.id = ").append(currentTask.getStatus().getId());
            EntityTransaction trans = em.getTransaction();
            boolean active = false;
            if (!trans.isActive()) {
                trans.begin();
                active = true;
            }
            em.createQuery(sql.toString()).executeUpdate();
            if (active) {
                trans.commit();
            }
        }
        currentTask.setRank(newRank);
        this.update(currentTask);
    }
}

