/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.utils.ProjectUtil;
import org.exoplatform.task.utils.ResourceUtil;
import org.exoplatform.task.utils.StringUtil;
import org.exoplatform.web.WebAppController;

public class ProjectSearchConnector
extends SearchServiceConnector {
    private ProjectService projectService;
    private WebAppController controller;

    public ProjectSearchConnector(InitParams initParams, ProjectService projectService, WebAppController controller) {
        super(initParams);
        this.projectService = projectService;
        this.controller = controller;
    }

    public Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        if (query == null || query.trim().isEmpty()) {
            return result;
        }
        query = StringUtil.FUZZY.matcher(query.trim()).replaceAll("");
        Identity currentUser = ConversationState.getCurrent().getIdentity();
        List<Project> projects = this.projectService.findProjectByKeyWord(currentUser, query, this.buildOrderBy(sort, order));
        for (Project p : projects) {
            result.add(this.buildResult(p));
        }
        return ResourceUtil.subList(result, offset, limit);
    }

    private SearchResult buildResult(Project p) {
        String detail = p.getDescription();
        String url = this.buildUrl(p);
        String imageUrl = this.buildImageUrl(p);
        return new SearchResult(url, p.getName(), "", detail, imageUrl, p.getDueDate().getTime(), 0L);
    }

    private String buildImageUrl(Project p) {
        return null;
    }

    private String buildUrl(Project p) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return ProjectUtil.buildProjectURL(p, SiteKey.portal((String)"intranet"), container, this.controller.getRouter());
    }

    private OrderBy buildOrderBy(String sort, String order) {
        String orderBy = null;
        if ("date".equals(sort)) {
            orderBy = "dueDate";
        } else if ("title".equals(sort)) {
            orderBy = "name";
        }
        if (orderBy != null) {
            if ("asc".equals(order)) {
                return new OrderBy.ASC(orderBy);
            }
            return new OrderBy.DESC(orderBy);
        }
        return null;
    }
}

