/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.calendar;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.calendar.model.Calendar;
import org.exoplatform.calendar.model.query.CalendarQuery;
import org.exoplatform.calendar.storage.CalendarDAO;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.utils.ProjectUtil;
import org.exoplatform.task.utils.UserUtils;

public class TasksCalendarDAOImpl
implements CalendarDAO {
    private ProjectService projectService;
    private static final Log LOG = ExoLogger.getExoLogger(TasksCalendarDAOImpl.class);
    public final Calendar DF_CALENDAR = this.newInstance();

    public TasksCalendarDAOImpl(ProjectService projectService) {
        this.DF_CALENDAR.setId(String.valueOf(-2));
        this.DF_CALENDAR.setHasChildren(true);
        this.DF_CALENDAR.setName("Tasks");
        this.projectService = projectService;
    }

    public Calendar getById(String id) {
        try {
            Calendar cal = this.newInstance();
            if (this.DF_CALENDAR.getId().equals(id)) {
                return this.DF_CALENDAR;
            }
            Project project = this.projectService.getProjectById(Long.valueOf(id));
            if (project.isCalendarIntegrated()) {
                return ProjectUtil.buildCalendar(cal, project);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Exception while loading calendar by ID", (Throwable)ex);
        }
        return null;
    }

    public List<Calendar> findCalendars(CalendarQuery query) {
        Identity identity = query.getIdentity();
        List<String> permissions = UserUtils.getMemberships(identity);
        List<Project> projects = this.projectService.getProjectTreeByMembership(permissions);
        projects = ProjectUtil.flattenTree(projects);
        if (query.getExclusions() != null) {
            projects = this.filterExclusions(projects, query.getExclusions());
        }
        LinkedList<Calendar> calendars = new LinkedList<Calendar>();
        if (query.getExclusions() == null || !Arrays.asList(query.getExclusions()).contains(this.DF_CALENDAR.getId())) {
            calendars.add(this.DF_CALENDAR);
        }
        for (Project p : projects) {
            if (!p.isCalendarIntegrated()) continue;
            Calendar cal = this.newInstance();
            calendars.add(ProjectUtil.buildCalendar(cal, p));
        }
        return calendars;
    }

    private List<Project> filterExclusions(List<Project> projects, String[] excludesId) {
        for (String id : excludesId) {
            Iterator<Project> iter = projects.iterator();
            while (iter.hasNext()) {
                Project p = iter.next();
                if (p.getId() != Long.valueOf(id).longValue()) continue;
                iter.remove();
            }
        }
        return projects;
    }

    public Calendar save(Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    public Calendar update(Calendar cal) {
        throw new UnsupportedOperationException();
    }

    public Calendar remove(String id) {
        throw new UnsupportedOperationException();
    }

    public Calendar newInstance() {
        Calendar c = new Calendar("");
        c.setDS("tasks");
        return c;
    }
}

