/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.exception.TaskNotFoundException;
import org.exoplatform.task.service.TaskListener;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.impl.TaskEvent;

public class TaskLoggingListener
implements TaskListener {
    private static final Log LOG = ExoLogger.getExoLogger(TaskLoggingListener.class);

    @Override
    public void event(TaskEvent event) {
        TaskService service = event.getContext();
        String username = ConversationState.getCurrent().getIdentity().getUserId();
        String[] msg = this.getMsg(event);
        try {
            if (msg[0] != null) {
                service.addTaskLog(event.getTask().getId(), username, msg[0], msg[1]);
            }
        }
        catch (TaskNotFoundException e) {
            LOG.error((Object)e);
        }
    }

    private String[] getMsg(TaskEvent event) {
        String msg;
        String val = "";
        TaskEvent.Type type = event.getType();
        switch (type) {
            case CREATED: {
                msg = "log.created";
                break;
            }
            case ADD_LABEL: {
                msg = "log.add_label";
                val = StringUtils.join((Collection)((Set)event.getNewVal()), (String)",");
                break;
            }
            case ADD_SUBTASK: {
                msg = "log.add_subtask";
                break;
            }
            case EDIT_ASSIGNEE: {
                if (event.getNewVal() != null) {
                    msg = "log.assign";
                    val = event.getNewVal().toString();
                    break;
                }
                msg = "log.unassign";
                val = event.getOldVal().toString();
                break;
            }
            case EDIT_DESCRIPTION: {
                msg = "log.edit_description";
                break;
            }
            case EDIT_DUEDATE: {
                msg = "log.edit_duedate";
                break;
            }
            case EDIT_PROJECT: {
                msg = "log.edit_project";
                val = ((Project)event.getNewVal()).getName();
                break;
            }
            case EDIT_STATUS: {
                msg = "log.edit_status";
                val = ((Status)event.getNewVal()).getName();
                break;
            }
            case EDIT_TITLE: {
                msg = "log.edit_title";
                break;
            }
            case EDIT_WORKPLAN: {
                msg = "log.edit_workplan";
                break;
            }
            case MARK_DONE: {
                if (Boolean.TRUE.equals(event.getNewVal())) {
                    msg = "log.mark_done";
                    break;
                }
                msg = null;
                break;
            }
            default: {
                throw new IllegalArgumentException(type.name() + " event not support");
            }
        }
        return new String[]{msg, val};
    }
}

