/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.task.domain.Task;

@Entity(name="TaskComment")
@ExoEntity
@Table(name="TASK_COMMENTS")
@NamedQueries(value={@NamedQuery(name="Comment.countCommentOfTask", query="SELECT count(c) FROM TaskComment c WHERE c.task.id = :taskId"), @NamedQuery(name="Comment.findCommentsOfTask", query="SELECT c FROM TaskComment c WHERE c.task.id = :taskId ORDER BY c.createdTime DESC"), @NamedQuery(name="Comment.deleteCommentOfTask", query="DELETE FROM TaskComment c WHERE c.task.id = :taskId")})
public class Comment {
    @Id
    @SequenceGenerator(name="SEQ_TASK_COMMENTS_COMMENT_ID", sequenceName="SEQ_TASK_COMMENTS_COMMENT_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TASK_COMMENTS_COMMENT_ID")
    @Column(name="COMMENT_ID")
    private long id;
    private String author;
    @Column(name="CMT")
    private String comment;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED_TIME")
    private Date createdTime;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TASK_ID")
    private Task task;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public Comment clone() {
        Comment c = new Comment();
        c.setId(this.getId());
        c.setAuthor(this.getAuthor());
        c.setComment(this.getComment());
        c.setCreatedTime(this.getCreatedTime());
        c.setTask(this.getTask().clone());
        return c;
    }
}

