/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.ChangeLog;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.LabelTaskMapping;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.TaskPayload;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure1;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure11;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure13;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure15;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure17;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure19;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure21;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure23;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure25;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure27;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure3;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure5;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure7;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure9;

@Singleton
public class TaskServiceImpl
implements TaskService {
    private static final Log LOG;
    private static final Pattern pattern;
    @Inject
    private DAOHandler daoHandler;
    private ListenerService listenerService;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    public TaskServiceImpl(DAOHandler daoHandler, ListenerService listenerService) {
        this.daoHandler = daoHandler;
        this.listenerService = listenerService;
    }

    @Override
    @ExoTransactional
    public Task createTask(Task task) {
        Task task2 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)task2);
        Object[] objectArray = new Object[]{this, task2, joinPoint};
        return (Task)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Task updateTask(Task task) {
        Task task2 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)task2);
        Object[] objectArray = new Object[]{this, task2, joinPoint};
        return (Task)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void updateTaskOrder(long currentTaskId, Status newStatus, long[] orders) {
        long l = currentTaskId;
        Status status = newStatus;
        long[] lArray = orders;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l), status, lArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.longObject((long)l), status, lArray, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeTask(long id) throws EntityNotFoundException {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Task cloneTask(long id) throws EntityNotFoundException {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        return (Task)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public Task getTask(long id) throws EntityNotFoundException {
        Task task = (Task)this.daoHandler.getTaskHandler().find(Long.valueOf(id));
        if (task == null) {
            LOG.info((Object)("Can not find task with ID: " + id));
            throw new EntityNotFoundException(id, (Class<?>)Task.class);
        }
        return task;
    }

    @Override
    public Comment getComment(long commentId) {
        Comment comment = (Comment)this.daoHandler.getCommentHandler().find(Long.valueOf(commentId));
        comment.setComment(this.substituteUsernames(comment.getComment()));
        return comment;
    }

    @Override
    public ListAccess<Comment> getComments(long taskId) {
        return this.daoHandler.getCommentHandler().findComments(taskId);
    }

    @Override
    public void loadSubComments(List<Comment> listComments) {
        if (listComments == null || listComments.isEmpty()) {
            return;
        }
        listComments.forEach(comment -> comment.setComment(this.substituteUsernames(comment.getComment())));
        List<Comment> subComments = this.daoHandler.getCommentHandler().getSubComments(listComments);
        for (Comment comment2 : listComments) {
            subComments.forEach(subComment -> subComment.setComment(this.substituteUsernames(subComment.getComment())));
            comment2.setSubComments(subComments.stream().filter(subComment -> subComment.getParentComment().getId() == comment2.getId()).collect(Collectors.toList()));
        }
    }

    @Override
    public Set<String> getMentionedUsers(long taskId) {
        return this.daoHandler.getCommentHandler().findMentionedUsersOfTask(taskId);
    }

    @Override
    @ExoTransactional
    public Comment addComment(long id, long parentCommentId, String username, String comment) throws EntityNotFoundException {
        long l = id;
        long l2 = parentCommentId;
        String string = username;
        String string2 = comment;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l), Conversions.longObject((long)l2), string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.longObject((long)l), Conversions.longObject((long)l2), string, string2, joinPoint};
        return (Comment)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure11(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Comment addComment(long id, String username, String comment) throws EntityNotFoundException {
        long l = id;
        String string = username;
        String string2 = comment;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l), string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.longObject((long)l), string, string2, joinPoint};
        return (Comment)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure13(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public ChangeLog addTaskLog(long id, String username, String actionName, String target) throws EntityNotFoundException {
        long l = id;
        String string = username;
        String string2 = actionName;
        String string3 = target;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l), string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.longObject((long)l), string, string2, string3, joinPoint};
        return (ChangeLog)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure15(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    public ListAccess<ChangeLog> getTaskLogs(long taskId) {
        return this.daoHandler.getTaskLogHandler().findTaskLogs(taskId);
    }

    @Override
    @ExoTransactional
    public void removeComment(long commentId) throws EntityNotFoundException {
        long l = commentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public ListAccess<Task> findTasks(TaskQuery query) {
        return this.daoHandler.getTaskHandler().findTasks(query);
    }

    @Override
    public <T> List<T> selectTaskField(TaskQuery query, String fieldName) {
        return this.daoHandler.getTaskHandler().selectTaskField(query, fieldName);
    }

    @Override
    @ExoTransactional
    public void addTaskToLabel(Long taskId, Long labelId) throws EntityNotFoundException {
        Long l = taskId;
        Long l2 = labelId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)l, (Object)l2);
        Object[] objectArray = new Object[]{this, l, l2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeTaskFromLabel(Long taskId, Long labelId) throws EntityNotFoundException {
        Long l = taskId;
        Long l2 = labelId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)l, (Object)l2);
        Object[] objectArray = new Object[]{this, l, l2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public ListAccess<Task> findTasksByLabel(long labelId, List<Long> projectIds, String username, OrderBy orderBy) throws EntityNotFoundException {
        Label label;
        if (labelId > 0L && (label = this.getLabel(labelId)) == null) {
            throw new EntityNotFoundException(labelId, (Class<?>)Label.class);
        }
        return this.daoHandler.getTaskHandler().findTasksByLabel(labelId, projectIds, username, orderBy);
    }

    @Override
    public ListAccess<Label> findLabelsByUser(String username) {
        return this.daoHandler.getLabelHandler().findLabelsByUser(username);
    }

    @Override
    public ListAccess<Label> findLabelsByTask(long taskId, String username) throws EntityNotFoundException {
        return this.daoHandler.getLabelHandler().findLabelsByTask(taskId, username);
    }

    @Override
    public Label getLabel(long labelId) {
        return (Label)this.daoHandler.getLabelHandler().find(Long.valueOf(labelId));
    }

    @Override
    @ExoTransactional
    public Label createLabel(Label label) {
        Label label2 = label;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)label2);
        Object[] objectArray = new Object[]{this, label2, joinPoint};
        return (Label)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Label updateLabel(Label label, List<Label.FIELDS> fields) throws EntityNotFoundException {
        Label label2 = label;
        List<Label.FIELDS> list = fields;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)label2, list);
        Object[] objectArray = new Object[]{this, label2, list, joinPoint};
        return (Label)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure25(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeLabel(long labelId) {
        long l = labelId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure27(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public Task findTaskByActivityId(String id) {
        return this.daoHandler.getTaskHandler().findTaskByActivityId(id);
    }

    @Override
    public Set<String> getCoworker(long taskId) {
        return this.daoHandler.getTaskHandler().getCoworker(taskId);
    }

    @Override
    public List<Task> getUncompletedTasks(String user, int limit) {
        return this.daoHandler.getTaskHandler().getUncompletedTasks(user, limit);
    }

    @Override
    public Long countUncompletedTasks(String user) {
        return this.daoHandler.getTaskHandler().countUncompletedTasks(user);
    }

    @Override
    public List<Task> findTasks(String user, String query, int limit) {
        if (StringUtils.isBlank((CharSequence)user)) {
            throw new IllegalArgumentException("user parameter is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            throw new IllegalArgumentException("query parameter is mandatory");
        }
        return this.daoHandler.getTaskHandler().findTasks(user, query, limit);
    }

    @Override
    public long countTasks(String user, String query) {
        if (StringUtils.isBlank((CharSequence)user)) {
            throw new IllegalArgumentException("user parameter is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            throw new IllegalArgumentException("query parameter is mandatory");
        }
        return this.daoHandler.getTaskHandler().countTasks(user, query);
    }

    @Override
    public ListAccess<Task> getIncomingTasks(String user) {
        return this.daoHandler.getTaskHandler().getIncomingTasks(user);
    }

    @Override
    public List<Task> getOverdueTasks(String user, int limit) {
        return this.daoHandler.getTaskHandler().getOverdueTasks(user, limit);
    }

    @Override
    public Long countOverdueTasks(String user) {
        return this.daoHandler.getTaskHandler().countOverdueTasks(user);
    }

    @Override
    public void addWatcherToTask(String user, Task task) throws Exception {
        this.daoHandler.getTaskHandler().addWatcherToTask(user, task);
    }

    @Override
    public void deleteWatcherOfTask(String user, Task task) throws Exception {
        this.daoHandler.getTaskHandler().deleteWatcherOfTask(user, task);
    }

    @Override
    public Set<String> getWatchersOfTask(Task task) {
        return this.daoHandler.getTaskHandler().getWatchersOfTask(task);
    }

    private String substituteUsernames(String message) {
        if (message == null || message.trim().isEmpty()) {
            return message;
        }
        Matcher matcher = pattern.matcher(message);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            Identity identity;
            String username = matcher.group().substring(1);
            if (username == null || username.isEmpty() || (identity = LinkProvider.getIdentityManager().getOrCreateIdentity("organization", username, false)) == null || identity.isDeleted() || !identity.isEnable()) continue;
            try {
                username = LinkProvider.getProfileLink((String)username, (String)"dw");
            }
            catch (Exception e) {
                continue;
            }
            if (username == null) continue;
            matcher.appendReplacement(buf, username);
        }
        if (buf.length() > 0) {
            matcher.appendTail(buf);
            return buf.toString();
        }
        return message;
    }

    static {
        TaskServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(TaskServiceImpl.class);
        pattern = Pattern.compile("@([^\\s]+)|@([^\\s]+)$");
    }

    static /* synthetic */ Task createTask_aroundBody0(TaskServiceImpl ajc$this, Task task, JoinPoint joinPoint) {
        Task result = (Task)ajc$this.daoHandler.getTaskHandler().create(task);
        TaskPayload event = new TaskPayload(null, result);
        try {
            ajc$this.listenerService.broadcast("exo.task.taskCreation", (Object)ajc$this, (Object)event);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while broadcasting task creation event", (Throwable)e);
        }
        return result;
    }

    static /* synthetic */ Task updateTask_aroundBody2(TaskServiceImpl ajc$this, Task task, JoinPoint joinPoint) {
        if (task == null) {
            throw new IllegalArgumentException("Task must not be NULL");
        }
        Task oldTask = ajc$this.daoHandler.getTaskHandler().getTaskWithCoworkers(task.getId());
        Task newTask = (Task)ajc$this.daoHandler.getTaskHandler().update(task);
        TaskPayload event = new TaskPayload(oldTask, newTask);
        try {
            ajc$this.listenerService.broadcast("exo.task.taskUpdate", (Object)ajc$this, (Object)event);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while broadcasting task creation event", (Throwable)e);
        }
        return newTask;
    }

    static /* synthetic */ void updateTaskOrder_aroundBody4(TaskServiceImpl ajc$this, long currentTaskId, Status newStatus, long[] orders, JoinPoint joinPoint) {
        ajc$this.daoHandler.getTaskHandler().updateTaskOrder(currentTaskId, newStatus, orders);
    }

    static /* synthetic */ void removeTask_aroundBody6(TaskServiceImpl ajc$this, long id, JoinPoint joinPoint) {
        Task task = ajc$this.getTask(id);
        ajc$this.daoHandler.getTaskHandler().delete(task);
    }

    static /* synthetic */ Task cloneTask_aroundBody8(TaskServiceImpl ajc$this, long id, JoinPoint joinPoint) {
        Task task = ajc$this.getTask(id);
        Task newTask = task.clone();
        newTask.setId(0L);
        newTask.setCoworker(ajc$this.getCoworker(id));
        newTask.setTitle("Copy of " + newTask.getTitle());
        return ajc$this.createTask(newTask);
    }

    static /* synthetic */ Comment addComment_aroundBody10(TaskServiceImpl ajc$this, long id, long parentCommentId, String username, String comment, JoinPoint joinPoint) {
        Task task = ajc$this.getTask(id);
        Comment newComment = new Comment();
        newComment.setTask(task);
        newComment.setAuthor(username);
        newComment.setComment(comment);
        newComment.setCreatedTime(new Date());
        if (parentCommentId > 0L) {
            Comment parentComment = (Comment)ajc$this.daoHandler.getCommentHandler().find(Long.valueOf(parentCommentId));
            if (parentComment.getParentComment() != null) {
                parentComment = parentComment.getParentComment();
            }
            newComment.setParentComment(parentComment);
        }
        Comment obj = (Comment)ajc$this.daoHandler.getCommentHandler().create(newComment);
        try {
            ajc$this.listenerService.broadcast("exo.task.taskCommentCreation", (Object)ajc$this, (Object)obj);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while broadcasting task creation event", (Throwable)e);
        }
        return obj;
    }

    static /* synthetic */ Comment addComment_aroundBody12(TaskServiceImpl ajc$this, long id, String username, String comment, JoinPoint joinPoint) {
        return ajc$this.addComment(id, 0L, username, comment);
    }

    static /* synthetic */ ChangeLog addTaskLog_aroundBody14(TaskServiceImpl ajc$this, long id, String username, String actionName, String target, JoinPoint joinPoint) {
        ChangeLog log = new ChangeLog();
        log.setTask(ajc$this.getTask(id));
        log.setAuthor(username);
        log.setActionName(actionName);
        log.setTarget(target);
        return (ChangeLog)ajc$this.daoHandler.getTaskLogHandler().create(log);
    }

    static /* synthetic */ void removeComment_aroundBody16(TaskServiceImpl ajc$this, long commentId, JoinPoint joinPoint) {
        Comment comment = (Comment)ajc$this.daoHandler.getCommentHandler().find(Long.valueOf(commentId));
        if (comment == null) {
            LOG.info((Object)("Can not find comment with ID: " + commentId));
            throw new EntityNotFoundException(commentId, (Class<?>)Comment.class);
        }
        ajc$this.daoHandler.getCommentHandler().delete(comment);
    }

    static /* synthetic */ void addTaskToLabel_aroundBody18(TaskServiceImpl ajc$this, Long taskId, Long labelId, JoinPoint joinPoint) {
        LabelTaskMapping mapping = new LabelTaskMapping();
        mapping.setLabel(ajc$this.getLabel(labelId));
        mapping.setTask(ajc$this.getTask(taskId));
        ajc$this.daoHandler.getLabelTaskMappingHandler().create(mapping);
    }

    static /* synthetic */ void removeTaskFromLabel_aroundBody20(TaskServiceImpl ajc$this, Long taskId, Long labelId, JoinPoint joinPoint) {
        LabelTaskMapping mapping = new LabelTaskMapping();
        mapping.setLabel(ajc$this.getLabel(labelId));
        mapping.setTask(ajc$this.getTask(taskId));
        ajc$this.daoHandler.getLabelTaskMappingHandler().delete(mapping);
    }

    static /* synthetic */ Label createLabel_aroundBody22(TaskServiceImpl ajc$this, Label label, JoinPoint joinPoint) {
        return (Label)ajc$this.daoHandler.getLabelHandler().create(label);
    }

    static /* synthetic */ Label updateLabel_aroundBody24(TaskServiceImpl ajc$this, Label label, List fields, JoinPoint joinPoint) {
        Label lb = ajc$this.getLabel(label.getId());
        if (lb == null) {
            throw new EntityNotFoundException(label.getId(), (Class<?>)Label.class);
        }
        for (Label.FIELDS field : fields) {
            switch (field) {
                case NAME: {
                    lb.setName(label.getName());
                    break;
                }
                case COLOR: {
                    lb.setColor(label.getColor());
                    break;
                }
                case PARENT: {
                    lb.setParent(label.getParent());
                    break;
                }
                case HIDDEN: {
                    lb.setHidden(label.isHidden());
                }
            }
        }
        return (Label)ajc$this.daoHandler.getLabelHandler().update(lb);
    }

    static /* synthetic */ void removeLabel_aroundBody26(TaskServiceImpl ajc$this, long labelId, JoinPoint joinPoint) {
        ajc$this.daoHandler.getLabelHandler().delete(ajc$this.getLabel(labelId));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskServiceImpl.java", TaskServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTask", "org.exoplatform.task.service.impl.TaskServiceImpl", "org.exoplatform.task.domain.Task", "task", "", "org.exoplatform.task.domain.Task"), 78);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTask", "org.exoplatform.task.service.impl.TaskServiceImpl", "org.exoplatform.task.domain.Task", "task", "", "org.exoplatform.task.domain.Task"), 93);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeTaskFromLabel", "org.exoplatform.task.service.impl.TaskServiceImpl", "java.lang.Long:java.lang.Long", "taskId:labelId", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 266);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createLabel", "org.exoplatform.task.service.impl.TaskServiceImpl", "org.exoplatform.task.domain.Label", "label", "", "org.exoplatform.task.domain.Label"), 301);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateLabel", "org.exoplatform.task.service.impl.TaskServiceImpl", "org.exoplatform.task.domain.Label:java.util.List", "label:fields", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.domain.Label"), 307);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeLabel", "org.exoplatform.task.service.impl.TaskServiceImpl", "long", "labelId", "", "void"), 334);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTaskOrder", "org.exoplatform.task.service.impl.TaskServiceImpl", "long:org.exoplatform.task.domain.Status:[J", "currentTaskId:newStatus:orders", "", "void"), 112);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeTask", "org.exoplatform.task.service.impl.TaskServiceImpl", "long", "id", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 118);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cloneTask", "org.exoplatform.task.service.impl.TaskServiceImpl", "long", "id", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.domain.Task"), 127);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addComment", "org.exoplatform.task.service.impl.TaskServiceImpl", "long:long:java.lang.String:java.lang.String", "id:parentCommentId:username:comment", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.domain.Comment"), 183);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addComment", "org.exoplatform.task.service.impl.TaskServiceImpl", "long:java.lang.String:java.lang.String", "id:username:comment", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.domain.Comment"), 211);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addTaskLog", "org.exoplatform.task.service.impl.TaskServiceImpl", "long:java.lang.String:java.lang.String:java.lang.String", "id:username:actionName:target", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.domain.ChangeLog"), 217);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeComment", "org.exoplatform.task.service.impl.TaskServiceImpl", "long", "commentId", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 234);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addTaskToLabel", "org.exoplatform.task.service.impl.TaskServiceImpl", "java.lang.Long:java.lang.Long", "taskId:labelId", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 257);
    }
}

