/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.task.TestDtoUtils;
import org.exoplatform.task.TestUtils;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.ProjectHandler;
import org.exoplatform.task.dao.StatusHandler;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.dao.jpa.DAOHandlerJPAImpl;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.ParameterEntityException;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.impl.ProjectServiceImpl;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.storage.StatusStorage;
import org.exoplatform.task.storage.TaskStorage;
import org.exoplatform.task.storage.impl.ProjectStorageImpl;
import org.exoplatform.task.storage.impl.StatusStorageImpl;
import org.exoplatform.task.util.ProjectUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ProjectServiceTest {
    ProjectService projectService;
    ProjectStorage projectStorage;
    StatusStorage statusStorage;
    TaskStorage taskStorage;
    @Mock
    ListenerService listenerService;
    @Mock
    StatusService statusService;
    @Mock
    TaskService taskService;
    @Mock
    TaskHandler taskHandler;
    @Mock
    ProjectHandler projectHandler;
    @Mock
    StatusHandler statusHandler;
    @Mock
    DAOHandlerJPAImpl daoHandler;
    @Captor
    ArgumentCaptor<Project> projectCaptor;
    @Captor
    ArgumentCaptor<TaskDto> taskCaptor;
    @Captor
    ArgumentCaptor<TaskQuery> taskQueryCaptor;

    @Before
    public void setUp() {
        PortalContainer.getInstance();
        this.projectStorage = new ProjectStorageImpl((DAOHandler)this.daoHandler);
        this.statusStorage = new StatusStorageImpl((DAOHandler)this.daoHandler, this.projectStorage, this.taskStorage);
        this.projectService = new ProjectServiceImpl(this.statusService, this.taskService, (DAOHandler)this.daoHandler, this.projectStorage, this.statusStorage, this.listenerService);
        Mockito.when((Object)this.daoHandler.getTaskHandler()).thenReturn((Object)this.taskHandler);
        Mockito.when((Object)this.daoHandler.getProjectHandler()).thenReturn((Object)this.projectHandler);
        Mockito.when((Object)this.daoHandler.getStatusHandler()).thenReturn((Object)this.statusHandler);
        Mockito.when((Object)this.projectHandler.create(Matchers.any(Project.class))).thenReturn((Object)TestUtils.getDefaultProject());
        Mockito.when((Object)this.projectHandler.update(Matchers.any(Project.class))).thenReturn((Object)TestUtils.getDefaultProject());
        Mockito.when((Object)this.taskHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_TASK_ID))).thenReturn((Object)TestUtils.getDefaultTask());
        Mockito.when((Object)this.statusHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_STATUS_ID))).thenReturn((Object)TestUtils.getDefaultStatus());
        Mockito.when((Object)this.projectHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_PROJECT_ID))).thenReturn((Object)TestUtils.getDefaultProject());
    }

    @After
    public void tearDown() {
        this.projectService = null;
    }

    @Test
    public void testCreateProjectWithParent() throws EntityNotFoundException {
        Project parent = new Project();
        parent.setId(1L);
        Status status = new Status(1L, "testStatus");
        Mockito.when((Object)this.projectHandler.find((Serializable)Long.valueOf(1L))).thenReturn((Object)parent);
        Mockito.when((Object)this.statusService.getStatuses(1L)).thenReturn(Arrays.asList(this.statusStorage.statusToDTO(status)));
        Project child = ProjectUtil.newProjectInstance((String)"test", (String)"", (String)"root");
        this.projectService.createProject(this.projectStorage.projectToDto(child), parent.getId());
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).create(Matchers.any(Project.class));
        ((StatusService)Mockito.verify((Object)this.statusService, (VerificationMode)Mockito.times((int)1))).createStatus((ProjectDto)Matchers.any(), (String)Matchers.eq((Object)"testStatus"));
    }

    @Test
    public void testCreateDefaultProject() throws EntityNotFoundException {
        ProjectDto defaultProject = TestDtoUtils.getDefaultProject();
        Long projectParent = TestUtils.EXISTING_PROJECT_ID;
        this.projectService.createProject(defaultProject, projectParent.longValue());
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).create(this.projectCaptor.capture());
        Assert.assertEquals((Object)projectParent, (Object)new Long(((Project)this.projectCaptor.getValue()).getParent().getId()));
    }

    @Test
    public void testUpdateProjectName() throws ParameterEntityException, EntityNotFoundException {
        String name = "Project Name";
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        fields.put("name", new String[]{name});
        ProjectDto project = ProjectUtil.saveProjectField((ProjectService)this.projectService, (long)TestUtils.EXISTING_PROJECT_ID, fields);
        this.projectService.updateProject(project);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).update(this.projectCaptor.capture());
        Assert.assertEquals((Object)name, (Object)((Project)this.projectCaptor.getValue()).getName());
    }

    @Test
    public void testUpdateProjectDescription() throws ParameterEntityException, EntityNotFoundException {
        String description = "Bla bla bla";
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        fields.put("description", new String[]{description});
        ProjectDto project = ProjectUtil.saveProjectField((ProjectService)this.projectService, (long)TestUtils.EXISTING_PROJECT_ID, fields);
        this.projectService.updateProject(project);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).update(this.projectCaptor.capture());
        Assert.assertEquals((Object)description, (Object)((Project)this.projectCaptor.getValue()).getDescription());
    }

    @Test
    public void testUpdateProjectManagers() throws ParameterEntityException, EntityNotFoundException {
        String[] newManagers = new String[]{"Tib", "Trong", "Phuong", "Tuyen"};
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        fields.put("manager", newManagers);
        ProjectDto project = ProjectUtil.saveProjectField((ProjectService)this.projectService, (long)TestUtils.EXISTING_PROJECT_ID, fields);
        this.projectService.updateProject(project);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).update(this.projectCaptor.capture());
        HashSet<String> managers = new HashSet<String>();
        for (String v : newManagers) {
            managers.add(v);
        }
        Assert.assertEquals(managers, (Object)((Project)this.projectCaptor.getValue()).getManager());
    }

    @Test
    public void testUpdateProjectMembers() throws ParameterEntityException, EntityNotFoundException {
        String[] newMembers = new String[]{"Tib", "Trong", "Phuong", "Tuyen"};
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        fields.put("participator", newMembers);
        ProjectDto project = ProjectUtil.saveProjectField((ProjectService)this.projectService, (long)TestUtils.EXISTING_PROJECT_ID, fields);
        this.projectService.updateProject(project);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).update(this.projectCaptor.capture());
        HashSet<String> members = new HashSet<String>();
        for (String v : newMembers) {
            members.add(v);
        }
        Assert.assertEquals(members, (Object)((Project)this.projectCaptor.getValue()).getParticipator());
    }

    @Test
    public void testUpdateProjectDueDate() throws ParameterEntityException, EntityNotFoundException, ParseException {
        String dueDate = "1989-01-19";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = sdf.parse(dueDate);
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        fields.put("dueDate", new String[]{dueDate});
        ProjectDto project = ProjectUtil.saveProjectField((ProjectService)this.projectService, (long)TestUtils.EXISTING_PROJECT_ID, fields);
        this.projectService.updateProject(project);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).update(this.projectCaptor.capture());
        Assert.assertEquals((Object)date, (Object)((Project)this.projectCaptor.getValue()).getDueDate());
    }

    @Test
    public void testCloneProjectById() throws Exception {
        Project project = TestUtils.getDefaultProject();
        project.setName("Tib Project");
        project.setId(3L);
        HashSet<Task> tasks1 = new HashSet<Task>();
        tasks1.add(TestUtils.getDefaultTask());
        tasks1.add(TestUtils.getDefaultTask());
        HashSet<Task> tasks2 = new HashSet<Task>();
        tasks2.add(TestUtils.getDefaultTask());
        tasks2.add(TestUtils.getDefaultTask());
        Status status1 = new Status(3L, "ToDo", Integer.valueOf(1), project);
        Status status2 = new Status(4L, "ToDo", Integer.valueOf(2), project);
        HashSet<Status> statuses = new HashSet<Status>();
        statuses.add(status1);
        statuses.add(status2);
        project.setStatus(statuses);
        ArrayList list = new ArrayList(statuses);
        Mockito.when((Object)this.projectHandler.find((Serializable)Long.valueOf(3L))).thenReturn((Object)project);
        Mockito.when((Object)this.statusService.getStatuses(3L)).thenReturn((Object)this.statusStorage.listStatusToDTOs(list));
        this.projectService.cloneProject(3L, false);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).create(this.projectCaptor.capture());
        ArgumentCaptor statusNameCaptor = ArgumentCaptor.forClass(String.class);
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)0))).createTask((TaskDto)this.taskCaptor.capture());
    }

    @Test
    public void testUpdateProjectColor() throws ParameterEntityException, EntityNotFoundException {
        String color = "#000000";
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        fields.put("color", new String[]{color});
        ProjectDto project = ProjectUtil.saveProjectField((ProjectService)this.projectService, (long)TestUtils.EXISTING_PROJECT_ID, fields);
        this.projectService.updateProject(project);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).update(this.projectCaptor.capture());
        Assert.assertEquals((Object)color, (Object)((Project)this.projectCaptor.getValue()).getColor());
    }

    @Test
    public void testDeleteProjectById() throws EntityNotFoundException {
        Project projectParent = TestUtils.getDefaultProject();
        projectParent.setId(3L);
        final Project projectChild = TestUtils.getDefaultProject();
        projectChild.setId(4L);
        projectChild.setParent(projectParent);
        ListAccess<Project> projectChilds = new ListAccess<Project>(){

            public int getSize() throws Exception {
                return 1;
            }

            public Project[] load(int arg0, int arg1) throws Exception, IllegalArgumentException {
                return new Project[]{projectChild};
            }
        };
        Mockito.when((Object)this.projectHandler.find((Serializable)Long.valueOf(3L))).thenReturn((Object)projectParent);
        Mockito.when((Object)this.projectHandler.findSubProjects(projectParent)).thenReturn((Object)projectChilds);
        this.projectService.removeProject(3L, false);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).removeProject(Matchers.eq((long)3L), Matchers.eq((boolean)false));
    }

    @Test
    public void testDeleteProjectByIdWithSubproject() throws EntityNotFoundException {
        Project projectParent = TestUtils.getDefaultProject();
        projectParent.setId(3L);
        Project projectChild = TestUtils.getDefaultProject();
        projectChild.setId(4L);
        projectChild.setParent(projectParent);
        ArrayList<Project> projectChilds = new ArrayList<Project>();
        projectChilds.add(projectChild);
        projectParent.setChildren(projectChilds);
        Mockito.when((Object)this.projectHandler.find((Serializable)Long.valueOf(3L))).thenReturn((Object)projectParent);
        this.projectService.removeProject(3L, true);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).removeProject(Matchers.eq((long)3L), Matchers.eq((boolean)true));
    }

    @Test
    public void testGetProjectTreeByIdentity() {
    }
}

