/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.Query;
import org.exoplatform.task.dao.condition.AggregateCondition;
import org.exoplatform.task.dao.condition.Condition;
import org.exoplatform.task.dao.condition.Conditions;
import org.exoplatform.task.dao.condition.SingleCondition;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.util.UserUtil;

public class TaskQuery
extends Query
implements Cloneable {
    private List<Long> projectIds = null;
    private List<String> assignee = null;
    private List<String> coworker = null;
    private List<String> watchers = null;

    public TaskQuery() {
    }

    TaskQuery(AggregateCondition condition, List<OrderBy> orderBies, List<Long> projectIds, List<String> assignee, List<String> coworker, List<String> watchers) {
        super(condition, orderBies);
        this.projectIds = projectIds;
        this.assignee = assignee;
        this.coworker = coworker;
        this.watchers = watchers;
    }

    public static TaskQuery or(TaskQuery ... queries) {
        ArrayList<Condition> cond = new ArrayList<Condition>();
        for (TaskQuery q : queries) {
            if (q.getCondition() == null) continue;
            cond.add(q.getCondition());
        }
        AggregateCondition c = Conditions.or(cond.toArray(new Condition[cond.size()]));
        TaskQuery q = new TaskQuery();
        q.add(c);
        return q;
    }

    public TaskQuery add(TaskQuery taskQuery) {
        this.add(taskQuery.getCondition());
        return this;
    }

    public void setTitle(String title) {
        this.add(Conditions.like(Conditions.TASK_TITLE, '%' + title + '%'));
    }

    public void setDescription(String description) {
        this.add(Conditions.like(Conditions.TASK_DES, '%' + description + '%'));
    }

    public List<Long> getProjectIds() {
        return this.projectIds;
    }

    public void setProjectIds(List<Long> projectIds) {
        this.projectIds = projectIds;
        this.add(Conditions.in(Conditions.TASK_PROJECT, projectIds));
    }

    public List<String> getAssignee() {
        return this.assignee;
    }

    public void setAssignee(List<String> assignee) {
        if (assignee != null) {
            this.add(Conditions.in(Conditions.TASK_ASSIGNEE, assignee));
        }
        this.assignee = assignee;
    }

    public List<String> getWatchers() {
        return this.watchers;
    }

    public void setWatchers(List<String> watchers) {
        if (watchers != null) {
            this.add(Conditions.in(Conditions.TASK_WATCHER, watchers));
        }
        this.watchers = watchers;
    }

    public void setCoworker(List<String> coworker) {
        if (coworker != null) {
            this.add(Conditions.in(Conditions.TASK_COWORKER, coworker));
        }
        this.coworker = coworker;
    }

    public void setAssigneeOrCoworker(List<String> assignee) {
        if (assignee != null && assignee.size() > 0) {
            this.add(Conditions.or(Conditions.in(Conditions.TASK_ASSIGNEE, assignee), Conditions.in(Conditions.TASK_COWORKER, assignee)));
        }
        this.assignee = assignee;
    }

    public void setKeyword(String keyword) {
        if (keyword == null || keyword.trim().isEmpty()) {
            return;
        }
        ArrayList<SingleCondition<String>> conditions = new ArrayList<SingleCondition<String>>();
        for (String k : keyword.split(" ")) {
            if (k.trim().isEmpty()) continue;
            k = "%" + k.trim().toLowerCase() + "%";
            conditions.add(Conditions.like(Conditions.TASK_TITLE, k));
            conditions.add(Conditions.like(Conditions.TASK_DES, k));
            conditions.add(Conditions.like(Conditions.TASK_ASSIGNEE, k));
        }
        this.add(Conditions.or(conditions.toArray(new Condition[conditions.size()])));
    }

    public void setCompleted(Boolean completed) {
        if (completed.booleanValue()) {
            this.add(Conditions.isTrue(Conditions.TASK_COMPLETED));
        } else {
            this.add(Conditions.isFalse(Conditions.TASK_COMPLETED));
        }
    }

    public void setStartDate(Date startDate) {
        this.add(Conditions.gte(Conditions.TASK_END_DATE, startDate));
    }

    public void setEndDate(Date endDate) {
        this.add(Conditions.lte(Conditions.TASK_START_DATE, endDate));
    }

    public void setMemberships(List<String> permissions) {
        this.add(Conditions.or(Conditions.in(Conditions.TASK_PARTICIPATOR, permissions), Conditions.in(Conditions.TASK_MANAGER, permissions)));
    }

    @Deprecated
    public void setAssigneeOrMembership(String username, List<String> memberships) {
        this.assignee = Arrays.asList(username);
        this.add(Conditions.or(Conditions.eq(Conditions.TASK_ASSIGNEE, username), Conditions.in(Conditions.TASK_MANAGER, memberships), Conditions.in(Conditions.TASK_PARTICIPATOR, memberships)));
    }

    public void setAccessible(Identity user) {
        this.assignee = Arrays.asList(user.getUserId());
        List<String> memberships = UserUtil.getMemberships(user);
        this.add(Conditions.or(Conditions.eq(Conditions.TASK_ASSIGNEE, this.assignee), Conditions.eq(Conditions.TASK_COWORKER, this.assignee), Conditions.eq(Conditions.TASK_CREATOR, this.assignee), Conditions.in(Conditions.TASK_MANAGER, memberships), Conditions.in(Conditions.TASK_PARTICIPATOR, memberships), Conditions.in(Conditions.TASK_MENTIONED_USERS, Arrays.asList(user.getUserId()))));
    }

    public void setAssigneeOrCoworkerOrInProject(String username, List<Long> projectIds) {
        this.assignee = Arrays.asList(username);
        this.projectIds = projectIds;
        this.add(Conditions.or(Conditions.eq(Conditions.TASK_ASSIGNEE, username), Conditions.eq(Conditions.TASK_COWORKER, username), Conditions.in(Conditions.TASK_PROJECT, projectIds)));
    }

    public void setStatus(Status status) {
        this.add(Conditions.eq(Conditions.TASK_STATUS, status));
    }

    public void setStatus(StatusDto status) {
        this.add(Conditions.eq(Conditions.TASK_STATUS, status));
    }

    public void setDueDateFrom(Date dueDateFrom) {
        if (dueDateFrom != null) {
            this.add(Conditions.gte(Conditions.TASK_DUEDATE, dueDateFrom));
        }
    }

    public void setDueDateTo(Date dueDateTo) {
        if (dueDateTo != null) {
            this.add(Conditions.lte(Conditions.TASK_DUEDATE, dueDateTo));
        }
    }

    public void setIsIncomingOf(String username) {
        this.add(Conditions.and(Conditions.or(Conditions.eq(Conditions.TASK_ASSIGNEE, username), Conditions.eq(Conditions.TASK_COWORKER, username), Conditions.eq(Conditions.TASK_CREATOR, username), Conditions.in(Conditions.TASK_MENTIONED_USERS, Arrays.asList(username))), Conditions.isNull(Conditions.TASK_STATUS)));
    }

    public void setIsTodoOf(String username) {
        this.add(Conditions.or(Conditions.eq(Conditions.TASK_ASSIGNEE, username), Conditions.eq(Conditions.TASK_COWORKER, username), Conditions.in(Conditions.TASK_MENTIONED_USERS, Arrays.asList(username))));
        this.assignee = Arrays.asList(username);
    }

    public void setLabelIds(List<Long> labelIds) {
        if (labelIds != null) {
            LinkedList<SingleCondition<Long>> cond = new LinkedList<SingleCondition<Long>>();
            for (Long id : labelIds) {
                cond.add(Conditions.eq(Conditions.TASK_LABEL_ID, id));
            }
            this.add(Conditions.and(cond.toArray(new Condition[cond.size()])));
        }
    }

    public void setIsLabelOf(String username) {
        this.add(Conditions.eq(Conditions.TASK_LABEL_USERNAME, username));
    }

    public void setPriority(Priority priority) {
        this.add(Conditions.eq(Conditions.TASK_PRIORITY, priority));
    }

    public void setNullField(String nullField) {
        this.add(Conditions.isNull(nullField));
    }

    public void setEmptyField(String emptyField) {
        this.add(Conditions.isEmpty(emptyField));
    }

    public TaskQuery clone() {
        Condition condition = this.getCondition();
        return new TaskQuery(condition != null ? (AggregateCondition)condition.clone() : null, this.getOrderBy(), this.projectIds != null ? new ArrayList<Long>(this.projectIds) : null, this.assignee, this.coworker, this.watchers);
    }
}

