/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.legacy.service;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.task.TestUtils;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.ProjectHandler;
import org.exoplatform.task.dao.StatusHandler;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.dao.jpa.DAOHandlerJPAImpl;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.ParameterEntityException;
import org.exoplatform.task.legacy.service.ProjectService;
import org.exoplatform.task.legacy.service.StatusService;
import org.exoplatform.task.legacy.service.TaskService;
import org.exoplatform.task.legacy.service.impl.ProjectServiceImpl;
import org.exoplatform.task.util.ProjectUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ProjectServiceTest {
    ProjectService projectService;
    @Mock
    StatusService statusService;
    @Mock
    TaskService taskService;
    @Mock
    TaskHandler taskHandler;
    @Mock
    ProjectHandler projectHandler;
    @Mock
    StatusHandler statusHandler;
    @Mock
    DAOHandlerJPAImpl daoHandler;
    @Captor
    ArgumentCaptor<Project> projectCaptor;
    @Captor
    ArgumentCaptor<Task> taskCaptor;
    @Captor
    ArgumentCaptor<TaskQuery> taskQueryCaptor;

    @Before
    public void setUp() {
        PortalContainer.getInstance();
        this.projectService = new ProjectServiceImpl(this.statusService, this.taskService, (DAOHandler)this.daoHandler);
        Mockito.when((Object)this.daoHandler.getTaskHandler()).thenReturn((Object)this.taskHandler);
        Mockito.when((Object)this.daoHandler.getProjectHandler()).thenReturn((Object)this.projectHandler);
        Mockito.when((Object)this.daoHandler.getStatusHandler()).thenReturn((Object)this.statusHandler);
        Mockito.when((Object)this.projectHandler.create(Matchers.any(Project.class))).thenReturn((Object)TestUtils.getDefaultProject());
        Mockito.when((Object)this.projectHandler.update(Matchers.any(Project.class))).thenReturn((Object)TestUtils.getDefaultProject());
        Mockito.when((Object)this.taskHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_TASK_ID))).thenReturn((Object)TestUtils.getDefaultTask());
        Mockito.when((Object)this.statusHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_STATUS_ID))).thenReturn((Object)TestUtils.getDefaultStatus());
        Mockito.when((Object)this.projectHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_PROJECT_ID))).thenReturn((Object)TestUtils.getDefaultProject());
    }

    @After
    public void tearDown() {
        this.projectService = null;
    }

    @Test
    public void testCreateProjectWithParent() throws EntityNotFoundException {
        Project parent = new Project();
        parent.setId(1L);
        Status status = new Status(1L, "testStatus");
        Mockito.when((Object)this.projectHandler.find((Serializable)Long.valueOf(1L))).thenReturn((Object)parent);
        Mockito.when((Object)this.statusService.getStatuses(1L)).thenReturn(Arrays.asList(status));
        Project child = ProjectUtil.newProjectInstance((String)"test", (String)"", (String)"root");
        this.projectService.createProject(child, parent.getId());
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).create(Matchers.any(Project.class));
        ((StatusService)Mockito.verify((Object)this.statusService, (VerificationMode)Mockito.times((int)1))).createStatus((Project)Matchers.any(Project.class), (String)Matchers.eq((Object)"testStatus"));
    }

    @Test
    public void testUpdateProjectName() throws ParameterEntityException, EntityNotFoundException {
        String name = "Project Name";
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        fields.put("name", new String[]{name});
        Project project = ProjectUtil.saveProjectField((ProjectService)this.projectService, (long)TestUtils.EXISTING_PROJECT_ID, fields);
        this.projectService.updateProject(project);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).update(this.projectCaptor.capture());
        Assert.assertEquals((Object)name, (Object)((Project)this.projectCaptor.getValue()).getName());
    }

    @Test
    public void testUpdateProjectDescription() throws ParameterEntityException, EntityNotFoundException {
        String description = "Bla bla bla";
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        fields.put("description", new String[]{description});
        Project project = ProjectUtil.saveProjectField((ProjectService)this.projectService, (long)TestUtils.EXISTING_PROJECT_ID, fields);
        this.projectService.updateProject(project);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).update(this.projectCaptor.capture());
        Assert.assertEquals((Object)description, (Object)((Project)this.projectCaptor.getValue()).getDescription());
    }

    @Test
    public void testUpdateProjectManagers() throws ParameterEntityException, EntityNotFoundException {
        String[] newManagers = new String[]{"Tib", "Trong", "Phuong", "Tuyen"};
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        fields.put("manager", newManagers);
        Project project = ProjectUtil.saveProjectField((ProjectService)this.projectService, (long)TestUtils.EXISTING_PROJECT_ID, fields);
        this.projectService.updateProject(project);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).update(this.projectCaptor.capture());
        HashSet<String> managers = new HashSet<String>();
        for (String v : newManagers) {
            managers.add(v);
        }
        Assert.assertEquals(managers, (Object)((Project)this.projectCaptor.getValue()).getManager());
    }

    @Test
    public void testUpdateProjectMembers() throws ParameterEntityException, EntityNotFoundException {
        String[] newMembers = new String[]{"Tib", "Trong", "Phuong", "Tuyen"};
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        fields.put("participator", newMembers);
        Project project = ProjectUtil.saveProjectField((ProjectService)this.projectService, (long)TestUtils.EXISTING_PROJECT_ID, fields);
        this.projectService.updateProject(project);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).update(this.projectCaptor.capture());
        HashSet<String> members = new HashSet<String>();
        for (String v : newMembers) {
            members.add(v);
        }
        Assert.assertEquals(members, (Object)((Project)this.projectCaptor.getValue()).getParticipator());
    }

    @Test
    public void testUpdateProjectDueDate() throws ParameterEntityException, EntityNotFoundException, ParseException {
        String dueDate = "1989-01-19";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = sdf.parse(dueDate);
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        fields.put("dueDate", new String[]{dueDate});
        Project project = ProjectUtil.saveProjectField((ProjectService)this.projectService, (long)TestUtils.EXISTING_PROJECT_ID, fields);
        this.projectService.updateProject(project);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).update(this.projectCaptor.capture());
        Assert.assertEquals((Object)date, (Object)((Project)this.projectCaptor.getValue()).getDueDate());
    }

    @Test
    public void testUpdateProjectColor() throws ParameterEntityException, EntityNotFoundException {
        String color = "#000000";
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        fields.put("color", new String[]{color});
        Project project = ProjectUtil.saveProjectField((ProjectService)this.projectService, (long)TestUtils.EXISTING_PROJECT_ID, fields);
        this.projectService.updateProject(project);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).update(this.projectCaptor.capture());
        Assert.assertEquals((Object)color, (Object)((Project)this.projectCaptor.getValue()).getColor());
    }

    @Test
    public void testDeleteProjectById() throws EntityNotFoundException {
        Project projectParent = TestUtils.getDefaultProject();
        projectParent.setId(3L);
        final Project projectChild = TestUtils.getDefaultProject();
        projectChild.setId(4L);
        projectChild.setParent(projectParent);
        ListAccess<Project> projectChilds = new ListAccess<Project>(){

            public int getSize() throws Exception {
                return 1;
            }

            public Project[] load(int arg0, int arg1) throws Exception, IllegalArgumentException {
                return new Project[]{projectChild};
            }
        };
        Mockito.when((Object)this.projectHandler.find((Serializable)Long.valueOf(3L))).thenReturn((Object)projectParent);
        Mockito.when((Object)this.projectHandler.findSubProjects(projectParent)).thenReturn((Object)projectChilds);
        this.projectService.removeProject(3L, false);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).removeProject(Matchers.eq((long)3L), Matchers.eq((boolean)false));
    }

    @Test
    public void testDeleteProjectByIdWithSubproject() throws EntityNotFoundException {
        Project projectParent = TestUtils.getDefaultProject();
        projectParent.setId(3L);
        Project projectChild = TestUtils.getDefaultProject();
        projectChild.setId(4L);
        projectChild.setParent(projectParent);
        ArrayList<Project> projectChilds = new ArrayList<Project>();
        projectChilds.add(projectChild);
        projectParent.setChildren(projectChilds);
        Mockito.when((Object)this.projectHandler.find((Serializable)Long.valueOf(3L))).thenReturn((Object)projectParent);
        this.projectService.removeProject(3L, true);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).removeProject(Matchers.eq((long)3L), Matchers.eq((boolean)true));
    }

    @Test
    public void testCloneProjectById() throws EntityNotFoundException {
        Project project = TestUtils.getDefaultProject();
        project.setName("Tib Project");
        project.setId(3L);
        HashSet<Task> tasks1 = new HashSet<Task>();
        tasks1.add(TestUtils.getDefaultTask());
        tasks1.add(TestUtils.getDefaultTask());
        HashSet<Task> tasks2 = new HashSet<Task>();
        tasks2.add(TestUtils.getDefaultTask());
        tasks2.add(TestUtils.getDefaultTask());
        Status status1 = new Status(3L, "ToDo", Integer.valueOf(1), project);
        Status status2 = new Status(4L, "ToDo", Integer.valueOf(2), project);
        HashSet<Status> statuses = new HashSet<Status>();
        statuses.add(status1);
        statuses.add(status2);
        project.setStatus(statuses);
        Mockito.when((Object)this.projectHandler.find((Serializable)Long.valueOf(3L))).thenReturn((Object)project);
        Mockito.when((Object)this.statusService.getStatuses(3L)).thenReturn(new ArrayList(statuses));
        this.projectService.cloneProject(3L, false);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).create(this.projectCaptor.capture());
        Assert.assertEquals((Object)("Copy of " + project.getName()), (Object)((Project)this.projectCaptor.getValue()).getName());
        ArgumentCaptor statusNameCaptor = ArgumentCaptor.forClass(String.class);
        ((StatusService)Mockito.verify((Object)this.statusService, (VerificationMode)Mockito.times((int)2))).createStatus((Project)this.projectCaptor.capture(), (String)statusNameCaptor.capture());
        List statusNames = statusNameCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)statusNames.size());
        Assert.assertEquals((Object)status1.getName(), statusNames.get(0));
        Assert.assertEquals((Object)status2.getName(), statusNames.get(1));
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)0))).createTask((Task)this.taskCaptor.capture());
    }

    @Test
    public void testCloneProjectByIdWithCopyOfTask() throws EntityNotFoundException {
        Project project = TestUtils.getDefaultProject();
        project.setId(3L);
        HashSet<Task> tasks1 = new HashSet<Task>();
        tasks1.add(TestUtils.getDefaultTaskWithId(1L));
        tasks1.add(TestUtils.getDefaultTaskWithId(2L));
        HashSet<Task> tasks2 = new HashSet<Task>();
        tasks2.add(TestUtils.getDefaultTaskWithId(3L));
        tasks2.add(TestUtils.getDefaultTaskWithId(4L));
        tasks2.add(TestUtils.getDefaultTaskWithId(5L));
        Status status1 = new Status(3L, "ToDo", Integer.valueOf(1), project);
        Status status2 = new Status(4L, "On Progress", Integer.valueOf(2), project);
        TreeSet<Status> statuses = new TreeSet<Status>();
        statuses.add(status1);
        statuses.add(status2);
        project.setStatus(statuses);
        Mockito.when((Object)this.projectHandler.find((Serializable)Long.valueOf(3L))).thenReturn((Object)project);
        Mockito.when((Object)this.statusService.getStatuses(3L)).thenReturn(new ArrayList(statuses));
        Mockito.when((Object)this.statusService.createStatus((Project)Matchers.any(Project.class), (String)Matchers.any(String.class))).thenAnswer((Answer)new Answer<Status>(){

            public Status answer(InvocationOnMock invocationOnMock) throws Throwable {
                String statusName = (String)invocationOnMock.getArgumentAt(1, String.class);
                return new Status(0L, statusName);
            }
        });
        Mockito.when((Object)this.taskService.findTasks((TaskQuery)Matchers.any(TaskQuery.class))).thenReturn((Object)new ListAccessImpl(Task.class, new ArrayList(tasks1))).thenReturn((Object)new ListAccessImpl(Task.class, new ArrayList(tasks2)));
        this.projectService.cloneProject(3L, true);
        ((ProjectHandler)Mockito.verify((Object)this.projectHandler, (VerificationMode)Mockito.times((int)1))).create(this.projectCaptor.capture());
        ArgumentCaptor statusNameCaptor = ArgumentCaptor.forClass(String.class);
        ((StatusService)Mockito.verify((Object)this.statusService, (VerificationMode)Mockito.times((int)2))).createStatus((Project)this.projectCaptor.capture(), (String)statusNameCaptor.capture());
        List statusNames = statusNameCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)statusNames.size());
        Assert.assertEquals((Object)status1.getName(), statusNames.get(0));
        Assert.assertEquals((Object)status2.getName(), statusNames.get(1));
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)5))).createTask((Task)this.taskCaptor.capture());
        List tasks = this.taskCaptor.getAllValues();
        Assert.assertEquals((Object)status1.getName(), (Object)((Task)tasks.get(0)).getStatus().getName());
        Assert.assertEquals((Object)status1.getName(), (Object)((Task)tasks.get(1)).getStatus().getName());
        Assert.assertEquals((Object)status2.getName(), (Object)((Task)tasks.get(2)).getStatus().getName());
        Assert.assertEquals((Object)status2.getName(), (Object)((Task)tasks.get(3)).getStatus().getName());
        Assert.assertEquals((Object)status2.getName(), (Object)((Task)tasks.get(4)).getStatus().getName());
    }

    @Test
    public void testGetProjectTreeByIdentity() {
    }
}

