/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.task.domain.ChangeLog;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.LabelTaskMapping;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.domain.Status;

@Entity(name="TaskTask")
@ExoEntity
@Table(name="TASK_TASKS")
@NamedQueries(value={@NamedQuery(name="Task.findByMemberships", query="SELECT ta FROM TaskTask ta LEFT JOIN ta.coworker coworkers WHERE ta.assignee = :userName OR ta.createdBy = :userName OR coworkers = :userName OR ta.status IN (SELECT st.id FROM TaskStatus st WHERE project IN (SELECT pr1.id FROM TaskProject pr1 LEFT JOIN pr1.manager managers WHERE managers IN :memberships) OR project IN (SELECT pr2.id FROM TaskProject pr2 LEFT JOIN pr2.participator participators WHERE participators IN :memberships) ) "), @NamedQuery(name="Task.findTaskByProject", query="SELECT t FROM TaskTask t WHERE t.status.project.id = :projectId"), @NamedQuery(name="Task.findTaskByActivityId", query="SELECT t FROM TaskTask t WHERE t.activityId = :activityId"), @NamedQuery(name="Task.getCoworker", query="SELECT c FROM TaskTask t inner join t.coworker c WHERE t.id = :taskid"), @NamedQuery(name="Task.getWatcher", query="SELECT w FROM TaskTask t inner join t.watcher w WHERE t.id = :taskid"), @NamedQuery(name="Task.updateStatus", query="UPDATE TaskTask t SET t.status = :status_new WHERE t.status = :status_old"), @NamedQuery(name="Task.getTaskWithCoworkers", query="SELECT t FROM TaskTask t LEFT JOIN FETCH t.coworker c WHERE t.id = :taskid"), @NamedQuery(name="Task.getUncompletedTasks", query="SELECT ta FROM TaskTask ta WHERE ta.completed = false AND (ta.assignee = :userName OR :userName in (select co FROM ta.coworker co) )"), @NamedQuery(name="Task.countUncompletedTasks", query="SELECT COUNT(ta) FROM TaskTask ta WHERE ta.completed = false AND (ta.assignee = :userName OR :userName in (select co FROM ta.coworker co) )"), @NamedQuery(name="Task.getCollaboratedTasks", query="SELECT ta FROM TaskTask ta WHERE ta.completed = false AND :userName in (select co FROM ta.coworker co) "), @NamedQuery(name="Task.countCollaboratedTasks", query="SELECT COUNT(ta) FROM TaskTask ta WHERE ta.completed = false AND :userName in (select co FROM ta.coworker co) "), @NamedQuery(name="Task.getAssignedTasks", query="SELECT ta FROM TaskTask ta WHERE ta.completed = false AND ta.assignee = :userName "), @NamedQuery(name="Task.countAssignedTasks", query="SELECT COUNT(ta)  FROM TaskTask ta WHERE ta.completed = false AND ta.assignee = :userName "), @NamedQuery(name="Task.getWatchedTasks", query="SELECT ta FROM TaskTask ta WHERE ta.completed = false AND :userName in (select wa FROM ta.watcher wa) "), @NamedQuery(name="Task.countWatchedTasks", query="SELECT COUNT(ta)  FROM TaskTask ta WHERE ta.completed = false AND :userName in (select wa FROM ta.watcher wa) "), @NamedQuery(name="Task.getOverdueTasks", query="SELECT ta FROM TaskTask ta WHERE ta.completed = false AND ta.dueDate < CURDATE() AND (ta.assignee = :userName OR :userName in (select co FROM ta.coworker co) )"), @NamedQuery(name="Task.countOverdueTasks", query="SELECT COUNT(ta) FROM TaskTask ta WHERE ta.completed = false AND ta.dueDate < CURDATE() AND (ta.assignee = :userName OR :userName in (select co FROM ta.coworker co) )"), @NamedQuery(name="Task.findTasks", query="SELECT ta FROM TaskTask ta WHERE (ta.assignee = :userName OR ta.createdBy = :userName OR :userName in (select co FROM ta.coworker co)) AND (lower(ta.title) LIKE lower(:term)  OR lower(ta.description) LIKE :term) ORDER BY ta.createdTime DESC"), @NamedQuery(name="Task.countTasks", query="SELECT COUNT(ta) FROM TaskTask ta WHERE (ta.assignee = :userName OR ta.createdBy = :userName OR :userName in (select co FROM ta.coworker co)) AND (lower(ta.title) LIKE lower(:term)  OR lower(ta.description) LIKE :term) "), @NamedQuery(name="Task.countTaskStatusByProject", query="SELECT m.status.name AS name, COUNT(m) AS total FROM TaskTask AS m where m.status.project.id = :projectId GROUP BY m.status.name ORDER BY m.status.name ASC"), @NamedQuery(name="Task.getByStatus", query="SELECT t FROM TaskTask t  WHERE t.status.id = :statusid")})
public class Task {
    public static final String PREFIX_CLONE = "Copy of ";
    @Id
    @SequenceGenerator(name="SEQ_TASK_TASKS_TASK_ID", sequenceName="SEQ_TASK_TASKS_TASK_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TASK_TASKS_TASK_ID")
    @Column(name="TASK_ID")
    private long id;
    private String title;
    private String description;
    @Enumerated(value=EnumType.ORDINAL)
    private Priority priority;
    private String context;
    private String assignee;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="STATUS_ID")
    private Status status;
    @Column(name="TASK_RANK")
    private int rank;
    private boolean completed = false;
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="TASK_TASK_COWORKERS", joinColumns={@JoinColumn(name="TASK_ID")})
    private Set<String> coworker = new HashSet<String>();
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="TASK_TASK_WATCHERS", joinColumns={@JoinColumn(name="TASK_ID")})
    private Set<String> watcher = new HashSet<String>();
    @Column(name="CREATED_BY")
    private String createdBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED_TIME")
    private Date createdTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="START_DATE")
    private Date startDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="END_DATE")
    private Date endDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DUE_DATE")
    private Date dueDate;
    @OneToMany(mappedBy="task", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true)
    private List<Comment> comments = new ArrayList<Comment>();
    @OneToMany(mappedBy="task", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true)
    private List<ChangeLog> logs = new ArrayList<ChangeLog>();
    @OneToMany(mappedBy="task", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true)
    private Set<LabelTaskMapping> lblMapping = new HashSet<LabelTaskMapping>();
    @Column(name="ACTIVITY_ID")
    private String activityId;

    public Task() {
        this.priority = Priority.NORMAL;
    }

    public Task(String title, String description, Priority priority, String context, String assignee, Set<String> coworker, Set<String> watcher, Status status, String createdBy, Date endDate, Date startDate, Date dueDate) {
        this.title = title;
        this.assignee = assignee;
        this.coworker = coworker;
        this.watcher = watcher;
        this.context = context;
        this.createdBy = createdBy;
        this.description = description;
        this.priority = priority;
        this.startDate = startDate;
        this.endDate = endDate;
        this.dueDate = dueDate;
        this.status = status;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Set<String> getCoworker() {
        return this.coworker;
    }

    public void setCoworker(Set<String> coworker) {
        this.coworker = coworker;
    }

    public Set<String> getWatcher() {
        return this.watcher;
    }

    public void setWatcher(Set<String> watcher) {
        this.watcher = watcher;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public Task clone() {
        HashSet<String> coworkerClone = new HashSet();
        HashSet<String> watcherClone = new HashSet();
        if (this.getCoworker() != null) {
            coworkerClone = new HashSet<String>(this.getCoworker());
        }
        if (this.getWatcher() != null) {
            watcherClone = new HashSet<String>(this.getWatcher());
        }
        Task newTask = new Task(this.getTitle(), this.getDescription(), this.getPriority(), this.getContext(), this.getAssignee(), coworkerClone, watcherClone, this.getStatus() != null ? this.getStatus().clone() : null, this.getCreatedBy(), this.getEndDate(), this.getStartDate(), this.getDueDate());
        newTask.setCreatedTime(this.getCreatedTime());
        newTask.setActivityId(this.getActivityId());
        newTask.setCompleted(this.isCompleted());
        newTask.setRank(this.getRank());
        newTask.setId(this.getId());
        return newTask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task task = (Task)o;
        if (this.completed != task.completed) {
            return false;
        }
        if (this.id != task.id) {
            return false;
        }
        if (this.assignee != null ? !this.assignee.equals(task.assignee) : task.assignee != null) {
            return false;
        }
        if (this.context != null ? !this.context.equals(task.context) : task.context != null) {
            return false;
        }
        if (this.coworker != null ? !this.coworker.equals(task.coworker) : task.coworker != null) {
            return false;
        }
        if (this.watcher != null ? !this.watcher.equals(task.watcher) : task.watcher != null) {
            return false;
        }
        if (this.createdBy != null ? !this.createdBy.equals(task.createdBy) : task.createdBy != null) {
            return false;
        }
        if (this.createdTime != null ? !this.createdTime.equals(task.createdTime) : task.createdTime != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(task.description) : task.description != null) {
            return false;
        }
        if (this.dueDate != null ? !this.dueDate.equals(task.dueDate) : task.dueDate != null) {
            return false;
        }
        if (this.priority != task.priority) {
            return false;
        }
        if (this.startDate != null ? !this.startDate.equals(task.startDate) : task.startDate != null) {
            return false;
        }
        if (this.endDate != null ? !this.endDate.equals(task.endDate) : task.endDate != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(task.status) : task.status != null) {
            return false;
        }
        return !(this.title != null ? !this.title.equals(task.title) : task.title != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.title, this.description, this.priority, this.context, this.assignee, this.status, this.completed, this.coworker, this.watcher, this.createdBy, this.createdTime, this.startDate, this.endDate, this.dueDate});
    }
}

