/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;

@Path(value="/status")
@Api(value="/status", description="Managing status")
@RolesAllowed(value={"users"})
public class StatusRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(StatusRestService.class);
    private ProjectService projectService;
    private StatusService statusService;

    public StatusRestService(ProjectService projectService, StatusService statusService) {
        this.projectService = projectService;
        this.statusService = statusService;
    }

    @GET
    @Path(value="{statusId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="get Status by Id", httpMethod="GET", response=Response.class, notes="This get status by Id")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response getStatus(@ApiParam(value="statusId", required=true) @PathParam(value="statusId") long statusId) {
        try {
            StatusDto statusDto = this.statusService.getStatus(statusId);
            if (statusDto == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)statusDto).build();
        }
        catch (Exception e) {
            LOG.error("Can't get Status {}", new Object[]{statusId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Create Status", httpMethod="POST", response=Response.class, notes="This create new status")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response addStatus(@ApiParam(value="Status", required=true) List<StatusDto> status) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            ProjectDto projectDto = this.projectService.getProject(status.get(0).getProject().getId());
            if (projectDto.getParent() != null && projectDto.getParent().getId() != 0L) {
                Long parentId = projectDto.getParent().getId();
                try {
                    if (this.projectService.getProject(parentId) != null && !this.projectService.getProject(parentId).canEdit(identity)) {
                        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                    }
                }
                catch (EntityNotFoundException ex) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
            }
            if (!projectDto.canEdit(identity)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            for (StatusDto statusDto : status) {
                if (statusDto.getId() == null) {
                    this.statusService.createStatus(projectDto, statusDto.getName(), statusDto.getRank());
                    continue;
                }
                StatusDto oldStatus = this.statusService.getStatus(statusDto.getId());
                if (oldStatus == null || oldStatus.getRank() == statusDto.getRank()) continue;
                this.statusService.updateStatus(statusDto);
            }
            return Response.ok((Object)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Can't Create Status", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="{statusId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Update StatusId", httpMethod="PUT", response=Response.class, notes="This Update status name")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response updateStatus(@ApiParam(value="statusId", required=true) @PathParam(value="statusId") long statusId, @ApiParam(value="status", required=true) StatusDto statusDto) {
        try {
            if (this.statusService.getStatus(statusId) == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Identity identity = ConversationState.getCurrent().getIdentity();
            ProjectDto projectDto = this.projectService.getProject(statusDto.getProject().getId());
            if (projectDto.getParent() != null && !projectDto.getParent().toString().isEmpty()) {
                Long parentId = projectDto.getParent().getId();
                try {
                    if (this.projectService.getProject(parentId) != null && !this.projectService.getProject(parentId).canEdit(identity)) {
                        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                    }
                }
                catch (EntityNotFoundException ex) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
            }
            if (!projectDto.canEdit(identity)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            this.statusService.updateStatus(statusDto.getId(), statusDto.getName());
            return Response.ok((Object)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOG.error("Can't update Status {}", new Object[]{statusId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="move")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="move Status", httpMethod="PUT", response=Response.class, notes="This moves status")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response moveStatus(@ApiParam(value="Status", required=true) List<StatusDto> status) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            ProjectDto projectDto = this.projectService.getProject(status.get(0).getProject().getId());
            if (projectDto.getParent() != null && projectDto.getParent().getId() != 0L) {
                Long parentId = projectDto.getParent().getId();
                try {
                    if (this.projectService.getProject(parentId) != null && !this.projectService.getProject(parentId).canEdit(identity)) {
                        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                    }
                }
                catch (EntityNotFoundException ex) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
            }
            if (!projectDto.canEdit(identity)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            for (StatusDto statusDto : status) {
                StatusDto oldStatus = this.statusService.getStatus(statusDto.getId());
                if (oldStatus == null || oldStatus.getRank() == statusDto.getRank()) continue;
                this.statusService.updateStatus(statusDto);
            }
            return Response.ok((Object)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Can't move Status", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="{statusId}")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Delete status", httpMethod="DELETE", response=Response.class, notes="This deletes the status", consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Project deleted"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to delete the Project"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteStatus(@ApiParam(value="statusId", required=true) @PathParam(value="statusId") Long statusId) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            StatusDto statusDto = this.statusService.getStatus(statusId);
            if (!statusDto.getProject().canEdit(identity)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            this.statusService.removeStatus(statusDto.getId());
            return Response.ok((Object)Response.Status.OK).entity((Object)"Deleted").build();
        }
        catch (Exception e) {
            LOG.error("Can't delete Status {}", new Object[]{statusId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

