/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task;

import java.sql.SQLException;
import liquibase.exception.LiquibaseException;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.task.TestUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public class AbstractTest {
    @BeforeClass
    public static void createTable() throws SQLException, ClassNotFoundException, LiquibaseException {
        TestUtils.initH2DB();
    }

    @AfterClass
    public static void destroy() throws LiquibaseException, SQLException {
        TestUtils.closeDB();
    }

    @Before
    public void initializeContainerAndStartRequestLifecycle() {
        PortalContainer container = PortalContainer.getInstance();
        RequestLifeCycle.begin((ExoContainer)container);
        EntityManagerService entityMgrService = (EntityManagerService)container.getComponentInstanceOfType(EntityManagerService.class);
        entityMgrService.getEntityManager().getTransaction().begin();
    }

    @After
    public void endRequestLifecycle() {
        PortalContainer container = PortalContainer.getInstance();
        EntityManagerService entityMgrService = (EntityManagerService)container.getComponentInstanceOfType(EntityManagerService.class);
        if (entityMgrService.getEntityManager() != null && entityMgrService.getEntityManager().getTransaction() != null && entityMgrService.getEntityManager().getTransaction().isActive()) {
            entityMgrService.getEntityManager().getTransaction().commit();
            RequestLifeCycle.end();
        }
    }
}

