/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.TestUtils;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.dto.TasksList;
import org.exoplatform.task.model.User;
import org.exoplatform.task.rest.TaskRestService;
import org.exoplatform.task.rest.model.CommentEntity;
import org.exoplatform.task.rest.model.PaginatedTaskList;
import org.exoplatform.task.rest.model.ViewState;
import org.exoplatform.task.service.CommentService;
import org.exoplatform.task.service.LabelService;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.CommentUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestTaskRestService {
    @Mock
    TaskService taskService;
    @Mock
    ProjectService projectService;
    @Mock
    StatusService statusService;
    @Mock
    UserService userService;
    @Mock
    SpaceService spaceService;
    @Mock
    CommentService commentService;
    @Mock
    LabelService labelService;

    @Before
    public void setup() {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
    }

    @Test
    public void testGetTasks() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        TaskDto task1 = new TaskDto();
        TaskDto task2 = new TaskDto();
        TaskDto task3 = new TaskDto();
        TaskDto task4 = new TaskDto();
        ArrayList<TaskDto> uncompletedTasks = new ArrayList<TaskDto>();
        task1.setCompleted(true);
        uncompletedTasks.add(task2);
        uncompletedTasks.add(task3);
        uncompletedTasks.add(task4);
        ArrayList<TaskDto> overdueTasks = new ArrayList<TaskDto>();
        overdueTasks.add(task1);
        overdueTasks.add(task2);
        ArrayList<TaskDto> incomingTasks = new ArrayList<TaskDto>();
        incomingTasks.add(task1);
        incomingTasks.add(task2);
        Mockito.when((Object)this.taskService.getUncompletedTasks("root", 20)).thenReturn(uncompletedTasks);
        Mockito.when((Object)this.taskService.countUncompletedTasks("root")).thenReturn((Object)uncompletedTasks.size());
        Mockito.when((Object)this.taskService.getOverdueTasks("root", 20)).thenReturn(overdueTasks);
        Mockito.when((Object)this.taskService.countOverdueTasks("root")).thenReturn((Object)overdueTasks.size());
        Mockito.when((Object)this.taskService.getIncomingTasks("root", 0, 20)).thenReturn(incomingTasks);
        Mockito.when((Object)this.taskService.countIncomingTasks("root")).thenReturn((Object)incomingTasks.size());
        Mockito.when((Object)this.taskService.countTasks((String)Mockito.eq((Object)"root"), (String)Mockito.eq((Object)"searchTerm"))).thenReturn((Object)1L);
        Response response = taskRestService.getTasks("overdue", null, 0, 20, false, false);
        Response response1 = taskRestService.getTasks("incoming", null, 0, 20, false, false);
        Response response2 = taskRestService.getTasks("", null, 0, 20, false, false);
        Response response3 = taskRestService.getTasks("whatever", "searchTerm", 0, 20, true, true);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        PaginatedTaskList tasks = (PaginatedTaskList)response.getEntity();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)2L, (long)tasks.getTasksNumber());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
        PaginatedTaskList tasks1 = (PaginatedTaskList)response1.getEntity();
        Assert.assertNotNull((Object)tasks1);
        Assert.assertEquals((long)2L, (long)tasks1.getTasksNumber());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response2.getStatus());
        PaginatedTaskList tasks2 = (PaginatedTaskList)response2.getEntity();
        Assert.assertNotNull((Object)tasks2);
        Assert.assertEquals((long)3L, (long)tasks2.getTasksNumber());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response3.getStatus());
        PaginatedTaskList tasks3 = (PaginatedTaskList)response3.getEntity();
        Assert.assertNotNull((Object)tasks3);
        Assert.assertNotNull((Object)tasks3.getTasks());
        Assert.assertNotNull((Object)tasks3.getTasksNumber());
        Assert.assertEquals((long)1L, (long)tasks3.getTasksNumber());
    }

    @Test
    public void testGetTasksByProjectId() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        TaskDto task1 = new TaskDto();
        TaskDto task2 = new TaskDto();
        TaskDto task3 = new TaskDto();
        TaskDto task4 = new TaskDto();
        ArrayList<TaskDto> tasks = new ArrayList<TaskDto>();
        tasks.add(task1);
        tasks.add(task2);
        tasks.add(task3);
        tasks.add(task4);
        TaskQuery taskQuery = new TaskQuery();
        ArrayList<Long> allProjectIds = new ArrayList<Long>();
        allProjectIds.add(1L);
        ProjectDto project1 = new ProjectDto();
        project1.setName("project1");
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(project1.getId()))).thenReturn((Object)project1);
        Response response = taskRestService.getTasksByProjectId(Long.valueOf(project1.getId()), 0, -1, false, false, false);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        HashSet<String> manager = new HashSet<String>();
        manager.add("root");
        project1.setManager(manager);
        response = taskRestService.getTasksByProjectId(Long.valueOf(project1.getId()), 0, -1, false, false, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testGetTaskById() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        TaskDto task1 = new TaskDto();
        task1.setAssignee("root");
        this.taskService.createTask(task1);
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task1);
        Response response = taskRestService.getTaskById(1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testAddTask() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        TaskDto task1 = new TaskDto();
        task1.setTitle("task");
        task1.setCreatedBy("john");
        task1.setAssignee("john");
        Response response = taskRestService.addTask(task1);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        ProjectDto project = new ProjectDto();
        project.setId(1L);
        StatusDto status = new StatusDto();
        status.setProject(project);
        task1.setStatus(status);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(1L))).thenReturn((Object)project);
        Mockito.when((Object)this.statusService.getDefaultStatus(1L)).thenReturn((Object)status);
        response = taskRestService.addTask(task1);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        HashSet<String> participators = new HashSet<String>();
        participators.add("john");
        project.setParticipator(participators);
        response = taskRestService.addTask(task1);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testUpdateTaskById() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        TaskDto task1 = new TaskDto();
        TaskDto task2 = new TaskDto();
        task1.setId(1L);
        task1.setTitle("oldTask");
        task1.setCreatedBy("john");
        task1.setAssignee("john");
        task2.setId(2L);
        task2.setTitle("updatedTask");
        this.taskService.createTask(task1);
        this.taskService.createTask(task2);
        Response response = taskRestService.updateTaskById(1L, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Response response1 = taskRestService.updateTaskById(3L, task2);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response1.getStatus());
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task1);
        Mockito.when((Object)this.taskService.updateTask(task2)).thenReturn((Object)task2);
        Response response2 = taskRestService.updateTaskById(1L, task2);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response2.getStatus());
        TaskDto task = (TaskDto)response2.getEntity();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"updatedTask", (Object)task.getTitle());
    }

    @Test
    public void deleteTaskById() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        TaskDto task = new TaskDto();
        task.setId(1L);
        task.setCreatedBy("john");
        task.setAssignee("john");
        this.taskService.createTask(task);
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task);
        Response response = taskRestService.deleteTaskById(1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testGetLabels() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        ProjectDto project = new ProjectDto();
        project.setName("project1");
        StatusDto status = new StatusDto();
        status.setName("status1");
        status.setRank(Integer.valueOf(1));
        status.setProject(project);
        TaskDto task = new TaskDto();
        task.setId(1L);
        task.setStatus(status);
        LabelDto label1 = new LabelDto();
        label1.setId(1L);
        label1.setName("label1");
        LabelDto label2 = new LabelDto();
        label2.setId(2L);
        label1.setName("label2");
        LabelDto label3 = new LabelDto();
        label3.setId(3L);
        label1.setName("label3");
        ArrayList<LabelDto> labels = new ArrayList<LabelDto>();
        labels.add(label1);
        labels.add(label2);
        labels.add(label3);
        Mockito.when((Object)this.labelService.findLabelsByUser(root.getUserId(), 0, -1)).thenReturn(labels);
        Response response = taskRestService.getLabels();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        List labelList = (List)response.getEntity();
        Assert.assertNotNull((Object)labelList);
        Assert.assertEquals((long)3L, (long)labelList.size());
    }

    @Test
    public void getLabelsByTaskId() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        ProjectDto project = new ProjectDto();
        project.setName("project1");
        StatusDto status = new StatusDto();
        status.setName("status1");
        status.setRank(Integer.valueOf(1));
        status.setProject(project);
        TaskDto task = new TaskDto();
        task.setId(1L);
        task.setStatus(status);
        LabelDto label1 = new LabelDto();
        label1.setId(1L);
        label1.setName("label1");
        LabelDto label2 = new LabelDto();
        label2.setId(2L);
        label1.setName("label2");
        LabelDto label3 = new LabelDto();
        label3.setId(3L);
        label1.setName("label3");
        final ArrayList<LabelDto> labels = new ArrayList<LabelDto>();
        labels.add(label1);
        labels.add(label2);
        labels.add(label3);
        ListAccess<LabelDto> labelsListAccess = new ListAccess<LabelDto>(){

            public LabelDto[] load(int offset, int limit) {
                return new LabelDto[]{(LabelDto)labels.get(0), (LabelDto)labels.get(1), (LabelDto)labels.get(2)};
            }

            public int getSize() throws Exception {
                return labels.size();
            }
        };
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task);
        Mockito.when((Object)this.labelService.findLabelsByTask(task, 0L, root, 0, -1)).thenReturn(labels);
        Response response = taskRestService.getLabelsByTaskId(1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        List labelList = (List)response.getEntity();
        Assert.assertNotNull((Object)labelList);
        Assert.assertEquals((long)3L, (long)labelList.size());
    }

    @Test
    public void testAddTaskToLabel() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        ProjectDto project = new ProjectDto();
        project.setId(1L);
        HashSet<String> manager = new HashSet<String>();
        manager.add("root");
        project.setManager(manager);
        StatusDto status = new StatusDto();
        status.setId(Long.valueOf(1L));
        status.setName("status 1");
        status.setProject(project);
        TaskDto task = new TaskDto();
        task.setId(1L);
        task.setCreatedBy("root");
        task.setAssignee("root");
        task.setStatus(status);
        this.taskService.createTask(task);
        LabelDto label1 = new LabelDto();
        label1.setId(1L);
        label1.setName("label1");
        label1.setProject(project);
        LabelDto label2 = new LabelDto();
        label2.setId(2L);
        label2.setName("label1");
        label2.setProject(project);
        LabelDto label3 = new LabelDto();
        label3.setId(0L);
        label3.setProject(project);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(project.getId()))).thenReturn((Object)project);
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task);
        Response response = taskRestService.addTaskToLabel(label1, 1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        LabelDto addedLabel = (LabelDto)response.getEntity();
        Assert.assertNotNull((Object)addedLabel);
        Response response1 = taskRestService.addTaskToLabel(null, 1L);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        Response response2 = taskRestService.addTaskToLabel(label1, 3L);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response2.getStatus());
        Mockito.when((Object)this.labelService.createLabel(label3)).thenReturn((Object)label1);
        Response response3 = taskRestService.addTaskToLabel(label3, 1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response3.getStatus());
    }

    @Test
    public void testGetTaskLogs() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        ProjectDto project = new ProjectDto();
        project.setId(1L);
        StatusDto status = new StatusDto();
        status.setId(Long.valueOf(1L));
        status.setName("status 1");
        status.setProject(project);
        TaskDto task = new TaskDto();
        task.setId(1L);
        task.setCreatedBy("root");
        task.setAssignee("root");
        this.taskService.createTask(task);
        Response response = taskRestService.getTaskLogs(task.getId(), 0, 1);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task);
        Response response1 = taskRestService.getTaskLogs(task.getId(), 0, 1);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
    }

    @Test
    public void testRemoveTaskFromLabel() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        ProjectDto project = new ProjectDto();
        project.setId(1L);
        HashSet<String> manager = new HashSet<String>();
        manager.add("root");
        project.setManager(manager);
        StatusDto status = new StatusDto();
        status.setId(Long.valueOf(1L));
        status.setName("status 1");
        status.setProject(project);
        TaskDto task = new TaskDto();
        task.setId(1L);
        task.setCreatedBy("root");
        task.setAssignee("root");
        task.setStatus(status);
        this.taskService.createTask(task);
        LabelDto label1 = new LabelDto();
        label1.setId(1L);
        label1.setName("label1");
        label1.setProject(project);
        LabelDto label2 = new LabelDto();
        label2.setId(2L);
        label2.setName("label2");
        label2.setProject(project);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(project.getId()))).thenReturn((Object)project);
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task);
        Response response = taskRestService.addTaskToLabel(label1, 1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        LabelDto addedLabel = (LabelDto)response.getEntity();
        Assert.assertNotNull((Object)addedLabel);
        Response response1 = taskRestService.removeTaskFromLabel(1L, 1L);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response1.getStatus());
        Mockito.when((Object)this.labelService.getLabel(1L)).thenReturn((Object)label1);
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task);
        Response response2 = taskRestService.removeTaskFromLabel(1L, 1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response2.getStatus());
        TaskDto addedLabel1 = (TaskDto)response1.getEntity();
        Assert.assertNull((Object)addedLabel1);
    }

    @Test
    public void testAddLabel() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        ProjectDto project = new ProjectDto();
        project.setId(1L);
        HashSet<String> manager = new HashSet<String>();
        manager.add("root");
        project.setManager(manager);
        LabelDto label1 = new LabelDto();
        label1.setId(1L);
        label1.setName("label1");
        label1.setProject(project);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(project.getId()))).thenReturn((Object)project);
        Response response = taskRestService.addLabel(label1);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        LabelDto addedLabel = (LabelDto)response.getEntity();
        Assert.assertNotNull((Object)addedLabel);
    }

    @Test
    public void testRemoveLabel() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        ProjectDto project = new ProjectDto();
        project.setId(1L);
        HashSet<String> manager = new HashSet<String>();
        manager.add("root");
        project.setManager(manager);
        LabelDto label1 = new LabelDto();
        label1.setId(1L);
        label1.setName("label1");
        label1.setProject(project);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(project.getId()))).thenReturn((Object)project);
        Mockito.when((Object)this.labelService.getLabel(1L)).thenReturn((Object)label1);
        Response response = taskRestService.addLabel(label1);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        LabelDto addedLabel = (LabelDto)response.getEntity();
        Assert.assertNotNull((Object)addedLabel);
        Response response2 = taskRestService.removeLabel(1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response2.getStatus());
    }

    @Test
    public void testAddTaskComment() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        TaskDto task = new TaskDto();
        task.setId(1L);
        task.setCreatedBy("john");
        task.setAssignee("john");
        this.taskService.createTask(task);
        CommentDto comment = new CommentDto();
        comment.setId(1L);
        ArrayList<CommentDto> comments = new ArrayList<CommentDto>();
        comments.add(comment);
        Mockito.when((Object)this.commentService.addComment(task, john.getUserId(), "commentText")).thenReturn((Object)comment);
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task);
        Response response = taskRestService.addTaskComment("commentText", 1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CommentEntity commentModel = (CommentEntity)response.getEntity();
        Assert.assertNotNull((Object)commentModel);
        Assert.assertEquals((Object)commentModel.getFormattedComment(), (Object)CommentUtil.formatMention((String)"commentText", (String)Locale.ENGLISH.getLanguage(), (UserService)this.userService));
        response = taskRestService.addTaskComment("", 1L);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        response = taskRestService.addTaskComment("x%20%3C%3D%202", 1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        commentModel = (CommentEntity)response.getEntity();
        Assert.assertNotNull((Object)commentModel);
        Assert.assertEquals((Object)commentModel.getFormattedComment(), (Object)CommentUtil.formatMention((String)"x <= 2", (String)Locale.ENGLISH.getLanguage(), (UserService)this.userService));
        response = taskRestService.getTaskComments(3L, 0, 1);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        response = taskRestService.getTaskComments(1L, 0, 1);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testfindUsersToMention() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        ProjectDto project1 = new ProjectDto();
        project1.setName("project1");
        final User user = TestUtils.getUser();
        ListAccess<User> lists = new ListAccess<User>(){

            public User[] load(int i, int i1) throws Exception, IllegalArgumentException {
                return new User[]{user};
            }

            public int getSize() throws Exception {
                return 1;
            }
        };
        Mockito.when((Object)this.userService.findUserByName("root")).thenReturn((Object)lists);
        Mockito.when((Object)this.taskService.isExternal("root")).thenReturn((Object)false);
        Response response = taskRestService.findUsersToMention("root");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testDeleteComment() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        TaskDto task = new TaskDto();
        task.setId(1L);
        task.setCreatedBy("john");
        task.setAssignee("john");
        this.taskService.createTask(task);
        CommentDto comment = new CommentDto();
        comment.setId(1L);
        comment.setAuthor(john.getUserId());
        Mockito.when((Object)this.commentService.addComment(task, john.getUserId(), "commentText")).thenReturn((Object)comment);
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task);
        Response response = taskRestService.addTaskComment("commentText", 1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CommentEntity commentModel = (CommentEntity)response.getEntity();
        Assert.assertNotNull((Object)commentModel);
        Assert.assertEquals((Object)commentModel.getFormattedComment(), (Object)CommentUtil.formatMention((String)"commentText", (String)Locale.ENGLISH.getLanguage(), (UserService)this.userService));
        response = taskRestService.addTaskComment("x%20%3C%3D%202", 1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        commentModel = (CommentEntity)response.getEntity();
        Assert.assertNotNull((Object)commentModel);
        Assert.assertEquals((Object)commentModel.getFormattedComment(), (Object)CommentUtil.formatMention((String)"x <= 2", (String)Locale.ENGLISH.getLanguage(), (UserService)this.userService));
        Mockito.when((Object)this.commentService.getComment(1L)).thenReturn(null);
        response = taskRestService.deleteComment(1L);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        comment.setAuthor(john.getUserId());
        Mockito.when((Object)this.commentService.getComment(1L)).thenReturn((Object)comment);
        response = taskRestService.deleteComment(1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.commentService.getComment(1L)).thenReturn((Object)comment);
        ConversationState.setCurrent((ConversationState)new ConversationState(null));
        response = taskRestService.deleteComment(1L);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testAddTaskSubComment() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        TaskDto task = new TaskDto();
        task.setId(1L);
        task.setCreatedBy("john");
        task.setAssignee("john");
        this.taskService.createTask(task);
        CommentDto comment = new CommentDto();
        comment.setId(1L);
        comment.setComment("commentText");
        Mockito.when((Object)this.commentService.addComment(task, 1L, john.getUserId(), "commentText")).thenReturn((Object)comment);
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task);
        Response response = taskRestService.addTaskSubComment("commentText", 1L, 1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CommentEntity commentModel = (CommentEntity)response.getEntity();
        Assert.assertNotNull((Object)commentModel);
        Assert.assertEquals((Object)commentModel.getFormattedComment(), (Object)CommentUtil.formatMention((String)"commentText", (String)Locale.ENGLISH.getLanguage(), (UserService)this.userService));
        response = taskRestService.addTaskSubComment("", 1L, 1L);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        response = taskRestService.addTaskSubComment("x%20%3C%3D%202", 1L, 1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        commentModel = (CommentEntity)response.getEntity();
        Assert.assertNotNull((Object)commentModel);
        Assert.assertEquals((Object)commentModel.getFormattedComment(), (Object)CommentUtil.formatMention((String)"x <= 2", (String)Locale.ENGLISH.getLanguage(), (UserService)this.userService));
    }

    @Test
    public void testFilterTasks() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        TaskDto task1 = new TaskDto();
        TaskDto task2 = new TaskDto();
        TaskDto task3 = new TaskDto();
        task1.setAssignee("root");
        task2.setTitle("exo");
        task3.setPriority(Priority.NORMAL);
        String Id = "due@null";
        ViewState viewState = new ViewState(Id);
        viewState.setGroupBy(null);
        viewState.setOrderBy(null);
        ViewState.Filter filter = new ViewState.Filter(Id);
        filter.setAssignees(null);
        filter.setDue(null);
        filter.setKeyword("exo");
        ArrayList labelIDs = new ArrayList();
        ArrayList assignee = new ArrayList();
        ArrayList coworkers = new ArrayList();
        ArrayList watchers = new ArrayList();
        TasksList tasksList = new TasksList(Collections.singletonList(task2), 1L);
        Mockito.when((Object)this.taskService.filterTasks("exo", -2L, "exo", labelIDs, null, null, assignee, coworkers, watchers, null, null, root, null, null, null, false, true, false, false, null, null, 0, 0)).thenReturn((Object)tasksList);
        Response response = taskRestService.filterTasks(null, -2L, "exo", null, null, null, null, null, false, null, null, null, null, null, null, null, 0, 0, false, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        PaginatedTaskList tasks = (PaginatedTaskList)response.getEntity();
        Assert.assertNotNull((Object)tasks.getTasks());
        Assert.assertEquals((long)1L, (long)tasks.getTasksNumber());
        Mockito.when((Object)this.taskService.filterTasks("exo", -2L, "exo", labelIDs, null, null, assignee, coworkers, watchers, null, null, root, null, null, null, false, true, false, false, "priority", "project", 0, 0)).thenReturn((Object)tasksList);
        Response response1 = taskRestService.filterTasks(null, -2L, "exo", null, null, null, null, null, false, null, null, "project", "priority", null, null, null, 0, 0, false, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
        Identity exo = new Identity(null);
        ConversationState.setCurrent((ConversationState)new ConversationState(exo));
        Response response2 = taskRestService.filterTasks(null, -2L, "exo", null, null, null, null, null, false, null, null, "project", "priority", null, null, null, 0, 0, false, false);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response2.getStatus());
    }

    @Test
    public void testUpdateCompleted() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        TaskDto task = new TaskDto();
        task.setId(1L);
        task.setCreatedBy("root");
        task.setAssignee("root");
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task);
        Response response = taskRestService.updateCompleted(1L, true);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }
}

