/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao.jpa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.Query;
import org.exoplatform.task.dao.condition.AggregateCondition;
import org.exoplatform.task.dao.condition.Condition;
import org.exoplatform.task.dao.condition.SingleCondition;
import org.exoplatform.task.dao.jpa.CommentDAOImpl;
import org.exoplatform.task.dao.jpa.DAOHandlerJPAImpl;
import org.exoplatform.task.dao.jpa.JPAQueryListAccess;

public abstract class CommonJPADAO<E, K extends Serializable>
extends GenericDAOJPAImpl<E, K> {
    public Map<String, Class> clz = new ConcurrentHashMap<String, Class>();

    protected <E> List<E> cloneEntities(List<E> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<E> result = new ArrayList<E>(list.size());
        for (E e : list) {
            E cloned = this.cloneEntity(e);
            result.add(cloned);
        }
        return result;
    }

    protected <E> E cloneEntity(E e) {
        return DAOHandlerJPAImpl.clone(e);
    }

    public E find(K id) {
        return (E)this.cloneEntity(super.find(id));
    }

    public E create(E entity) {
        return (E)this.cloneEntity(super.create(entity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListAccess<E> findEntities(Query query, Class<E> clazz) {
        final ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(new ClassLoader(cl){

                @Override
                public Class<?> loadClass(String name) throws ClassNotFoundException {
                    Class<?> c = CommonJPADAO.this.getCache().get(name);
                    if (c == null) {
                        try {
                            c = cl.loadClass(name);
                            CommonJPADAO.this.getCache().put(name, c);
                        }
                        catch (Exception e) {
                            CommonJPADAO.this.getCache().put(name, CommentDAOImpl.class);
                        }
                    }
                    if (c.getName().equals(CommentDAOImpl.class.getName())) {
                        return null;
                    }
                    return c;
                }
            });
            EntityManager em = this.getEntityManager();
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery q = cb.createQuery();
            q.distinct(true);
            Root root = q.from(clazz);
            Predicate predicate = this.buildQuery(query.getCondition(), root, cb, q);
            if (predicate != null) {
                q.where((Expression)predicate);
            }
            q.select((Selection)cb.countDistinct((Expression)root));
            TypedQuery countQuery = em.createQuery(q);
            ArrayList<Object> selections = new ArrayList<Object>();
            selections.add(root);
            List<OrderBy> orderby = query.getOrderBy();
            if (orderby != null && !orderby.isEmpty()) {
                ArrayList<Order> orders = new ArrayList<Order>(orderby.size());
                for (OrderBy orderBy : orderby) {
                    Order order;
                    Path p = root.get(orderBy.getFieldName());
                    if (orderBy.isAscending()) {
                        Expression nullCase = cb.selectCase().when((Expression)p.isNull(), (Object)1).otherwise((Object)0);
                        selections.add(nullCase);
                        orders.add(cb.asc(nullCase));
                        order = cb.asc((Expression)p);
                    } else {
                        order = cb.desc((Expression)p);
                    }
                    orders.add(order);
                }
                q.orderBy(orders);
            }
            q.multiselect(selections).distinct(true);
            TypedQuery selectQuery = em.createQuery(q);
            JPAQueryListAccess<E> jPAQueryListAccess = new JPAQueryListAccess<E>(clazz, (TypedQuery<Long>)countQuery, selectQuery);
            return jPAQueryListAccess;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    protected Predicate buildQuery(Condition condition, Root<E> root, CriteriaBuilder cb, CriteriaQuery query) {
        if (condition == null) {
            return null;
        }
        if (condition instanceof SingleCondition) {
            return this.buildSingleCondition((SingleCondition)condition, root, cb, query);
        }
        if (condition instanceof AggregateCondition) {
            AggregateCondition agg = (AggregateCondition)condition;
            String type = agg.getType();
            List<Condition> cds = agg.getConditions();
            Predicate[] ps = new Predicate[cds.size()];
            for (int i = 0; i < ps.length; ++i) {
                ps[i] = this.buildQuery(cds.get(i), root, cb, query);
            }
            if (ps.length == 1) {
                return ps[0];
            }
            if ("and".equals(type)) {
                return cb.and(ps);
            }
            if ("or".equals(type)) {
                return cb.or(ps);
            }
        }
        return null;
    }

    protected <T> Predicate buildSingleCondition(SingleCondition<T> condition, Root<E> root, CriteriaBuilder cb, CriteriaQuery query) {
        String type = condition.getType();
        T value = condition.getValue();
        Path path = this.buildPath(condition, root);
        if ("eq".equals(condition.getType())) {
            return cb.equal((Expression)path, value);
        }
        if ("lt".equals(condition.getType())) {
            return cb.lessThan((Expression)path, (Comparable)value);
        }
        if ("gt".equals(condition.getType())) {
            return cb.greaterThan((Expression)path, (Comparable)value);
        }
        if ("lte".equals(condition.getType())) {
            return cb.lessThanOrEqualTo((Expression)path, (Comparable)value);
        }
        if ("gte".equals(condition.getType())) {
            return cb.greaterThanOrEqualTo((Expression)path, (Comparable)value);
        }
        if ("null".equals(type)) {
            return path.isNull();
        }
        if ("not_null".equals(type)) {
            return path.isNotNull();
        }
        if ("empty".equals(type)) {
            return cb.isEmpty((Expression)path);
        }
        if ("like".equals(type)) {
            return cb.like(cb.lower((Expression)path), String.valueOf(value));
        }
        if ("in".equals(type)) {
            return path.in((Collection)value);
        }
        if ("is_true".equals(type)) {
            return cb.isTrue((Expression)path);
        }
        if ("is_false".equals(type)) {
            return cb.isFalse((Expression)path);
        }
        throw new RuntimeException("Condition type " + type + " is not supported");
    }

    protected Path buildPath(SingleCondition condition, Root<E> root) {
        String field = condition.getField();
        Join join = null;
        if (field.indexOf(46) > 0) {
            String[] arr = field.split("\\.");
            for (int i = 0; i < arr.length - 1; ++i) {
                String s = arr[i];
                join = join == null ? root.join(s, JoinType.INNER) : join.join(s, JoinType.INNER);
            }
            field = arr[arr.length - 1];
        }
        return join == null ? root.get(field) : join.get(field);
    }

    public Map<String, Class> getCache() {
        return this.clz;
    }
}

