/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.condition.AggregateCondition;
import org.exoplatform.task.dao.condition.Condition;
import org.exoplatform.task.dao.condition.Conditions;

public abstract class Query
implements Cloneable {
    private AggregateCondition aggCondition = null;
    private List<OrderBy> orderBy = new ArrayList<OrderBy>();

    public Query() {
    }

    public Query(AggregateCondition aggCondition, List<OrderBy> orderBy) {
        this.aggCondition = aggCondition;
        this.orderBy = orderBy;
    }

    public void setId(long taskId) {
        this.add(Conditions.eq(Conditions.ID, taskId));
    }

    public Query add(Query query) {
        this.add(query.getCondition());
        return this;
    }

    public Query add(Condition condition) {
        if (condition == null) {
            return this;
        }
        if (this.aggCondition == null) {
            this.aggCondition = Conditions.and(condition);
        } else {
            this.aggCondition.add(condition);
        }
        return this;
    }

    public Condition getCondition() {
        return this.aggCondition;
    }

    public List<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(List<OrderBy> orderBy) {
        this.orderBy = orderBy;
    }
}

