/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.model;

import java.util.ResourceBundle;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.task.util.UserUtil;

public class Permission {
    public static final int USER = 1;
    public static final int GROUP = 2;
    private int type;
    private String id;
    private String displayName;
    private String membershipType;
    private String groupId;
    private String groupName;

    public Permission(int type, String id, String displayName) {
        this.id = id;
        this.displayName = displayName;
        this.type = type;
    }

    public static Permission parse(String permission, ResourceBundle bundle, OrganizationService orgService) {
        if (permission == null || permission.isEmpty()) {
            return null;
        }
        int index = permission.indexOf(58);
        if (index == -1) {
            String displayName = permission;
            try {
                User user = orgService.getUserHandler().findUserByName(permission);
                displayName = UserUtil.getDisplayName(user);
            }
            catch (Exception user) {
                // empty catch block
            }
            return new Permission(1, permission, displayName);
        }
        Permission perm = new Permission(2, permission, permission);
        String membershipType = permission.substring(0, index);
        String groupId = permission.substring(index + 1);
        perm.setMembershipType(membershipType);
        perm.setGroupId(groupId);
        try {
            Group g = orgService.getGroupHandler().findGroupById(groupId);
            perm.setGroupName(g.getLabel());
            String displayName = ("*".equals(membershipType) ? bundle.getString("label.any") : membershipType) + " " + bundle.getString("label.in") + " " + g.getLabel();
            perm.setDisplayName(displayName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return perm;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getMembershipType() {
        return this.membershipType;
    }

    public void setMembershipType(String membershipType) {
        this.membershipType = membershipType;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }
}

